/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols.pbcast;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.javagroups.Header;
import org.javagroups.util.Range;

public class NakAckHeader
extends Header {
    public static final int MSG = 1;
    public static final int XMIT_REQ = 2;
    int type = 0;
    long seqno = -1L;
    Range range = null;

    public NakAckHeader() {
    }

    public NakAckHeader(int type, long seqno) {
        this.type = type;
        this.seqno = seqno;
    }

    public NakAckHeader(int type, long low, long high) {
        this.type = type;
        this.range = new Range(low, high);
    }

    public long size() {
        return 512L;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.type);
        out.writeLong(this.seqno);
        if (this.range != null) {
            out.writeBoolean(true);
            this.range.writeExternal(out);
        } else {
            out.writeBoolean(false);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = in.readInt();
        this.seqno = in.readLong();
        boolean read_range = in.readBoolean();
        if (read_range) {
            this.range = new Range();
            this.range.readExternal(in);
        }
    }

    public NakAckHeader copy() {
        NakAckHeader ret = new NakAckHeader(this.type, this.seqno);
        ret.range = this.range;
        return ret;
    }

    public static String type2Str(int t) {
        switch (t) {
            case 1: {
                return "MSG";
            }
            case 2: {
                return "XMIT_REQ";
            }
        }
        return "<undefined>";
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("[NAKACK: " + NakAckHeader.type2Str(this.type) + ", seqno=" + this.seqno + ", range=" + this.range + "]");
        return ret.toString();
    }
}

