/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols.pbcast;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Header;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.log.Trace;
import org.javagroups.protocols.pbcast.Digest;
import org.javagroups.stack.Protocol;
import org.javagroups.util.Promise;
import org.javagroups.util.TimeScheduler;
import org.javagroups.util.Util;

public class STABLE
extends Protocol {
    Address local_addr = null;
    Vector mbrs = new Vector();
    Digest digest = new Digest();
    Promise digest_promise = new Promise();
    Vector heard_from = new Vector();
    long digest_timeout = 10000L;
    long desired_avg_gossip = 20000L;
    long stability_delay = 6000L;
    StabilitySendTask stability_task = null;
    Object stability_mutex = new Object();
    StableTask stable_task = null;
    TimeScheduler timer = null;
    int max_gossip_runs = 3;
    int num_gossip_runs = 3;

    public String getName() {
        return "STABLE";
    }

    public Vector requiredUpServices() {
        Vector<Integer> retval = new Vector<Integer>();
        retval.addElement(new Integer(45));
        return retval;
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("digest_timeout");
        if (str != null) {
            this.digest_timeout = new Long(str);
            ((Hashtable)props).remove("digest_timeout");
        }
        if ((str = props.getProperty("desired_avg_gossip")) != null) {
            this.desired_avg_gossip = new Long(str);
            ((Hashtable)props).remove("desired_avg_gossip");
        }
        if ((str = props.getProperty("stability_delay")) != null) {
            this.stability_delay = new Long(str);
            ((Hashtable)props).remove("stability_delay");
        }
        if ((str = props.getProperty("max_gossip_runs")) != null) {
            this.num_gossip_runs = this.max_gossip_runs = new Integer(str).intValue();
            ((Hashtable)props).remove("max_gossip_runs");
        }
        if (((Hashtable)props).size() > 0) {
            System.err.println("STABLE.setProperties(): these properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void up(Event evt) {
        int type = evt.getType();
        switch (evt.getType()) {
            case 5: {
                Message msg = (Message)evt.getArg();
                Header obj = msg.peekHeader();
                if (obj == null || !(obj instanceof StableHeader)) break;
                StableHeader hdr = (StableHeader)msg.removeHeader();
                switch (hdr.type) {
                    case 1: {
                        this.handleStableGossip(msg.getSrc(), hdr.digest);
                        break;
                    }
                    case 2: {
                        this.handleStabilityMessage(hdr.digest);
                        break;
                    }
                    default: {
                        Trace.error("STABLE.up()", "StableHeader type " + hdr.type + " not known");
                    }
                }
                return;
            }
            case 12: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 1: {
                if (this.stack != null && this.stack.timer != null) {
                    this.timer = this.stack.timer;
                    break;
                }
                Trace.error("STABLE.up()", "[START]: timer cannot be retrieved from protocol stack");
            }
        }
        this.passUp(evt);
        if (type == 10 || type == 5) {
            this.startStableTask();
        }
    }

    public void down(Event evt) {
        int type = evt.getType();
        if (type == 10 || type == 5) {
            this.startStableTask();
        }
        switch (evt.getType()) {
            case 10: {
                View v = (View)evt.getArg();
                Vector tmp = v.getMembers();
                this.mbrs.removeAllElements();
                this.mbrs.addAll(tmp);
                this.heard_from.retainAll(tmp);
                break;
            }
            case 3: {
                this.stopStableTask();
                break;
            }
            case 46: {
                this.digest_promise.setResult(evt.getArg());
                return;
            }
        }
        this.passDown(evt);
    }

    void initialize() {
        Digest digest = this.digest;
        synchronized (digest) {
            this.digest.reset(this.mbrs.size());
            int i = 0;
            while (i < this.mbrs.size()) {
                this.digest.add((Address)this.mbrs.elementAt(i), -1L, -1L);
                ++i;
            }
            this.heard_from.removeAllElements();
            this.heard_from.addAll(this.mbrs);
        }
    }

    void startStableTask() {
        this.num_gossip_runs = this.max_gossip_runs;
        if (this.stable_task != null && !this.stable_task.cancelled()) {
            return;
        }
        this.stable_task = new StableTask();
        this.timer.add(this.stable_task, true);
        if (Trace.trace) {
            Trace.info("STABLE.startStableTask()", "stable task started; num_gossip_runs=" + this.num_gossip_runs + ", max_gossip_runs=" + this.max_gossip_runs);
        }
    }

    void stopStableTask() {
        if (this.stable_task != null) {
            this.stable_task.stop();
            this.stable_task = null;
        }
    }

    void handleStableGossip(Address sender, Digest d) {
        if (d == null || sender == null) {
            if (Trace.trace) {
                Trace.error("STABLE.handleStableGossip()", "digest or sender is null");
            }
            return;
        }
        if (Trace.trace) {
            Trace.info("STABLE.handleStableGossip()", "received digest " + this.printStabilityDigest(d) + " from " + sender);
        }
        if (!this.heard_from.contains(sender)) {
            if (Trace.trace) {
                Trace.info("STABLE.handleStableGossip()", "already received gossip from " + sender);
            }
            return;
        }
        int i = 0;
        while (i < d.size()) {
            Address mbr = d.senderAt(i);
            long highest_seqno = d.highSeqnoAt(i);
            long highest_seen_seqno = d.highSeqnoSeenAt(i);
            int index = this.digest.getIndex(mbr);
            if (index == -1) {
                if (Trace.trace) {
                    Trace.info("STABLE.handleStableGossip()", "sender " + mbr + " not found in stability vector");
                }
            } else {
                long my_highest_seen_seqno;
                long my_highest_seqno = this.digest.highSeqnoAt(mbr);
                if (my_highest_seqno < 0L) {
                    if (highest_seqno >= 0L) {
                        this.digest.setHighSeqnoAt(mbr, highest_seqno);
                    }
                } else {
                    this.digest.setHighSeqnoAt(mbr, Math.min(my_highest_seqno, highest_seqno));
                }
                if ((my_highest_seen_seqno = this.digest.highSeqnoSeenAt(mbr)) < 0L) {
                    if (highest_seen_seqno >= 0L) {
                        this.digest.setHighSeqnoSeenAt(mbr, highest_seen_seqno);
                    }
                } else {
                    this.digest.setHighSeqnoSeenAt(mbr, Math.max(my_highest_seen_seqno, highest_seen_seqno));
                }
            }
            ++i;
        }
        this.heard_from.removeElement(sender);
        if (this.heard_from.size() == 0) {
            if (Trace.trace) {
                Trace.info("STABLE.handleStableGossip()", "sending stability msg " + this.printStabilityDigest(this.digest));
            }
            this.sendStabilityMessage(this.digest.copy());
            this.initialize();
        }
    }

    void sendStabilityMessage(Digest tmp) {
        if (this.timer == null) {
            if (Trace.trace) {
                Trace.error("STABLE.sendStabilityMessage()", "timer is null, cannot schedule stability message to be sent");
            }
            this.timer = this.stack != null ? this.stack.timer : null;
            return;
        }
        long delay = Util.random(this.stability_delay);
        if (Trace.trace) {
            Trace.info("STABLE.sendStabilityMessage()", "stability_task=" + this.stability_task + ", delay is " + delay);
        }
        Object object = this.stability_mutex;
        synchronized (object) {
            if (this.stability_task != null && !this.stability_task.cancelled()) {
                return;
            }
            this.stability_task = new StabilitySendTask(this, tmp, delay);
            this.timer.add(this.stability_task, true);
        }
    }

    void handleStabilityMessage(Digest d) {
        if (d == null) {
            if (Trace.trace) {
                Trace.error("STABLE.handleStabilityMessage()", "stability vector is null");
            }
            return;
        }
        if (Trace.trace) {
            Trace.info("STABLE.handleStabilityMessage()", "stability vector is " + d.printHighSeqnos());
        }
        Object object = this.stability_mutex;
        synchronized (object) {
            if (this.stability_task != null) {
                if (Trace.trace) {
                    Trace.info("STABLE.handleStabilityMessage()", "cancelling stability task (running=" + !this.stability_task.cancelled() + ")");
                }
                this.stability_task.stop();
                this.stability_task = null;
            }
        }
        this.passUp(new Event(36, d));
    }

    String printStabilityDigest(Digest d) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        if (d != null) {
            int i = 0;
            while (i < d.size()) {
                if (!first) {
                    sb.append(", ");
                } else {
                    first = false;
                }
                sb.append(d.senderAt(i) + "#" + d.highSeqnoAt(i) + " (" + d.highSeqnoSeenAt(i) + ")");
                ++i;
            }
        }
        return sb.toString();
    }

    private static class StabilitySendTask
    implements TimeScheduler.Task {
        Digest d = null;
        Protocol stable_prot = null;
        boolean stopped = false;
        long delay = 2000L;

        public StabilitySendTask(Protocol stable_prot, Digest d, long delay) {
            this.stable_prot = stable_prot;
            this.d = d;
            this.delay = delay;
        }

        public void stop() {
            this.stopped = true;
        }

        public boolean cancelled() {
            return this.stopped;
        }

        public long nextInterval() {
            return this.delay;
        }

        public void run() {
            if (this.d != null && !this.stopped) {
                Message msg = new Message();
                StableHeader hdr = new StableHeader(2, this.d);
                msg.addHeader(hdr);
                this.stable_prot.passDown(new Event(5, msg));
                this.d = null;
            }
            this.stopped = true;
        }
    }

    private class StableTask
    implements TimeScheduler.Task {
        boolean stopped = false;

        private StableTask() {
        }

        public void reset() {
            this.stopped = false;
        }

        public void stop() {
            this.stopped = true;
        }

        public boolean cancelled() {
            return this.stopped;
        }

        public long nextInterval() {
            long interval = this.computeSleepTime();
            if (interval <= 0L) {
                return 10000L;
            }
            return interval;
        }

        public void run() {
            STABLE.this.initialize();
            this.sendStableMessage();
            --STABLE.this.num_gossip_runs;
            if (STABLE.this.num_gossip_runs <= 0) {
                if (Trace.trace) {
                    Trace.info("STABLE.StableTask.run()", "stable task terminating (num_gossip_runs=" + STABLE.this.num_gossip_runs + ", max_gossip_runs=" + STABLE.this.max_gossip_runs + ")");
                }
                this.stop();
            }
        }

        long computeSleepTime() {
            return this.getRandom((long)STABLE.this.mbrs.size() * STABLE.this.desired_avg_gossip * 2L);
        }

        long getRandom(long range) {
            return (long)(Math.random() * (double)range % (double)range);
        }

        void sendStableMessage() {
            Digest d = null;
            Message msg = new Message();
            d = this.getDigest();
            if (d != null && d.size() > 0) {
                if (Trace.trace) {
                    Trace.info("STABLE.sendStableMessage()", "mcasting digest " + d);
                }
                StableHeader hdr = new StableHeader(1, d);
                msg.addHeader(hdr);
                STABLE.this.passDown(new Event(5, msg));
            }
        }

        Digest getDigest() {
            Digest ret = null;
            STABLE.this.passUp(new Event(45));
            ret = (Digest)STABLE.this.digest_promise.getResult(STABLE.this.digest_timeout);
            if (ret == null) {
                Trace.error("STABLE.getDigest()", "digest could not be fetched (from above). Timeout was " + STABLE.this.digest_timeout + " msecs");
            }
            return ret;
        }
    }

    private static class StableHeader
    extends Header {
        static final int STABLE_GOSSIP = 1;
        static final int STABILITY = 2;
        int type = 0;
        Digest digest = new Digest();

        public StableHeader() {
        }

        StableHeader(int type, Digest digest) {
            this.type = type;
            this.digest = digest;
        }

        static String type2String(int t) {
            switch (t) {
                case 1: {
                    return "STABLE_GOSSIP";
                }
                case 2: {
                    return "STABILITY";
                }
            }
            return "<unknown>";
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("[");
            sb.append(StableHeader.type2String(this.type));
            sb.append("]: digest is ");
            sb.append(this.digest);
            return sb.toString();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
            this.digest.writeExternal(out);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
            this.digest = new Digest();
            this.digest.readExternal(in);
        }
    }
}

