/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols.ring;

import org.javagroups.log.Trace;
import org.javagroups.protocols.ring.RingToken;

public class RingNodeFlowControl {
    int initialWindow;
    float windowReduceFactor;
    int belowThresholdAdvanceAmount;
    float aboveThresholdAdvanceAmount;
    private int memberCount;
    private int previousBacklog;
    private int backlog;

    public RingNodeFlowControl(int initialWindow, float windowReduceFactor, int belowThresholdAdvanceAmount, float aboveThresholdAdvanceAmount) {
        this.initialWindow = initialWindow;
        this.windowReduceFactor = windowReduceFactor;
        this.belowThresholdAdvanceAmount = belowThresholdAdvanceAmount;
        this.aboveThresholdAdvanceAmount = aboveThresholdAdvanceAmount;
    }

    public RingNodeFlowControl() {
        this(0, 0.5f, 2, 1.0f);
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public int getBacklogDifference() {
        return this.backlog - this.previousBacklog;
    }

    public int getPreviousBacklog() {
        return this.previousBacklog;
    }

    public void setPreviousBacklog() {
        this.previousBacklog = this.backlog;
    }

    public void viewChanged(int memberCount) {
        this.memberCount = memberCount;
    }

    public int getAllowedToBroadcast(RingToken token) {
        int backlogAverage;
        int fairWindowShare = 0;
        int windowSize = token.getWindowSize();
        int maxMessages = windowSize / this.memberCount;
        if (maxMessages < 1) {
            maxMessages = 1;
        }
        if ((backlogAverage = token.getBacklog() + this.backlog - this.previousBacklog) > 0) {
            fairWindowShare = windowSize * this.backlog / backlogAverage;
        }
        fairWindowShare = fairWindowShare < 1 ? 0 : fairWindowShare;
        int maxAllowed = windowSize - token.getLastRoundBroadcastCount();
        if (maxAllowed < 1) {
            maxAllowed = 0;
        }
        if (Trace.trace) {
            Trace.info("RingNodeFlowControl.getAllowedToBroadcast, minimum of ", "fairWindowShare=" + fairWindowShare + " maxMessages=" + maxMessages + " maxAllowed=" + maxAllowed);
        }
        return fairWindowShare < maxAllowed ? Math.min(fairWindowShare, maxMessages) : Math.min(maxAllowed, maxMessages);
    }

    public void updateWindow(RingToken token) {
        boolean congested;
        int threshold = token.getWindowThreshold();
        int window = token.getWindowSize();
        if (window < this.initialWindow) {
            window = this.initialWindow;
        }
        boolean bl = congested = token.getRetransmissionRequests().size() > 0;
        if (congested) {
            threshold = (int)((float)window * this.windowReduceFactor);
            window = this.initialWindow;
        } else {
            window = window < threshold ? (window += this.belowThresholdAdvanceAmount) : (int)((float)window + this.aboveThresholdAdvanceAmount);
        }
        token.setWindowSize(window);
        token.setWindowThreshold(threshold);
    }
}

