/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols.ring;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashSet;

public class RingToken
implements Externalizable {
    private long tokenSeq;
    private long seq;
    private long aru;
    private int fcc;
    private int backlog;
    private int windowSize;
    private int windowThreshold;
    private Collection retransmissionRequests = new HashSet();

    public long getTokenSequence() {
        return this.tokenSeq;
    }

    public void incrementTokenSequence() {
        ++this.tokenSeq;
    }

    public long getHighestSequence() {
        return this.seq;
    }

    public void setHighestSequence(long highestSequence) {
        if (this.seq > highestSequence) {
            throw new IllegalArgumentException("Can not set highest sequence to be lower than current higest sequence " + this.seq);
        }
        this.seq = highestSequence;
    }

    public long getAllReceivedUpto() {
        return this.aru;
    }

    public void setAllReceivedUpto(long aru) {
        this.aru = aru;
    }

    public int getLastRoundBroadcastCount() {
        return this.fcc;
    }

    public void addLastRoundBroadcastCount(int transmitCount) {
        this.fcc += transmitCount;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void addBacklog(int backlog) {
        this.backlog += backlog;
    }

    public void setWindowSize(int newSize) {
        this.windowSize = newSize;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setWindowThreshold(int newSize) {
        this.windowThreshold = newSize;
    }

    public int getWindowThreshold() {
        return this.windowThreshold;
    }

    public Collection getRetransmissionRequests() {
        return this.retransmissionRequests;
    }

    public void writeExternal(ObjectOutput oo) throws IOException {
        oo.writeLong(this.tokenSeq);
        oo.writeLong(this.seq);
        oo.writeLong(this.aru);
        oo.writeInt(this.fcc);
        oo.writeInt(this.backlog);
        oo.writeInt(this.windowSize);
        oo.writeInt(this.windowThreshold);
        oo.writeObject(this.retransmissionRequests);
    }

    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        this.tokenSeq = oi.readLong();
        this.seq = oi.readLong();
        this.aru = oi.readLong();
        this.fcc = oi.readInt();
        this.backlog = oi.readInt();
        this.windowSize = oi.readInt();
        this.windowThreshold = oi.readInt();
        this.retransmissionRequests = (Collection)oi.readObject();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(200);
        buf.append("Token[tokenSeq=").append(this.tokenSeq);
        buf.append(",highestseq=").append(this.seq);
        buf.append(",aru=").append(this.aru);
        buf.append(",lastRoundTransmitCount=").append(this.fcc);
        buf.append(",backlog=").append(this.backlog);
        buf.append(",windowSize=").append(this.windowSize);
        buf.append(",windowThreshold=").append(this.windowThreshold);
        buf.append(",retransmissionList=").append(this.getRetransmissionRequests());
        buf.append("]");
        return buf.toString();
    }
}

