/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols.ring;

import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.SuspectedException;
import org.javagroups.TimeoutException;
import org.javagroups.protocols.ring.RingNode;
import org.javagroups.protocols.ring.TokenLostException;
import org.javagroups.stack.IpAddress;
import org.javagroups.stack.RpcProtocol;

public class UdpRingNode
implements RingNode {
    Address thisNode;
    Address nextNode;
    RpcProtocol rpcProtocol;
    Object token;
    Object mutex = new Object();
    boolean tokenArrived = false;

    public UdpRingNode(RpcProtocol owner, Address memberAddress) {
        this.rpcProtocol = owner;
        this.thisNode = memberAddress;
        this.nextNode = null;
    }

    public IpAddress getTokenReceiverAddress() {
        return (IpAddress)this.thisNode;
    }

    public void tokenArrived(Object token) {
        this.tokenArrived = true;
        this.token = token;
    }

    public Object receiveToken(int timeout) throws TokenLostException {
        if (this.thisNode.equals(this.nextNode)) {
            return this.token;
        }
        Address wasNext = this.nextNode;
        try {
            this.tokenArrived = false;
            RpcProtocol rpcProtocol = this.rpcProtocol;
            synchronized (rpcProtocol) {
                this.rpcProtocol.wait(timeout);
                if (!this.tokenArrived) {
                    throw new TokenLostException("Token wait timout expired", null, wasNext, TokenLostException.WHILE_RECEIVING);
                }
            }
        }
        catch (InterruptedException ie) {
            throw new TokenLostException("Token thread interrupted", (Throwable)ie, this.thisNode, TokenLostException.WHILE_RECEIVING);
        }
        return this.token;
    }

    public Object receiveToken() throws TokenLostException {
        return this.receiveToken(0);
    }

    public void passToken(Object token) throws TokenLostException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.thisNode.equals(this.nextNode)) {
                this.tokenArrived(token);
                RpcProtocol rpcProtocol = this.rpcProtocol;
                synchronized (rpcProtocol) {
                    this.rpcProtocol.notify();
                }
            }
            try {
                this.rpcProtocol.callRemoteMethod(this.nextNode, "passTokenUdp", token, 6, 0L);
            }
            catch (TimeoutException tim) {
                throw new TokenLostException("Token pass timout expired", (Throwable)tim, this.nextNode, TokenLostException.WHILE_SENDING);
            }
            catch (SuspectedException sus) {
                throw new TokenLostException("Token receiver suspected", (Throwable)sus, this.nextNode, TokenLostException.WHILE_SENDING);
            }
        }
    }

    public void reconfigure(Vector newMembers) {
        if (this.isNextNeighbourChanged(newMembers)) {
            Object object = this.mutex;
            synchronized (object) {
                this.nextNode = this.getNextNode(newMembers);
            }
        }
    }

    private boolean isNextNeighbourChanged(Vector newMembers) {
        Address oldNeighbour = this.nextNode;
        Address newNeighbour = this.getNextNode(newMembers);
        return !newNeighbour.equals(oldNeighbour);
    }

    private Address getNextNode(Vector otherNodes) {
        int myIndex = otherNodes.indexOf(this.thisNode);
        return myIndex == otherNodes.size() - 1 ? (Address)otherNodes.firstElement() : (Address)otherNodes.elementAt(myIndex + 1);
    }
}

