/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.stack;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.javagroups.stack.IpAddress;

public class AckMcastReceiverWindow {
    Hashtable msgs = new Hashtable();

    public boolean add(Object sender, long seqno) {
        Vector<Long> seqnos = (Vector<Long>)this.msgs.get(sender);
        Long val = new Long(seqno);
        if (seqnos == null) {
            seqnos = new Vector<Long>();
            seqnos.addElement(val);
            this.msgs.put(sender, seqnos);
            return true;
        }
        if (seqnos.contains(val)) {
            return false;
        }
        seqnos.addElement(val);
        return true;
    }

    public void remove(Object sender, Vector seqnos) {
        Vector v = (Vector)this.msgs.get(sender);
        if (v != null && seqnos != null) {
            int i = 0;
            while (i < seqnos.size()) {
                Long seqno = (Long)seqnos.elementAt(i);
                v.removeElement(seqno);
                ++i;
            }
        }
    }

    public long size() {
        long ret = 0L;
        Enumeration e = this.msgs.elements();
        while (e.hasMoreElements()) {
            ret += (long)((Vector)e.nextElement()).size();
        }
        return ret;
    }

    public void reset() {
        this.removeAll();
    }

    public void removeAll() {
        this.msgs.clear();
    }

    public void suspect(Object sender) {
        this.msgs.remove(sender);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        Enumeration e = this.msgs.keys();
        while (e.hasMoreElements()) {
            Object sender = e.nextElement();
            ret.append(sender + " --> " + this.msgs.get(sender) + "\n");
        }
        return ret.toString();
    }

    public static void main(String[] args) {
        AckMcastReceiverWindow win = new AckMcastReceiverWindow();
        IpAddress sender1 = new IpAddress("janet", 1111);
        IpAddress sender2 = new IpAddress("janet", 4444);
        IpAddress sender3 = new IpAddress("janet", 6767);
        IpAddress sender4 = new IpAddress("janet", 3333);
        win.add(sender1, 1L);
        win.add(sender1, 2L);
        win.add(sender3, 2L);
        win.add(sender2, 2L);
        win.add(sender4, 2L);
        win.add(sender1, 3L);
        win.add(sender1, 2L);
        System.out.println(win);
        win.suspect(sender1);
        System.out.println(win);
        win.add(sender1, 1L);
        win.add(sender1, 2L);
        win.add(sender1, 3L);
        win.add(sender1, 4L);
        win.add(sender1, 5L);
        win.add(sender1, 6L);
        win.add(sender1, 7L);
        win.add(sender1, 8L);
        System.out.println(win);
        Vector<Long> seqnos = new Vector<Long>();
        seqnos.addElement(new Long(4L));
        seqnos.addElement(new Long(6L));
        seqnos.addElement(new Long(8L));
        win.remove(sender2, seqnos);
        System.out.println(win);
        win.remove(sender1, seqnos);
        System.out.println(win);
    }
}

