/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.stack;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Message;
import org.javagroups.log.Trace;
import org.javagroups.util.TimeScheduler;

public class AckMcastSenderWindow {
    private static final long SEC = 1000L;
    private static final long[] RETRANSMIT_TIMEOUTS = new long[]{2000L, 3000L, 5000L, 8000L};
    private static final long SUSPEND_TIMEOUT = 2000L;
    private Hashtable msgs = new Hashtable();
    private Vector stable_msgs = new Vector();
    private boolean waiting = false;
    private boolean retransmitter_owned;
    private TimeScheduler retransmitter = null;
    private long[] retransmit_intervals;
    private RetransmitCommand cmd = null;

    private static String _toString(Throwable ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        return sw.toString();
    }

    private void _retransmit(Entry entry) {
        Entry entry2 = entry;
        synchronized (entry2) {
            Enumeration e = entry.senders.keys();
            while (e.hasMoreElements()) {
                Address sender = (Address)e.nextElement();
                boolean received = (Boolean)entry.senders.get(sender);
                if (received) continue;
                Trace.info("AckMcastSenderWindow", ": --> retransmitting msg #" + entry.seqno + " to " + sender);
                this.cmd.retransmit(entry.seqno, entry.msg.copy(), sender);
            }
        }
    }

    private void init(RetransmitCommand cmd, long[] retransmit_intervals, TimeScheduler sched, boolean sched_owned) {
        if (cmd == null) {
            Trace.error("AckMcastSenderWindow", "command is null. Cannot retransmit messages !");
            throw new IllegalArgumentException("cmd");
        }
        this.retransmitter_owned = sched_owned;
        this.retransmitter = sched;
        this.retransmit_intervals = retransmit_intervals;
        this.cmd = cmd;
        this.start();
    }

    public AckMcastSenderWindow(RetransmitCommand cmd, long[] retransmit_intervals, TimeScheduler sched) {
        this.init(cmd, retransmit_intervals, sched, false);
    }

    public AckMcastSenderWindow(RetransmitCommand cmd, TimeScheduler sched) {
        this.init(cmd, RETRANSMIT_TIMEOUTS, sched, false);
    }

    public AckMcastSenderWindow(RetransmitCommand cmd, long[] retransmit_intervals) {
        this.init(cmd, retransmit_intervals, new TimeScheduler(2000L), true);
    }

    public AckMcastSenderWindow(RetransmitCommand cmd) {
        this(cmd, RETRANSMIT_TIMEOUTS);
    }

    public void add(long seqno, Message msg, Vector receivers) {
        if (this.waiting) {
            return;
        }
        if (receivers.size() == 0) {
            return;
        }
        Hashtable hashtable = this.msgs;
        synchronized (hashtable) {
            if (this.msgs.get(new Long(seqno)) != null) {
                return;
            }
            Entry e = new Entry(seqno, msg, receivers, this.retransmit_intervals);
            this.msgs.put(new Long(seqno), e);
            this.retransmitter.add(e);
        }
    }

    public void ack(long seqno, Address sender) {
        Hashtable hashtable = this.msgs;
        synchronized (hashtable) {
            Entry entry = (Entry)this.msgs.get(new Long(seqno));
            if (entry == null) {
                return;
            }
            Entry entry2 = entry;
            synchronized (entry2) {
                Boolean received = (Boolean)entry.senders.get(sender);
                if (received == null || received.booleanValue()) {
                    return;
                }
                entry.senders.put(sender, new Boolean(true));
                ++entry.num_received;
                if (!entry.allReceived()) {
                    return;
                }
            }
            Vector vector = this.stable_msgs;
            synchronized (vector) {
                entry.cancel();
                this.msgs.remove(new Long(seqno));
                this.stable_msgs.add(new Long(seqno));
            }
            this.msgs.notify();
        }
    }

    public void remove(Address obj) {
        Hashtable hashtable = this.msgs;
        synchronized (hashtable) {
            Enumeration e = this.msgs.keys();
            while (e.hasMoreElements()) {
                Entry entry;
                Long key = (Long)e.nextElement();
                Entry entry2 = entry = (Entry)this.msgs.get(key);
                synchronized (entry2) {
                    if (((Boolean)entry.senders.remove(obj)).booleanValue()) {
                        --entry.num_received;
                    }
                    if (!entry.allReceived()) {
                        continue;
                    }
                }
                Vector vector = this.stable_msgs;
                synchronized (vector) {
                    entry.cancel();
                    this.msgs.remove(key);
                    this.stable_msgs.add(key);
                }
                this.msgs.notify();
            }
        }
    }

    public void suspect(Address suspected) {
        this.remove(suspected);
    }

    public Vector getStableMessages() {
        Vector retval;
        Vector vector = this.stable_msgs;
        synchronized (vector) {
            Vector vector2 = retval = this.stable_msgs.size() > 0 ? (Vector)this.stable_msgs.clone() : null;
            if (this.stable_msgs.size() > 0) {
                this.stable_msgs.clear();
            }
        }
        return retval;
    }

    public long size() {
        Hashtable hashtable = this.msgs;
        synchronized (hashtable) {
            long l = this.msgs.size();
            return l;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitUntilAllAcksReceived(long timeout) {
        block11: {
            block10: {
                time_to_wait = timeout;
                this.waiting = true;
                if (timeout > 0L) break block10;
                var9_3 = this.msgs;
                synchronized (var9_3) {
                    if (true) ** GOTO lbl18
                }
            }
            start_time = System.currentTimeMillis();
            var9_4 = this.msgs;
            synchronized (var9_4) {
                ** GOTO lbl26
            }
            {
                do {
                    try {
                        this.msgs.wait();
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
lbl18:
                    // 3 sources

                } while (this.msgs.size() > 0);
                break block11;
            }
            {
                while ((time_to_wait = timeout - ((current_time = System.currentTimeMillis()) - start_time)) > 0L) {
                    try {
                        this.msgs.wait(time_to_wait);
                    }
                    catch (InterruptedException ex) {
                        Trace.warn("AckMcastSenderWindow.waitUntilAllAcksReceived()", ex.toString());
                    }
lbl26:
                    // 3 sources

                    if (this.msgs.size() > 0) continue;
                }
            }
        }
        this.waiting = false;
    }

    public void start() {
        if (this.retransmitter_owned) {
            this.retransmitter.start();
        }
    }

    public void stop() {
        Hashtable hashtable = this.msgs;
        synchronized (hashtable) {
            if (this.retransmitter_owned) {
                try {
                    this.retransmitter.stop();
                }
                catch (InterruptedException ex) {
                    Trace.error("AckMcastSenderWindow.stop()", AckMcastSenderWindow._toString(ex));
                }
            } else {
                Enumeration e = this.msgs.elements();
                while (e.hasMoreElements()) {
                    Entry entry = (Entry)e.nextElement();
                    entry.cancel();
                }
            }
            this.msgs.clear();
            this.msgs.notify();
        }
    }

    public void reset() {
        if (this.waiting) {
            return;
        }
        Hashtable hashtable = this.msgs;
        synchronized (hashtable) {
            Enumeration e = this.msgs.elements();
            while (e.hasMoreElements()) {
                Entry entry = (Entry)e.nextElement();
                entry.cancel();
            }
            this.msgs.clear();
            this.msgs.notify();
        }
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        Hashtable hashtable = this.msgs;
        synchronized (hashtable) {
            ret.append("msgs: (" + this.msgs.size() + ")");
            Enumeration e = this.msgs.keys();
            while (e.hasMoreElements()) {
                Long key = (Long)e.nextElement();
                Entry entry = (Entry)this.msgs.get(key);
                ret.append("key = " + key + ", value = " + entry + "\n");
            }
            Vector vector = this.stable_msgs;
            synchronized (vector) {
                ret.append("\nstable_msgs: " + this.stable_msgs);
            }
        }
        return ret.toString();
    }

    private class Entry
    extends Task {
        public long seqno;
        public Message msg = null;
        public Hashtable senders = new Hashtable();
        public int num_received = 0;

        public Entry(long seqno, Message msg, Vector dests, long[] intervals) {
            super(intervals);
            this.seqno = seqno;
            this.msg = msg;
            int i = 0;
            while (i < dests.size()) {
                this.senders.put(dests.elementAt(i), new Boolean(false));
                ++i;
            }
        }

        public boolean allReceived() {
            return this.num_received >= this.senders.size();
        }

        public void run() {
            AckMcastSenderWindow.this._retransmit(this);
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append("num_received = " + this.num_received + ", received msgs = " + this.senders);
            return buff.toString();
        }
    }

    private static abstract class Task
    implements TimeScheduler.Task {
        private Times intervals;
        private boolean cancelled;

        protected Task(long[] intervals) {
            this.intervals = new Times(intervals);
            this.cancelled = false;
        }

        public long nextInterval() {
            return this.intervals.next();
        }

        public void cancel() {
            this.cancelled = true;
        }

        public boolean cancelled() {
            return this.cancelled;
        }

        public abstract void run();
    }

    private static class Times {
        private int next = 0;
        private long[] times;

        public Times(long[] times) {
            if (times.length == 0) {
                throw new IllegalArgumentException("times");
            }
            this.times = times;
        }

        public synchronized long next() {
            if (this.next >= this.times.length) {
                return this.times[this.times.length - 1];
            }
            return this.times[this.next++];
        }

        public long[] times() {
            return this.times;
        }

        public synchronized void reset() {
            this.next = 0;
        }
    }

    public static interface RetransmitCommand {
        public void retransmit(long var1, Message var3, Address var4);
    }
}

