/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.stack;

import java.util.TreeSet;
import org.javagroups.Message;
import org.javagroups.log.Trace;

public class AckReceiverWindow {
    long initial_seqno = 0L;
    long next_to_remove = 0L;
    TreeSet msgs = new TreeSet();

    public AckReceiverWindow(long initial_seqno) {
        this.initial_seqno = initial_seqno;
        this.next_to_remove = initial_seqno;
    }

    public void add(long seqno, Message msg) {
        TreeSet treeSet = this.msgs;
        synchronized (treeSet) {
            if (seqno < this.next_to_remove) {
                Trace.warn("AckReceiverWindow.add()", ": discarded msg with seqno=" + seqno + ": next msg to receive is " + this.next_to_remove);
                return;
            }
            this.msgs.add(new Entry(seqno, msg));
        }
    }

    public Message remove() {
        Entry e = null;
        TreeSet treeSet = this.msgs;
        synchronized (treeSet) {
            if (this.msgs.size() > 0) {
                e = (Entry)this.msgs.first();
                if (e.seqno == this.next_to_remove) {
                    this.msgs.remove(e);
                    ++this.next_to_remove;
                    Message message = e.msg;
                    return message;
                }
            }
        }
        return null;
    }

    public void reset() {
        this.msgs.clear();
        this.next_to_remove = this.initial_seqno;
    }

    public String toString() {
        return this.msgs.toString();
    }

    public static void main(String[] args) {
        Message ret;
        AckReceiverWindow win = new AckReceiverWindow(33L);
        Message m = new Message();
        win.add(37L, m);
        System.out.println(win);
        while ((ret = win.remove()) != null) {
            System.out.println("Removed message, win is " + win);
        }
        win.add(35L, m);
        System.out.println(win);
        win.add(36L, m);
        System.out.println(win);
        while ((ret = win.remove()) != null) {
            System.out.println("Removed message, win is " + win);
        }
        win.add(33L, m);
        System.out.println(win);
        win.add(34L, m);
        System.out.println(win);
        win.add(38L, m);
        System.out.println(win);
        while ((ret = win.remove()) != null) {
            System.out.println("Removed message, win is " + win);
        }
        win.add(35L, m);
        System.out.println(win);
        win.add(332L, m);
        System.out.println(win);
    }

    class Entry
    implements Comparable {
        long seqno = 0L;
        Message msg;

        Entry(long seqno, Message msg) {
            this.seqno = seqno;
            this.msg = msg;
        }

        public int compareTo(Object other) {
            Entry e = (Entry)other;
            return this.seqno == e.seqno ? 0 : (this.seqno < e.seqno ? -1 : 1);
        }

        public String toString() {
            return "" + this.seqno;
        }
    }
}

