/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.stack;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import org.javagroups.Message;
import org.javagroups.log.Trace;
import org.javagroups.util.TimeScheduler;
import org.javagroups.util.Util;

public class AckSenderWindow {
    long next_seqno = 0L;
    long timeout;
    long time_to_wait = this.timeout = 2000L;
    long min_wait_time = 500L;
    RetransmitCommand retransmit_command = null;
    TreeSet msgs = new TreeSet();
    RetransmitterTask retransmitter_task = null;
    TimeScheduler timer = null;

    public AckSenderWindow(RetransmitCommand com, long initial_seqno, TimeScheduler timer) {
        this.retransmit_command = com;
        this.next_seqno = initial_seqno;
        this.timer = timer;
        this.start();
    }

    public AckSenderWindow(RetransmitCommand com, long initial_seqno, long timeout, long min_wait_time, TimeScheduler timer) {
        this.retransmit_command = com;
        this.next_seqno = initial_seqno;
        this.timeout = timeout;
        this.min_wait_time = min_wait_time;
        this.timer = timer;
        this.start();
    }

    public long getNextSeqno() {
        return this.next_seqno;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void start() {
        if (this.retransmitter_task != null && !this.retransmitter_task.cancelled()) {
            return;
        }
        this.retransmitter_task = new RetransmitterTask();
        this.timer.add(this.retransmitter_task, true);
    }

    public void stop() {
        if (this.retransmitter_task != null) {
            this.retransmitter_task.stop();
            this.retransmitter_task = null;
        }
    }

    public void reset() {
        this.stop();
        TreeSet treeSet = this.msgs;
        synchronized (treeSet) {
            this.msgs.clear();
        }
    }

    public void add(long seqno, Message msg) {
        boolean inserted = false;
        TreeSet treeSet = this.msgs;
        synchronized (treeSet) {
            if (seqno < this.next_seqno) {
                return;
            }
            this.msgs.add(new Entry(seqno, msg));
            this.start();
        }
    }

    public void ack(long seqno) {
        boolean found = false;
        TreeSet treeSet = this.msgs;
        synchronized (treeSet) {
            Entry entry;
            if (seqno < this.next_seqno) {
                return;
            }
            Iterator it = this.msgs.iterator();
            while (it.hasNext()) {
                entry = (Entry)it.next();
                if (entry.seqno != seqno) continue;
                found = true;
                entry.ack_received = true;
                break;
            }
            if (!found) {
                return;
            }
            Iterator it2 = this.msgs.iterator();
            while (it2.hasNext()) {
                entry = (Entry)it2.next();
                if (this.next_seqno != entry.seqno || !entry.ack_received) break;
                it2.remove();
                ++this.next_seqno;
            }
        }
    }

    public String toString() {
        StringBuffer retval = new StringBuffer();
        TreeSet treeSet = this.msgs;
        synchronized (treeSet) {
            retval.append(this.msgs);
        }
        return retval.toString();
    }

    public static void main(String[] args) {
        TimeScheduler timer = new TimeScheduler(3000L);
        AckSenderWindow win = new AckSenderWindow(new Dummy(), 3L, timer);
        Trace.init();
        win.add(3L, new Message());
        win.add(5L, new Message());
        win.add(4L, new Message());
        win.add(8L, new Message());
        win.add(9L, new Message());
        win.add(6L, new Message());
        win.add(7L, new Message());
        win.add(3L, new Message());
        System.out.println(win);
        try {
            Thread.currentThread();
            Thread.sleep(5000L);
            win.ack(5L);
            System.out.println("ack(5)");
            win.ack(4L);
            System.out.println("ack(4)");
            win.ack(6L);
            System.out.println("ack(6)");
            win.ack(7L);
            System.out.println("ack(7)");
            win.ack(8L);
            System.out.println("ack(8)");
            win.ack(6L);
            System.out.println("ack(6)");
            win.ack(9L);
            System.out.println("ack(9)");
            System.out.println(win);
            Thread.currentThread();
            Thread.sleep(5000L);
            win.ack(3L);
            System.out.println("ack(3)");
            System.out.println(win);
            Thread.currentThread();
            Thread.sleep(3000L);
            win.add(10L, new Message());
            win.add(11L, new Message());
            System.out.println(win);
            Thread.currentThread();
            Thread.sleep(3000L);
            win.ack(10L);
            System.out.println("ack(10)");
            win.ack(11L);
            System.out.println("ack(11)");
            System.out.println(win);
            win.add(12L, new Message());
            win.add(13L, new Message());
            win.add(14L, new Message());
            win.add(15L, new Message());
            win.add(16L, new Message());
            System.out.println(win);
            Util.sleep(1000L);
            win.ack(12L);
            System.out.println("ack(12)");
            win.ack(13L);
            System.out.println("ack(13)");
            win.ack(15L);
            System.out.println("ack(15)");
            System.out.println(win);
            Util.sleep(5000L);
            win.ack(16L);
            System.out.println("ack(16)");
            System.out.println(win);
            Util.sleep(1000L);
            win.ack(14L);
            System.out.println("ack(14)");
            System.out.println(win);
            win.stop();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    static class Dummy
    implements RetransmitCommand {
        Dummy() {
        }

        public void retransmit(long seqno, Message msg, int num_tries) {
        }
    }

    private class RetransmitterTask
    implements TimeScheduler.Task {
        boolean stopped = false;

        private RetransmitterTask() {
        }

        public void stop() {
            this.stopped = true;
        }

        public boolean cancelled() {
            return this.stopped;
        }

        public long nextInterval() {
            Trace.debug("AckSenderWindow.RetransmitterTask.nextInterval()", "interval is " + AckSenderWindow.this.time_to_wait);
            return AckSenderWindow.this.time_to_wait;
        }

        public void run() {
            long current_time = 0L;
            TreeSet treeSet = AckSenderWindow.this.msgs;
            synchronized (treeSet) {
                if (AckSenderWindow.this.msgs.size() > 0) {
                    Entry entry;
                    current_time = System.currentTimeMillis();
                    long earliest_wakeup = current_time + AckSenderWindow.this.timeout + 1L;
                    ArrayList<Entry> retransmits = new ArrayList<Entry>();
                    Iterator it = AckSenderWindow.this.msgs.iterator();
                    while (it.hasNext()) {
                        entry = (Entry)it.next();
                        if (entry.ack_received) continue;
                        if (entry.wakeup_at <= current_time) {
                            if (AckSenderWindow.this.retransmit_command != null) {
                                retransmits.add(entry);
                            }
                            ++entry.num_tries;
                            entry.wakeup_at = current_time + AckSenderWindow.this.timeout;
                        }
                        earliest_wakeup = Math.min(earliest_wakeup, entry.wakeup_at);
                    }
                    Iterator it2 = ((AbstractList)retransmits).iterator();
                    while (it2.hasNext()) {
                        entry = (Entry)it2.next();
                        AckSenderWindow.this.retransmit_command.retransmit(entry.seqno, entry.msg, entry.num_tries);
                    }
                    long tmp_time_to_wait = earliest_wakeup - current_time;
                    tmp_time_to_wait = Math.max(tmp_time_to_wait, AckSenderWindow.this.min_wait_time);
                    AckSenderWindow.this.time_to_wait = Math.min(tmp_time_to_wait, AckSenderWindow.this.timeout + AckSenderWindow.this.min_wait_time);
                    Trace.debug("AckSenderWindow.RetransmitterTask.run()", "time_to_wait=" + AckSenderWindow.this.time_to_wait);
                } else {
                    this.stopped = true;
                }
            }
        }
    }

    class Entry
    implements Comparable {
        long seqno = 0L;
        long wakeup_at;
        Message msg;
        int num_tries;
        boolean ack_received;

        Entry(long seqno, Message msg) {
            this.wakeup_at = System.currentTimeMillis() + AckSenderWindow.this.timeout;
            this.num_tries = 0;
            this.ack_received = false;
            this.seqno = seqno;
            this.msg = msg;
        }

        public int compareTo(Object other) {
            Entry e = (Entry)other;
            return this.seqno == e.seqno ? 0 : (this.seqno < e.seqno ? -1 : 1);
        }

        public String toString() {
            StringBuffer ret = new StringBuffer();
            ret.append(this.seqno);
            if (this.ack_received) {
                ret.append("+");
            } else {
                ret.append("-");
            }
            return ret.toString();
        }
    }

    public static interface RetransmitCommand {
        public void retransmit(long var1, Message var3, int var4);
    }
}

