/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.stack;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.log.Trace;
import org.javagroups.stack.GossipData;
import org.javagroups.stack.IpAddress;

public class GossipClient {
    Timer timer = new Timer();
    Hashtable groups = new Hashtable();
    Refresher refresher_task = new Refresher();
    Vector gossip_servers = new Vector();
    boolean timer_running = false;
    long EXPIRY_TIME = 20000L;

    public GossipClient(IpAddress gossip_host, long expiry) {
        this.init(gossip_host, expiry);
    }

    public GossipClient(Vector gossip_hosts, long expiry) {
        if (gossip_hosts == null) {
            Trace.error("GossipClient.GossipClient()", "empty set of GossipServers given");
            return;
        }
        int i = 0;
        while (i < gossip_hosts.size()) {
            this.init((IpAddress)gossip_hosts.elementAt(i), expiry);
            ++i;
        }
    }

    public void stop() {
        this.timer.cancel();
    }

    public void addGossipServer(IpAddress gossip_host) {
        if (!this.gossip_servers.contains(gossip_host)) {
            this.gossip_servers.addElement(gossip_host);
        }
    }

    public void register(String group, Address mbr) {
        if (group == null || mbr == null) {
            Trace.error("GossipClient.register()", "group or mbr is null");
            return;
        }
        Vector<Address> mbrs = (Vector<Address>)this.groups.get(group);
        if (mbrs == null) {
            mbrs = new Vector<Address>();
            mbrs.addElement(mbr);
            this.groups.put(group, mbrs);
        } else if (!mbrs.contains(mbr)) {
            mbrs.addElement(mbr);
        }
        this._register(group, mbr);
        if (!this.timer_running) {
            this.timer.schedule((TimerTask)this.refresher_task, this.EXPIRY_TIME, this.EXPIRY_TIME);
            this.timer_running = true;
        }
    }

    public Vector getMembers(String group) {
        Object ret = null;
        if (group == null) {
            Trace.error("GossipClient.getMembers()", "group is null");
            return null;
        }
        return this._getMembers(group);
    }

    void init(IpAddress gossip_host, long expiry) {
        this.EXPIRY_TIME = expiry;
        this.addGossipServer(gossip_host);
    }

    void _register(String group, Address mbr) {
        int i = 0;
        while (i < this.gossip_servers.size()) {
            IpAddress entry = (IpAddress)this.gossip_servers.elementAt(i);
            if (entry.getIpAddress() == null || entry.getPort() == 0) {
                Trace.error("GossipClient._register()", "entry.host or entry.port is null");
            } else {
                try {
                    if (Trace.trace) {
                        Trace.info("GossipClient._register()", "REGISTER_REQ --> " + entry.getIpAddress() + ":" + entry.getPort());
                    }
                    Socket sock = new Socket(entry.getIpAddress(), entry.getPort());
                    ObjectOutputStream out = new ObjectOutputStream(sock.getOutputStream());
                    GossipData gossip_req = new GossipData(1, group, mbr, null);
                    out.writeObject(gossip_req);
                    out.flush();
                    sock.close();
                }
                catch (Exception ex) {
                    Trace.error("GossipClient._register()", "exception connecting to host " + entry + ": " + ex);
                }
            }
            ++i;
        }
    }

    Vector _getMembers(String group) {
        Vector<Address> ret = new Vector<Address>();
        int i = 0;
        while (i < this.gossip_servers.size()) {
            IpAddress entry = (IpAddress)this.gossip_servers.elementAt(i);
            if (entry.getIpAddress() == null || entry.getPort() == 0) {
                Trace.error("GossipClient._getMembers()", "entry.host or entry.port is null");
            } else {
                try {
                    if (Trace.trace) {
                        Trace.info("GossipClient._getMembers()", "GET_REQ --> " + entry.getIpAddress() + ":" + entry.getPort());
                    }
                    Socket sock = new Socket(entry.getIpAddress(), entry.getPort());
                    ObjectOutputStream out = new ObjectOutputStream(sock.getOutputStream());
                    GossipData gossip_req = new GossipData(2, group, null, null);
                    out.writeObject(gossip_req);
                    out.flush();
                    ObjectInputStream in = new ObjectInputStream(sock.getInputStream());
                    GossipData gossip_rsp = (GossipData)in.readObject();
                    if (gossip_rsp.mbrs != null) {
                        int j = 0;
                        while (j < gossip_rsp.mbrs.size()) {
                            Address mbr = (Address)gossip_rsp.mbrs.elementAt(j);
                            if (!ret.contains(mbr)) {
                                ret.addElement(mbr);
                            }
                            ++j;
                        }
                    }
                    sock.close();
                }
                catch (Exception ex) {
                    Trace.error("GossipClient._getMembers()", "exception connecting to host " + entry + ": " + ex);
                }
            }
            ++i;
        }
        return ret;
    }

    public static void main(String[] args) {
        Vector<IpAddress> gossip_hosts = new Vector<IpAddress>();
        boolean get = false;
        boolean register = false;
        boolean keep_running = false;
        String register_host = null;
        int register_port = 0;
        String get_group = null;
        String register_group = null;
        GossipClient gossip_client = null;
        long expiry = 20000L;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-help")) {
                GossipClient.usage();
                return;
            }
            if (args[i].equals("-expiry")) {
                expiry = new Long(args[++i]);
            } else if (args[i].equals("-host")) {
                String host = args[++i];
                int port = new Integer(args[++i]);
                try {
                    InetAddress ip_addr = InetAddress.getByName(host);
                    gossip_hosts.addElement(new IpAddress(ip_addr, port));
                }
                catch (Exception ex) {
                    System.err.println(ex);
                }
            } else if (args[i].equals("-keep_running")) {
                keep_running = true;
            } else if (args[i].equals("-get")) {
                get = true;
                get_group = args[++i];
            } else if (args[i].equals("-register")) {
                register_group = args[++i];
                register_host = args[++i];
                register_port = new Integer(args[++i]);
                register = true;
            } else {
                GossipClient.usage();
                return;
            }
            ++i;
        }
        if (gossip_hosts.size() == 0) {
            System.err.println("At least 1 GossipServer has to be given");
            return;
        }
        if (!register && !get) {
            System.err.println("Neither get nor register command given, will not do anything");
            return;
        }
        try {
            Trace.init();
        }
        catch (Throwable ex) {
            System.err.println("GossipClient.main(): error initailizing JavaGroups Trace: " + ex);
        }
        try {
            gossip_client = new GossipClient(gossip_hosts, expiry);
            if (register) {
                System.out.println("Registering " + register_group + " --> " + register_host + ":" + register_port);
                gossip_client.register(register_group, new IpAddress(register_host, register_port));
            }
            if (get) {
                System.out.println("Getting members for group " + get_group);
                Vector mbrs = gossip_client.getMembers(get_group);
                System.out.println("Members for group " + get_group + " are " + mbrs);
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        if (!keep_running) {
            gossip_client.stop();
        }
    }

    static void usage() {
        System.out.println("GossipClient [-help] [-host <hostname> <port>]+  [-get <groupname>] [-register <groupname hostname port>] [-expiry <msecs>] [-keep_running]]");
    }

    private class Refresher
    extends TimerTask {
        private Refresher() {
        }

        public void run() {
            int num_items = 0;
            if (Trace.trace) {
                Trace.info("GossipClient.Refresher.run()", "refresher task is run");
            }
            Enumeration e = GossipClient.this.groups.keys();
            while (e.hasMoreElements()) {
                String group = (String)e.nextElement();
                Vector mbrs = (Vector)GossipClient.this.groups.get(group);
                if (mbrs == null) continue;
                int i = 0;
                while (i < mbrs.size()) {
                    Address mbr = (Address)mbrs.elementAt(i);
                    if (Trace.trace) {
                        Trace.info("GossipClient.Refresher.run()", "registering " + group + " : " + mbr);
                    }
                    GossipClient.this.register(group, mbr);
                    ++num_items;
                    ++i;
                }
            }
            if (Trace.trace) {
                Trace.info("GossipClient.Refresher.run()", "refresher task done. Registered " + num_items + " items");
            }
        }
    }
}

