/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.stack;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import org.javagroups.Address;
import org.javagroups.log.Trace;

public class IpAddress
implements Address {
    private InetAddress ip_addr = null;
    private int port = 0;

    public IpAddress() {
    }

    public IpAddress(String i, int p) {
        try {
            this.ip_addr = InetAddress.getByName(i);
        }
        catch (Exception e) {
            Trace.warn("IpAddress.IpAddress()", "failed to get " + i + ":" + p + ", using \"127.0.0.1\"");
            try {
                this.ip_addr = InetAddress.getByName("127.0.0.1");
            }
            catch (Exception ex) {
                Trace.warn("IpAddress.IpAddress()", "exception: " + ex);
            }
        }
        this.port = p;
    }

    public IpAddress(InetAddress i, int p) {
        this.ip_addr = i;
        this.port = p;
    }

    public IpAddress(int port) {
        try {
            this.ip_addr = InetAddress.getLocalHost();
            this.port = port;
        }
        catch (Exception e) {
            Trace.warn("IpAddress.IpAddress()", "exception: " + e);
        }
    }

    public InetAddress getIpAddress() {
        return this.ip_addr;
    }

    public void setIpAddress(InetAddress i) {
        this.ip_addr = i;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isMulticastAddress() {
        return this.ip_addr != null ? this.ip_addr.isMulticastAddress() : false;
    }

    public void setLocalHost() {
        try {
            this.ip_addr = InetAddress.getLocalHost();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int compare(IpAddress other) {
        return this.compareTo(other);
    }

    public int compareTo(Object o) throws ClassCastException {
        int rc;
        int h2;
        if (o == null || !(o instanceof IpAddress)) {
            throw new ClassCastException("IpAddress.compareTo(): comparison between different classes");
        }
        IpAddress other = (IpAddress)o;
        if (this.ip_addr == null) {
            if (other.ip_addr == null) {
                return this.port < other.port ? -1 : (this.port > other.port ? 1 : 0);
            }
            return -1;
        }
        int h1 = this.ip_addr.hashCode();
        int n = h1 < (h2 = other.ip_addr.hashCode()) ? -1 : (rc = h1 > h2 ? 1 : 0);
        return rc != 0 ? rc : (this.port < other.port ? -1 : (this.port > other.port ? 1 : 0));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.compareTo(obj) == 0;
    }

    public int hashCode() {
        int retval = this.ip_addr != null ? this.ip_addr.hashCode() + this.port : this.port;
        return retval;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.ip_addr == null) {
            sb.append("<null>");
        } else {
            this.appendShortName(this.ip_addr.getHostName(), sb);
        }
        sb.append(":" + this.port);
        return sb.toString();
    }

    private void appendShortName(String hostname, StringBuffer sb) {
        int index = hostname.indexOf(46);
        if (index > 0 && !Character.isDigit(hostname.charAt(0))) {
            sb.append(hostname.substring(0, index));
        } else {
            sb.append(hostname);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.ip_addr);
        out.writeInt(this.port);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.ip_addr = (InetAddress)in.readObject();
        this.port = in.readInt();
    }
}

