/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.stack;

import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Header;
import org.javagroups.Message;
import org.javagroups.SuspectedException;
import org.javagroups.TimeoutException;
import org.javagroups.View;
import org.javagroups.blocks.GroupRequest;
import org.javagroups.blocks.RequestCorrelator;
import org.javagroups.blocks.RequestHandler;
import org.javagroups.log.Trace;
import org.javagroups.stack.Protocol;
import org.javagroups.util.Rsp;
import org.javagroups.util.RspList;
import org.javagroups.util.Util;

public abstract class MessageProtocol
extends Protocol
implements RequestHandler {
    protected RequestCorrelator _corr = null;
    protected Vector members = new Vector();

    public RspList castMessage(Vector dests, Message msg, int mode, long timeout) {
        GroupRequest _req = null;
        Vector real_dests = dests != null ? dests : this.members;
        _req = new GroupRequest(msg, this._corr, real_dests, mode, timeout, 0);
        _req.execute();
        return _req.getResults();
    }

    public Object sendMessage(Message msg, int mode, long timeout) throws TimeoutException, SuspectedException {
        Rsp rsp;
        Vector<Address> mbrs = new Vector<Address>();
        RspList rsp_list = null;
        Address dest = msg.getDest();
        Object retval = null;
        GroupRequest _req = null;
        if (dest == null) {
            System.out.println("MessageProtocol.sendMessage(): the message's destination is null ! Cannot send message !");
            return null;
        }
        mbrs.addElement(dest);
        _req = new GroupRequest(msg, this._corr, mbrs, mode, timeout, 0);
        _req.execute();
        if (mode == 6) {
            return null;
        }
        rsp_list = _req.getResults();
        if (rsp_list.size() == 0) {
            Trace.error("MessageProtocol.sendMessage()", "response list is empty");
            return null;
        }
        if (rsp_list.size() > 1) {
            Trace.error("MessageProtocol.sendMessage()", "response list contains more that 1 response; returning first response");
        }
        if ((rsp = (Rsp)rsp_list.elementAt(0)).wasSuspected()) {
            throw new SuspectedException(dest);
        }
        if (!rsp.wasReceived()) {
            throw new TimeoutException();
        }
        return rsp.getValue();
    }

    public Object handle(Message req) {
        System.out.println("MessageProtocol.handle(): this method should be overridden !");
        return null;
    }

    public final void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                this.start();
                if (this.handleUpEvent(evt)) break;
                return;
            }
            case 4: {
                this.stop();
                break;
            }
            case 10: {
                this.updateView((View)evt.getArg());
                break;
            }
            default: {
                Message msg;
                Header hdr;
                if (!this.handleUpEvent(evt)) {
                    return;
                }
                if (evt.getType() == 5 && !((hdr = (msg = (Message)evt.getArg()).peekHeader()) instanceof RequestCorrelator.Header)) break;
                if (this._corr != null) {
                    this._corr.receive(evt);
                    return;
                }
                Trace.error("MessageProtocol.up()", "Request correlator is null! Event is " + Util.printEvent(evt));
            }
        }
        this.passUp(evt);
    }

    public final void down(Event evt) {
        switch (evt.getType()) {
            case 10: {
                this.updateView((View)evt.getArg());
                if (this.handleDownEvent(evt)) break;
                return;
            }
            case 5: {
                if (this.handleDownEvent(evt)) break;
                return;
            }
            default: {
                if (this.handleDownEvent(evt)) break;
                return;
            }
        }
        this.passDown(evt);
    }

    protected void updateView(View new_view) {
        Vector new_mbrs = new_view.getMembers();
        if (new_mbrs != null) {
            this.members.removeAllElements();
            int i = 0;
            while (i < new_mbrs.size()) {
                this.members.addElement(new_mbrs.elementAt(i));
                ++i;
            }
        }
    }

    protected boolean handleUpEvent(Event evt) {
        return true;
    }

    protected boolean handleDownEvent(Event evt) {
        return true;
    }

    protected void start() {
        if (this._corr == null) {
            this._corr = new RequestCorrelator(this.getName(), this, this);
        }
    }

    protected void stop() {
        if (this._corr != null) {
            this._corr.stop();
            this._corr = null;
        }
    }
}

