/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.stack;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Message;
import org.javagroups.log.Trace;
import org.javagroups.util.RWLock;
import org.javagroups.util.TimeScheduler;

public class NakReceiverWindow {
    private Address sender = null;
    private RWLock lock = new RWLock();
    private long head = 0L;
    private long tail = 0L;
    private long lowest_seen = 0L;
    private long highest_seen = 0L;
    private org.javagroups.util.List msgs = new org.javagroups.util.List();
    private org.javagroups.util.List delivered_msgs = new org.javagroups.util.List();
    private RetransmitCommand cmd = null;
    private Retransmitter retransmitter = null;

    public NakReceiverWindow(Address sender, RetransmitCommand cmd, long start_seqno, TimeScheduler sched) {
        this.sender = sender;
        this.cmd = cmd;
        this.tail = this.head = start_seqno;
        if (cmd != null) {
            this.retransmitter = sched == null ? new Retransmitter(sender, cmd) : new Retransmitter(sender, cmd, sched);
        }
    }

    public NakReceiverWindow(Address sender, RetransmitCommand cmd, long start_seqno) {
        this(sender, cmd, start_seqno, null);
    }

    public NakReceiverWindow(Address sender, long start_seqno) {
        this(sender, null, start_seqno);
    }

    public void finalize() {
        if (this.retransmitter != null) {
            this.retransmitter.stop();
        }
    }

    public void setRetransmitTimeouts(long[] timeouts) {
        if (this.retransmitter != null) {
            this.retransmitter.setRetransmitTimeouts(timeouts);
        }
    }

    public void add(long seqno, Message msg) {
        Entry current = null;
        this.lock.writeLock();
        try {
            block9: {
                block10: {
                    long old_tail;
                    block8: {
                        old_tail = this.tail;
                        if (seqno < this.head) {
                            if (Trace.trace) {
                                Trace.info("NakReceiverWindow.add()", "seqno " + seqno + " is smaller than " + this.head + "); discarding message");
                            }
                            Object var10_5 = null;
                            this.lock.writeUnlock();
                            return;
                        }
                        if (seqno != this.tail) break block8;
                        this.msgs.add(new Entry(seqno, msg));
                        ++this.tail;
                        break block9;
                    }
                    if (seqno <= this.tail) break block10;
                    long i = this.tail;
                    while (i < seqno) {
                        this.msgs.add(new Entry(i, null));
                        ++this.tail;
                        ++i;
                    }
                    this.msgs.add(new Entry(seqno, msg));
                    this.tail = seqno + 1L;
                    if (this.retransmitter == null) break block9;
                    this.retransmitter.add(old_tail, seqno - 1L);
                    break block9;
                }
                if (seqno < this.tail) {
                    if (Trace.trace) {
                        Trace.debug("NakReceiverWindow.add()", "added missing msg " + msg.getSrc() + "#" + seqno);
                    }
                    Enumeration en = this.msgs.elements();
                    while (en.hasMoreElements()) {
                        current = (Entry)en.nextElement();
                        if (seqno != current.seqno) continue;
                        current.msg = msg;
                        if (this.retransmitter == null) break;
                        this.retransmitter.remove(seqno);
                        break;
                    }
                }
            }
            this._updateLowestSeen();
            this._updateHighestSeen();
        }
        catch (Throwable throwable) {
            Object var10_7 = null;
            this.lock.writeUnlock();
            throw throwable;
        }
        Object var10_6 = null;
        this.lock.writeUnlock();
    }

    public Message remove() {
        Message retval = null;
        this.lock.writeLock();
        try {
            Entry e = (Entry)this.msgs.peekAtHead();
            if (e != null && e.msg != null) {
                retval = e.msg;
                this.msgs.removeFromHead();
                this.delivered_msgs.add(e.copy());
                ++this.head;
            }
            Message message = retval;
            Object var5_4 = null;
            this.lock.writeUnlock();
            return message;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.lock.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void stable(long seqno) {
        this.lock.writeLock();
        try {
            Entry e;
            while ((e = (Entry)this.delivered_msgs.peekAtHead()) != null) {
                void var3_2;
                if (((Entry)var3_2).seqno > seqno) break;
                this.delivered_msgs.removeFromHead();
            }
            this._updateLowestSeen();
            this._updateHighestSeen();
            Object var5_3 = null;
            this.lock.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.lock.writeUnlock();
            throw throwable;
        }
    }

    public void reset() {
        this.lock.writeLock();
        try {
            if (this.retransmitter != null) {
                this.retransmitter.reset();
            }
            this._reset();
            Object var2_1 = null;
            this.lock.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.lock.writeUnlock();
            throw throwable;
        }
    }

    public void destroy() {
        this.lock.writeLock();
        try {
            if (this.retransmitter != null) {
                this.retransmitter.stop();
            }
            this._reset();
            Object var2_1 = null;
            this.lock.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.lock.writeUnlock();
            throw throwable;
        }
    }

    public long getHighestDelivered() {
        this.lock.readLock();
        try {
            long l = Math.max(this.head - 1L, -1L);
            Object var4_2 = null;
            this.lock.readUnlock();
            return l;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.lock.readUnlock();
            throw throwable;
        }
    }

    public long getLowestSeen() {
        this.lock.readLock();
        try {
            long l = this.lowest_seen;
            Object var4_2 = null;
            this.lock.readUnlock();
            return l;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.lock.readUnlock();
            throw throwable;
        }
    }

    public long getHighestSeen() {
        this.lock.readLock();
        try {
            long l = this.highest_seen;
            Object var4_2 = null;
            this.lock.readUnlock();
            return l;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.lock.readUnlock();
            throw throwable;
        }
    }

    public org.javagroups.util.List getMissingMessages(long low, long high) {
        org.javagroups.util.List retval = new org.javagroups.util.List();
        if (low > high) {
            if (Trace.trace) {
                Trace.error("NakReceiverWindow.getMissingMessages()", "invalid range: low (" + low + ") is higher than high (" + high + ")");
            }
            return null;
        }
        this.lock.readLock();
        try {
            Entry entry;
            long my_high = Math.max(this.head - 1L, 0L);
            Enumeration e = this.msgs.elements();
            while (e.hasMoreElements()) {
                entry = (Entry)e.nextElement();
                if (entry.seqno < low || entry.seqno > high || entry.msg != null) continue;
                retval.add(new Long(entry.seqno));
            }
            if (this.msgs.size() > 0 && (entry = (Entry)this.msgs.peek()) != null) {
                my_high = entry.seqno;
            }
            long i = my_high + 1L;
            while (i <= high) {
                retval.add(new Long(i));
                ++i;
            }
            org.javagroups.util.List list = retval.size() == 0 ? null : retval;
            Object var14_9 = null;
            this.lock.readUnlock();
            return list;
        }
        catch (Throwable throwable) {
            Object var14_10 = null;
            this.lock.readUnlock();
            throw throwable;
        }
    }

    public long getHighestReceived() {
        this.lock.readLock();
        try {
            long l = Math.max(this.tail - 1L, -1L);
            Object var4_2 = null;
            this.lock.readUnlock();
            return l;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.lock.readUnlock();
            throw throwable;
        }
    }

    public org.javagroups.util.List getMessagesHigherThan(long seqno) {
        org.javagroups.util.List retval = new org.javagroups.util.List();
        this.lock.readLock();
        try {
            Entry entry;
            Enumeration e = this.msgs.elements();
            while (e.hasMoreElements()) {
                entry = (Entry)e.nextElement();
                if (entry.seqno <= seqno) continue;
                retval.add(entry.msg);
            }
            Enumeration e2 = this.delivered_msgs.elements();
            while (e2.hasMoreElements()) {
                entry = (Entry)e2.nextElement();
                if (entry.seqno <= seqno) continue;
                retval.add(entry.msg);
            }
            org.javagroups.util.List list = retval;
            Object var9_7 = null;
            this.lock.readUnlock();
            return list;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.lock.readUnlock();
            throw throwable;
        }
    }

    public org.javagroups.util.List getMessagesInRange(long lower, long upper) {
        org.javagroups.util.List retval = new org.javagroups.util.List();
        this.lock.readLock();
        try {
            Entry entry;
            Enumeration e = this.msgs.elements();
            while (e.hasMoreElements()) {
                entry = (Entry)e.nextElement();
                if (entry.seqno <= lower || entry.seqno > upper) continue;
                retval.add(entry.msg);
            }
            Enumeration e2 = this.delivered_msgs.elements();
            while (e2.hasMoreElements()) {
                entry = (Entry)e2.nextElement();
                if (entry.seqno <= lower || entry.seqno > upper) continue;
                retval.add(entry.msg);
            }
            org.javagroups.util.List list = retval.size() == 0 ? null : retval;
            Object var11_8 = null;
            this.lock.readUnlock();
            return list;
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            this.lock.readUnlock();
            throw throwable;
        }
    }

    public org.javagroups.util.List getMessagesInList(org.javagroups.util.List missing_msgs) {
        org.javagroups.util.List ret = new org.javagroups.util.List();
        if (missing_msgs == null) {
            if (Trace.trace) {
                Trace.error("NakReceiverWindow.getMessagesInList()", "argument list is null");
            }
            return ret;
        }
        this.lock.readLock();
        try {
            Entry entry;
            Enumeration e = this.delivered_msgs.elements();
            while (e.hasMoreElements()) {
                entry = (Entry)e.nextElement();
                if (!missing_msgs.contains(new Long(entry.seqno)) || entry.msg == null) continue;
                ret.add(entry.msg.copy());
            }
            Enumeration e2 = this.msgs.elements();
            while (e2.hasMoreElements()) {
                entry = (Entry)e2.nextElement();
                if (!missing_msgs.contains(new Long(entry.seqno)) || entry.msg == null) continue;
                ret.add(entry.msg.copy());
            }
            org.javagroups.util.List list = ret;
            Object var8_7 = null;
            this.lock.readUnlock();
            return list;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.lock.readUnlock();
            throw throwable;
        }
    }

    public int size() {
        this.lock.readLock();
        try {
            int n = this.msgs.size();
            Object var3_2 = null;
            this.lock.readUnlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.readUnlock();
            throw throwable;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        this.lock.readLock();
        try {
            sb.append("delivered_msgs: " + this.delivered_msgs);
            sb.append("\nreceived_msgs: " + this.msgs);
            Object var3_2 = null;
            this.lock.readUnlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.readUnlock();
            throw throwable;
        }
        return sb.toString();
    }

    private static String _toString(Throwable ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        return sw.toString();
    }

    private void _updateLowestSeen() {
        Entry entry = null;
        if (this.delivered_msgs.size() == 0 && this.msgs.size() == 0) {
            this.lowest_seen = 0L;
            return;
        }
        entry = (Entry)this.delivered_msgs.peekAtHead();
        if (entry != null) {
            this.lowest_seen = entry.seqno;
        } else if (this.msgs.size() != 0 && (entry = (Entry)this.msgs.peekAtHead()) != null && entry.msg != null) {
            this.lowest_seen = entry.seqno;
        }
    }

    private void _updateHighestSeen() {
        long ret = 0L;
        Entry entry = null;
        if (this.delivered_msgs.size() == 0 && this.msgs.size() == 0) {
            this.highest_seen = 0L;
            return;
        }
        entry = (Entry)this.delivered_msgs.peek();
        ret = entry != null ? entry.seqno : Math.max(this.head - 1L, 0L);
        Enumeration e = this.msgs.elements();
        while (e.hasMoreElements()) {
            entry = (Entry)e.nextElement();
            if (entry.msg == null) break;
            ret = entry.seqno;
        }
        this.highest_seen = Math.max(ret, 0L);
    }

    private void _reset() {
        this.msgs.removeAll();
        this.delivered_msgs.removeAll();
        this.head = 0L;
        this.tail = 0L;
        this.lowest_seen = 0L;
        this.highest_seen = 0L;
    }

    private static class Retransmitter {
        private static final long SEC = 1000L;
        private static long[] RETRANSMIT_TIMEOUTS = new long[]{2000L, 3000L, 5000L, 8000L};
        private static final long SUSPEND_TIMEOUT = 2000L;
        private Address sender = null;
        private Vector msgs = new Vector();
        private RetransmitCommand cmd = null;
        private boolean retransmitter_owned;
        private TimeScheduler retransmitter = null;

        public Retransmitter(Address sender, RetransmitCommand cmd, TimeScheduler sched) {
            this.init(sender, cmd, sched, false);
        }

        public Retransmitter(Address sender, RetransmitCommand cmd) {
            this.init(sender, cmd, new TimeScheduler(2000L), true);
        }

        public void setRetransmitTimeouts(long[] timeouts) {
            if (timeouts != null) {
                RETRANSMIT_TIMEOUTS = timeouts;
            }
        }

        public void add(long first_seqno, long last_seqno) {
            if (first_seqno > last_seqno) {
                long tmp = first_seqno;
                first_seqno = last_seqno;
                last_seqno = tmp;
            }
            Vector vector = this.msgs;
            synchronized (vector) {
                Entry e = new Entry(first_seqno, last_seqno, RETRANSMIT_TIMEOUTS);
                this.msgs.addElement(e);
                this.retransmitter.add(e);
            }
        }

        public void remove(long seqno) {
            Vector vector = this.msgs;
            synchronized (vector) {
                int i = 0;
                while (i < this.msgs.size()) {
                    block9: {
                        Entry e;
                        Entry entry = e = (Entry)this.msgs.elementAt(i);
                        synchronized (entry) {
                            if (seqno < e.low || seqno > e.high) {
                                break block9;
                            }
                            e.remove(seqno);
                            if (e.low > e.high) {
                                e.cancel();
                                this.msgs.removeElementAt(i);
                            }
                            break;
                        }
                    }
                    ++i;
                }
            }
        }

        public void reset() {
            Vector vector = this.msgs;
            synchronized (vector) {
                int i = 0;
                while (i < this.msgs.size()) {
                    Entry entry = (Entry)this.msgs.get(i);
                    entry.cancel();
                    ++i;
                }
                this.msgs.clear();
            }
        }

        public void stop() {
            Vector vector = this.msgs;
            synchronized (vector) {
                if (this.retransmitter_owned) {
                    try {
                        this.retransmitter.stop();
                    }
                    catch (InterruptedException ex) {
                        Trace.error("NakReceiverWindow.stop()", NakReceiverWindow._toString(ex));
                    }
                } else {
                    int i = 0;
                    while (i < this.msgs.size()) {
                        Entry entry = (Entry)this.msgs.get(i);
                        entry.cancel();
                        ++i;
                    }
                }
                this.msgs.clear();
            }
        }

        public String toString() {
            return "NakReceiverWindow.RetransmitterThread: " + this.msgs.size() + " messages to retransmit";
        }

        private void init(Address sender, RetransmitCommand cmd, TimeScheduler sched, boolean sched_owned) {
            this.sender = sender;
            this.cmd = cmd;
            this.retransmitter_owned = sched_owned;
            this.retransmitter = sched;
        }

        private class Entry
        extends Task {
            public long low;
            public long high;
            public List list;

            public Entry(long low, long high, long[] intervals) {
                super(intervals);
                this.low = low;
                this.high = high;
                this.list = new ArrayList();
                this.list.add(new long[]{low, high});
            }

            public void remove(long seqno) {
                long[] bounds = null;
                Entry entry = this;
                synchronized (entry) {
                    int i = 0;
                    while (i < this.list.size()) {
                        bounds = (long[])this.list.get(i);
                        if (seqno >= bounds[0] && seqno <= bounds[1]) break;
                        ++i;
                    }
                    if (i == this.list.size()) {
                        return;
                    }
                    if (seqno == bounds[0]) {
                        if (bounds[0] == bounds[1]) {
                            this.list.remove(i);
                        } else {
                            bounds[0] = bounds[0] + 1L;
                        }
                        if (i == 0) {
                            this.low = this.list.size() == 0 ? this.high + 1L : ((long[])this.list.get(i))[0];
                        }
                    } else if (seqno == bounds[1]) {
                        bounds[1] = bounds[1] - 1L;
                        if (i == this.list.size() - 1) {
                            this.high = ((long[])this.list.get(i))[1];
                        }
                    } else {
                        long[] newBounds = new long[]{seqno + 1L, bounds[1]};
                        bounds[1] = seqno - 1L;
                        this.list.add(i + 1, newBounds);
                    }
                }
            }

            public void run() {
                Entry entry = this;
                synchronized (entry) {
                    int i = 0;
                    while (i < this.list.size()) {
                        long[] bounds = (long[])this.list.get(i);
                        Retransmitter.this.cmd.retransmit(bounds[0], bounds[1], Retransmitter.this.sender);
                        ++i;
                    }
                }
            }
        }

        private static abstract class Task
        implements TimeScheduler.Task {
            private Times intervals;
            private boolean cancelled;

            protected Task(long[] intervals) {
                this.intervals = new Times(intervals);
                this.cancelled = false;
            }

            public long nextInterval() {
                return this.intervals.next();
            }

            public boolean cancelled() {
                return this.cancelled;
            }

            public void cancel() {
                this.cancelled = true;
            }

            public abstract void run();
        }

        private static class Times {
            private int next = 0;
            private long[] times;

            public Times(long[] times) {
                if (times.length == 0) {
                    throw new IllegalArgumentException("times");
                }
                this.times = times;
            }

            public synchronized long next() {
                if (this.next >= this.times.length) {
                    return this.times[this.times.length - 1];
                }
                return this.times[this.next++];
            }

            public long[] times() {
                return this.times;
            }

            public synchronized void reset() {
                this.next = 0;
            }
        }
    }

    private static class Entry {
        private long seqno = 0L;
        private Message msg = null;

        public Entry() {
            this.seqno = 0L;
            this.msg = null;
        }

        public Entry(long seqno, Message msg) {
            this.seqno = seqno;
            this.msg = msg;
        }

        public Entry copy() {
            Entry retval = new Entry();
            retval.seqno = this.seqno;
            if (this.msg != null) {
                retval.msg = this.msg.copy();
            }
            return retval;
        }

        public String toString() {
            StringBuffer ret = new StringBuffer();
            ret.append(this.seqno);
            if (this.msg == null) {
                ret.append("-");
            } else {
                ret.append("+");
            }
            return ret.toString();
        }
    }

    public static interface RetransmitCommand {
        public void retransmit(long var1, long var3, Address var5);
    }
}

