/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.stack;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.javagroups.ChannelException;
import org.javagroups.Event;
import org.javagroups.JChannel;
import org.javagroups.Message;
import org.javagroups.Transport;
import org.javagroups.log.Trace;
import org.javagroups.stack.Configurator;
import org.javagroups.stack.Protocol;
import org.javagroups.util.TimeScheduler;

public class ProtocolStack
extends Protocol
implements Transport {
    private Protocol top_prot = null;
    private Protocol bottom_prot = null;
    private Configurator conf = new Configurator();
    private String setup_string;
    private JChannel channel = null;
    private Object start_mutex = new Object();
    private Object stop_mutex = new Object();
    private boolean start_ok_received = false;
    private Object local_addr = null;
    private boolean stopped = false;
    public TimeScheduler timer = new TimeScheduler(5000L);
    public static final int ABOVE = 1;
    public static final int BELOW = 2;

    public ProtocolStack(JChannel channel, String setup_string) {
        this.setup_string = setup_string;
        this.channel = channel;
    }

    public Vector getProtocols() {
        Vector<Protocol> v = new Vector<Protocol>();
        Protocol p = this.top_prot;
        while (p != null) {
            v.addElement(p);
            p = p.getDownProtocol();
        }
        return v;
    }

    public String printProtocolSpec(boolean include_properties) {
        StringBuffer sb = new StringBuffer();
        Protocol prot = this.top_prot;
        while (prot != null) {
            Properties props;
            String name = prot.getName();
            if (name == null) continue;
            if (name.equals("ProtocolStack")) break;
            sb.append(name);
            if (include_properties && (props = prot.getProperties()) != null) {
                sb.append("\n");
                Iterator it = ((Hashtable)props).entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    sb.append(entry + "\n");
                }
            }
            sb.append("\n");
            prot = prot.getDownProtocol();
        }
        return sb.toString();
    }

    public void setup() throws Exception {
        if (this.top_prot == null) {
            this.stopped = false;
            this.top_prot = this.conf.setupProtocolStack(this.setup_string, this);
            if (this.top_prot == null) {
                throw new Exception("ProtocolStack.setup(): couldn't create protocol stack");
            }
            this.top_prot.setUpProtocol(this);
            this.bottom_prot = this.conf.getBottommostProtocol(this.top_prot);
            this.conf.startProtocolStack(this.bottom_prot);
        }
    }

    public Protocol createProtocol(String prot_spec) throws Exception {
        return this.conf.createProtocol(prot_spec, this);
    }

    public void insertProtocol(Protocol prot, int position, String neighbor_prot) throws Exception {
        this.conf.insertProtocol(prot, position, neighbor_prot, this);
    }

    public void removeProtocol(String prot_name) throws Exception {
        this.conf.removeProtocol(prot_name);
    }

    public Protocol findProtocol(String name) {
        Protocol tmp = this.top_prot;
        while (tmp != null) {
            String prot_name = tmp.getName();
            if (prot_name != null && prot_name.equals(name)) {
                return tmp;
            }
            tmp = tmp.getDownProtocol();
        }
        return null;
    }

    public void destroy() throws Exception {
        if (this.top_prot != null) {
            this.conf.stopProtocolStack(this.top_prot);
            this.top_prot = null;
        }
    }

    public void start() throws Exception {
        Object object = this.start_mutex;
        synchronized (object) {
            this.stopped = false;
            this.bottom_prot.up(new Event(1));
            if (!this.start_ok_received) {
                this.start_mutex.wait();
            }
        }
        if (!this.start_ok_received) {
            throw new ChannelException("ProtocolStack.start(): timed out waiting for START_OK");
        }
    }

    public void startUpHandler() {
    }

    public void startDownHandler() {
    }

    public void stop() {
        if (this.timer != null) {
            try {
                this.timer.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Object object = this.stop_mutex;
        synchronized (object) {
            if (this.stopped) {
                return;
            }
            this.top_prot.down(new Event(3));
            try {
                this.stop_mutex.wait(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.stopped = true;
        }
    }

    public void stopInternal() {
    }

    public void send(Message msg) throws Exception {
        this.down(new Event(5, msg));
    }

    public Object receive(long timeout) throws Exception {
        throw new Exception("ProtocolStack.receive(): not implemented !");
    }

    public String getName() {
        return "ProtocolStack";
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 12: {
                this.local_addr = evt.getArg();
                break;
            }
            case 2: {
                Object object = this.start_mutex;
                synchronized (object) {
                    this.start_ok_received = true;
                    this.start_mutex.notify();
                }
                return;
            }
            case 4: {
                Object object = this.stop_mutex;
                synchronized (object) {
                    this.stop_mutex.notify();
                }
                this.start_ok_received = false;
                return;
            }
        }
        if (this.channel != null) {
            this.channel.up(evt);
        }
    }

    public void down(Event evt) {
        if (this.top_prot != null) {
            this.top_prot.receiveDownEvent(evt);
        } else {
            Trace.error("ProtocolStack.down()", "no down protocol available !");
        }
    }

    protected void receiveUpEvent(Event evt) {
        this.up(evt);
    }

    public void startWork() {
    }

    public void stopWork() {
    }
}

