/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.stack;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import org.javagroups.Address;
import org.javagroups.log.Trace;
import org.javagroups.stack.IpAddress;
import org.javagroups.util.List;
import org.javagroups.util.Util;

public class Router {
    Hashtable groups = new Hashtable();
    int port = 8080;
    ServerSocket srv_sock = null;
    public static final int GET = -10;
    public static final int REGISTER = -11;

    public Router(int port) throws Exception {
        this.port = port;
        this.srv_sock = new ServerSocket(port, 50);
    }

    public void start() {
        Date d = new Date();
        System.out.println("\nRouter started at " + d);
        System.out.println("Listening on port " + this.port + "\n");
        d = null;
        block6: while (true) {
            try {
                while (true) {
                    Socket sock = this.srv_sock.accept();
                    sock.setSoLinger(true, 500);
                    IpAddress peer_addr = new IpAddress(sock.getInetAddress(), sock.getPort());
                    DataOutputStream output = new DataOutputStream(sock.getOutputStream());
                    byte[] buf = Util.objectToByteBuffer(peer_addr);
                    output.writeInt(buf.length);
                    output.write(buf, 0, buf.length);
                    DataInputStream input = new DataInputStream(sock.getInputStream());
                    int type = input.readInt();
                    String gname = input.readUTF();
                    switch (type) {
                        case -10: {
                            this.processGetRequest(sock, output, gname);
                            continue block6;
                        }
                        case -11: {
                            int len = input.readInt();
                            buf = new byte[len];
                            input.readFully(buf, 0, buf.length);
                            Address addr = (Address)Util.objectFromByteBuffer(buf);
                            this.addEntry(gname, new AddressEntry(addr, sock, output));
                            new SocketThread(sock, input).start();
                            continue block6;
                        }
                        default: {
                            Trace.error("Router.start()", "request of type " + type + " not recognized");
                            break;
                        }
                    }
                }
            }
            catch (Exception e) {
                Trace.error("Router.start()", "exception=" + e);
                continue;
            }
            break;
        }
    }

    public void stop() {
    }

    /*
     * Loose catch block
     */
    void processGetRequest(Socket sock, DataOutputStream output, String groupname) {
        block16: {
            block15: {
                List grpmbrs = (List)this.groups.get(groupname);
                List ret = null;
                if (Trace.trace) {
                    Trace.info("Router.processGetRequest()", "groupname=" + groupname + ", result=" + grpmbrs);
                }
                if (grpmbrs != null && grpmbrs.size() > 0) {
                    ret = new List();
                    Enumeration e = grpmbrs.elements();
                    while (e.hasMoreElements()) {
                        AddressEntry entry = (AddressEntry)e.nextElement();
                        ret.add(entry.addr);
                    }
                }
                if (ret == null || ret.size() == 0) {
                    output.writeInt(0);
                    break block15;
                }
                byte[] buf = Util.objectToByteBuffer(ret);
                output.writeInt(buf.length);
                output.write(buf, 0, buf.length);
            }
            Object var10_10 = null;
            try {
                if (output != null) {
                    output.close();
                }
                sock.close();
            }
            catch (Exception e2) {}
            break block16;
            {
                catch (Exception e) {
                    Trace.error("Router.processGetRequest()", "exception=" + e);
                    Object var10_11 = null;
                    try {
                        if (output != null) {
                            output.close();
                        }
                        sock.close();
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    if (output != null) {
                        output.close();
                    }
                    sock.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    synchronized void route(Address dest, String dest_group, byte[] msg) {
        if (dest == null) {
            if (dest_group == null) {
                Trace.error("Router.route()", "both dest address and group are null");
                return;
            }
            this.sendToAllMembersInGroup(dest_group, msg);
        } else {
            DataOutputStream out = this.findSocket(dest);
            if (out != null) {
                this.sendToMember(out, msg);
            } else {
                Trace.error("Router.route()", "routing of " + msg + "failed; outstream is null !");
            }
        }
    }

    void addEntry(String groupname, AddressEntry e) {
        if (groupname == null) {
            Trace.error("Router.addEntry()", "groupname was null, not added !");
            return;
        }
        Hashtable hashtable = this.groups;
        synchronized (hashtable) {
            AddressEntry old_entry;
            List val = (List)this.groups.get(groupname);
            if (val == null) {
                val = new List();
                this.groups.put(groupname, val);
            }
            if (val.contains(e) && (old_entry = (AddressEntry)val.removeElement(e)) != null) {
                old_entry.destroy();
            }
            val.add(e);
        }
    }

    void removeEntry(Socket sock) {
        Hashtable hashtable = this.groups;
        synchronized (hashtable) {
            Enumeration e = this.groups.keys();
            while (e.hasMoreElements()) {
                List val = (List)this.groups.get(e.nextElement());
                Enumeration e2 = val.elements();
                while (e2.hasMoreElements()) {
                    AddressEntry entry = (AddressEntry)e2.nextElement();
                    if (entry.sock != sock) continue;
                    try {
                        entry.sock.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    val.removeElement(entry);
                    return;
                }
            }
        }
    }

    void removeEntry(OutputStream out) {
        Hashtable hashtable = this.groups;
        synchronized (hashtable) {
            Enumeration e = this.groups.keys();
            while (e.hasMoreElements()) {
                List val = (List)this.groups.get(e.nextElement());
                Enumeration e2 = val.elements();
                while (e2.hasMoreElements()) {
                    AddressEntry entry = (AddressEntry)e2.nextElement();
                    if (entry.output != out) continue;
                    try {
                        if (entry.sock != null) {
                            entry.sock.close();
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    val.removeElement(entry);
                    return;
                }
            }
        }
    }

    void removeEntry(String groupname, Address addr) {
        Hashtable hashtable = this.groups;
        synchronized (hashtable) {
            List val = (List)this.groups.get(groupname);
            if (val == null || val.size() == 0) {
                return;
            }
            Enumeration e2 = val.elements();
            while (e2.hasMoreElements()) {
                AddressEntry entry = (AddressEntry)e2.nextElement();
                if (!entry.addr.equals(addr)) continue;
                try {
                    if (entry.sock != null) {
                        entry.sock.close();
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                val.removeElement(entry);
                return;
            }
        }
    }

    DataOutputStream findSocket(Address addr) {
        Hashtable hashtable = this.groups;
        synchronized (hashtable) {
            Enumeration e = this.groups.keys();
            while (e.hasMoreElements()) {
                List val = (List)this.groups.get(e.nextElement());
                Enumeration e2 = val.elements();
                while (e2.hasMoreElements()) {
                    AddressEntry entry = (AddressEntry)e2.nextElement();
                    if (!addr.equals(entry.addr)) continue;
                    DataOutputStream dataOutputStream = entry.output;
                    return dataOutputStream;
                }
            }
            DataOutputStream dataOutputStream = null;
            return dataOutputStream;
        }
    }

    void sendToAllMembersInGroup(String groupname, byte[] msg) {
        Hashtable hashtable = this.groups;
        synchronized (hashtable) {
            List val = (List)this.groups.get(groupname);
            if (val == null || val.size() == 0) {
                return;
            }
            Enumeration e = val.elements();
            while (e.hasMoreElements()) {
                this.sendToMember(((AddressEntry)e.nextElement()).output, msg);
            }
        }
    }

    void sendToMember(DataOutputStream out, byte[] msg) {
        try {
            if (out != null) {
                out.writeInt(msg.length);
                out.write(msg, 0, msg.length);
            }
        }
        catch (Exception e) {
            Trace.error("Router.sendToMember()", "exception=" + e);
            this.removeEntry(out);
        }
    }

    public static void main(String[] args) {
        int port = 8080;
        Router router = null;
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.equals("-help")) {
                System.out.println("Router [-port <port> ]");
                return;
            }
            if (arg.equals("-port")) {
                port = new Integer(args[++i]);
            }
            ++i;
        }
        Trace.init();
        try {
            router = new Router(port);
            router.start();
            System.out.println("Router was created at " + new Date());
            System.out.println("Listening on port " + port);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    class SocketThread
    extends Thread {
        Socket sock = null;
        DataInputStream input = null;

        public SocketThread(Socket sock, DataInputStream ois) {
            this.sock = sock;
            this.input = ois;
        }

        void closeSocket() {
            try {
                if (this.input != null) {
                    this.input.close();
                }
                if (this.sock != null) {
                    this.sock.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void run() {
            Address dst_addr = null;
            while (true) {
                try {
                    byte[] buf;
                    int len;
                    String gname;
                    while (true) {
                        gname = this.input.readUTF();
                        len = this.input.readInt();
                        if (len == 0) {
                            dst_addr = null;
                        } else {
                            buf = new byte[len];
                            this.input.readFully(buf, 0, buf.length);
                            dst_addr = (Address)Util.objectFromByteBuffer(buf);
                        }
                        len = this.input.readInt();
                        if (len != 0) break;
                        Trace.warn("Router.SocketThread.run()", "received null message");
                    }
                    buf = new byte[len];
                    this.input.readFully(buf, 0, buf.length);
                    Router.this.route(dst_addr, gname, buf);
                }
                catch (IOException io_ex) {
                    if (Trace.trace) {
                        Trace.info("Router.SocketThread.run()", "client " + this.sock.getInetAddress().getHostName() + ":" + this.sock.getPort() + " closed connection; removing it from routing table");
                    }
                    Router.this.removeEntry(this.sock);
                    return;
                }
                catch (Exception e) {
                    Trace.error("Router.SocketThread.run()", "exception=" + e);
                    this.closeSocket();
                    return;
                }
            }
        }
    }

    class AddressEntry {
        Address addr = null;
        Socket sock = null;
        DataOutputStream output = null;

        public AddressEntry(Address addr, Socket sock, DataOutputStream output) {
            this.addr = addr;
            this.sock = sock;
            this.output = output;
        }

        void destroy() {
            if (this.output != null) {
                try {
                    this.output.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.output = null;
            }
            if (this.sock != null) {
                try {
                    this.sock.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.sock = null;
            }
        }

        public boolean equals(Object other) {
            return this.addr.equals(((AddressEntry)other).addr);
        }

        public String toString() {
            return "addr=" + this.addr + ", sock=" + this.sock;
        }
    }
}

