/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.stack;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.net.Socket;
import org.javagroups.Address;
import org.javagroups.Message;
import org.javagroups.log.Trace;
import org.javagroups.protocols.TunnelHeader;
import org.javagroups.stack.IpAddress;
import org.javagroups.util.List;
import org.javagroups.util.Util;

public class RouterStub {
    String router_host = null;
    int router_port = 0;
    Socket sock = null;
    DataOutputStream output = null;
    DataInputStream input = null;
    Address local_addr = null;
    final long RECONNECT_TIMEOUT = 5000L;
    boolean connected = false;

    public RouterStub(String router_host, int router_port) {
        this.router_host = router_host != null ? router_host : "localhost";
        this.router_port = router_port;
    }

    public Address connect() {
        Address ret = null;
        int len = 0;
        try {
            this.sock = new Socket(this.router_host, this.router_port);
            this.sock.setSoLinger(true, 500);
            this.input = new DataInputStream(this.sock.getInputStream());
            len = this.input.readInt();
            byte[] buf = new byte[len];
            this.input.readFully(buf);
            ret = (Address)Util.objectFromByteBuffer(buf);
            this.output = new DataOutputStream(this.sock.getOutputStream());
            this.connected = true;
        }
        catch (Exception e) {
            this.connected = false;
            System.err.println("RouterStub.connect(): " + e);
        }
        if (ret == null && this.sock != null) {
            ret = new IpAddress(this.sock.getLocalPort());
        }
        if (ret != null && this.local_addr == null) {
            this.local_addr = ret;
        }
        return ret;
    }

    public void disconnect() {
        if (this.output != null) {
            try {
                this.output.close();
                this.output = null;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.input != null) {
            try {
                this.input.close();
                this.input = null;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.sock != null) {
            try {
                this.sock.close();
                this.sock = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.connected = false;
    }

    public boolean register(String groupname) {
        byte[] buf = null;
        if (this.sock == null || this.output == null || this.input == null) {
            System.err.println("RouterStub.register(" + groupname + "): no connection to router !");
            this.connected = false;
            return false;
        }
        if (groupname == null || groupname.length() == 0) {
            System.err.println("RouterStub.register(): groupname is null");
            return false;
        }
        if (this.local_addr == null) {
            System.err.println("RouterStub.register(): local_addr is null");
            return false;
        }
        try {
            buf = Util.objectToByteBuffer(this.local_addr);
            this.output.writeInt(-11);
            this.output.writeUTF(groupname);
            this.output.writeInt(buf.length);
            this.output.write(buf, 0, buf.length);
            this.output.flush();
        }
        catch (Exception e) {
            System.err.println("RouterStub.register(): " + e);
            this.connected = false;
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List get(String groupname) {
        block39: {
            block38: {
                block31: {
                    block37: {
                        block36: {
                            block30: {
                                ret = null;
                                tmpsock = null;
                                output = null;
                                input = null;
                                if (groupname == null || groupname.length() == 0) {
                                    System.err.println("RouterStub.get(): groupname argument was null");
                                    return null;
                                }
                                try {
                                    try {
                                        tmpsock = new Socket(this.router_host, this.router_port);
                                        tmpsock.setSoLinger(true, 500);
                                        input = new DataInputStream(tmpsock.getInputStream());
                                        len = input.readInt();
                                        buf = new byte[len];
                                        input.readFully(buf);
                                        output = new DataOutputStream(tmpsock.getOutputStream());
                                        output.writeInt(-10);
                                        output.writeUTF(groupname);
                                        len = input.readInt();
                                        if (len == 0) {
                                            var8_8 = null;
                                            var10_10 = null;
                                            break block30;
                                        }
                                        buf = new byte[len];
                                        input.readFully(buf);
                                        ret = (List)Util.objectFromByteBuffer(buf);
                                        break block31;
                                    }
                                    catch (Exception e) {
                                        Trace.error("RouterStub.get()", "exception=" + e);
                                        var10_12 = null;
                                        try {
                                            if (output != null) {
                                                output.close();
                                            }
                                        }
                                        catch (Exception e) {
                                            // empty catch block
                                        }
                                        try {
                                            if (input != null) {
                                                input.close();
                                            }
                                        }
                                        catch (Exception e) {
                                            // empty catch block
                                        }
                                        try {
                                            if (tmpsock == null) return ret;
                                            tmpsock.close();
                                            return ret;
                                        }
                                        catch (Exception e) {
                                            return ret;
                                        }
                                    }
                                }
                                catch (Throwable var9_18) {
                                    block35: {
                                        block34: {
                                            var10_13 = null;
                                            ** try [egrp 2[TRYBLOCK] [2 : 206->219)] { 
lbl57:
                                            // 1 sources

                                            if (output != null) {
                                                output.close();
                                            }
                                            break block34;
lbl60:
                                            // 1 sources

                                            catch (Exception e) {
                                                // empty catch block
                                            }
                                        }
                                        ** try [egrp 3[TRYBLOCK] [3 : 221->234)] { 
lbl64:
                                        // 1 sources

                                        if (input != null) {
                                            input.close();
                                        }
                                        break block35;
lbl67:
                                        // 1 sources

                                        catch (Exception e) {
                                            // empty catch block
                                        }
                                    }
                                    ** try [egrp 4[TRYBLOCK] [4 : 236->247)] { 
lbl71:
                                    // 1 sources

                                    if (tmpsock == null) throw var9_18;
                                    tmpsock.close();
                                    throw var9_18;
lbl74:
                                    // 1 sources

                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                    throw var9_18;
                                }
                            }
                            ** try [egrp 2[TRYBLOCK] [2 : 206->219)] { 
lbl79:
                            // 1 sources

                            if (output != null) {
                                output.close();
                            }
                            break block36;
lbl82:
                            // 1 sources

                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        ** try [egrp 3[TRYBLOCK] [3 : 221->234)] { 
lbl86:
                        // 1 sources

                        if (input != null) {
                            input.close();
                        }
                        break block37;
lbl89:
                        // 1 sources

                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    ** try [egrp 4[TRYBLOCK] [4 : 236->247)] { 
lbl93:
                    // 1 sources

                    if (tmpsock == null) return var8_8;
                    tmpsock.close();
                    return var8_8;
lbl96:
                    // 1 sources

                    catch (Exception e) {
                        // empty catch block
                    }
                    return var8_8;
                }
                var10_11 = null;
                ** try [egrp 2[TRYBLOCK] [2 : 206->219)] { 
lbl102:
                // 1 sources

                if (output != null) {
                    output.close();
                }
                break block38;
lbl105:
                // 1 sources

                catch (Exception e) {
                    // empty catch block
                }
            }
            ** try [egrp 3[TRYBLOCK] [3 : 221->234)] { 
lbl109:
            // 1 sources

            if (input != null) {
                input.close();
            }
            break block39;
lbl112:
            // 1 sources

            catch (Exception e) {
                // empty catch block
            }
        }
        try {}
        catch (Exception e) {}
        if (tmpsock == null) return ret;
        tmpsock.close();
        return ret;
        return ret;
    }

    public boolean send(Message msg, String groupname) {
        byte[] msg_buf = null;
        byte[] dst_buf = null;
        Address dst_addr = null;
        if (this.sock == null || this.output == null || this.input == null) {
            System.err.println("RouterStub.send(): no connection to router !");
            this.connected = false;
            return false;
        }
        if (msg == null) {
            System.err.println("RouterStub.send(): message is null");
            return false;
        }
        try {
            dst_addr = msg.getDest();
            if (dst_addr != null) {
                dst_buf = Util.objectToByteBuffer(dst_addr);
            }
            msg_buf = Util.objectToByteBuffer(msg);
            this.output.writeUTF(groupname);
            if (dst_buf != null && dst_buf.length > 0) {
                this.output.writeInt(dst_buf.length);
                this.output.write(dst_buf, 0, dst_buf.length);
            } else {
                this.output.writeInt(0);
            }
            this.output.writeInt(msg_buf.length);
            this.output.write(msg_buf, 0, msg_buf.length);
        }
        catch (Exception e) {
            System.err.println("RouterStub.send(): " + e);
            this.connected = false;
            return false;
        }
        return true;
    }

    public Message receive() {
        Message ret = null;
        byte[] buf = null;
        if (this.sock == null || this.output == null || this.input == null) {
            System.err.println("RouterStub.receive(): no connection to router !");
            this.connected = false;
            return null;
        }
        try {
            int len = this.input.readInt();
            if (len == 0) {
                ret = null;
            } else {
                buf = new byte[len];
                this.input.readFully(buf, 0, len);
                ret = (Message)Util.objectFromByteBuffer(buf);
            }
        }
        catch (Exception e) {
            this.connected = false;
            System.err.println("RouterStub.receive(): " + e);
            return null;
        }
        return ret;
    }

    public synchronized boolean reconnect() {
        Address new_addr = null;
        if (this.connected) {
            return false;
        }
        this.disconnect();
        while ((new_addr = this.connect()) == null) {
            Util.sleep(5000L);
        }
        System.out.println("RouterStub.reconnect(): new address is " + new_addr);
        return true;
    }

    public static void main(String[] args) {
        Message msg;
        if (args.length != 2) {
            System.out.println("RouterStub <host> <port>");
            return;
        }
        RouterStub stub = new RouterStub(args[0], new Integer(args[1]));
        Address my_addr = stub.connect();
        String groupname = "BelaGroup";
        System.out.println("My address is " + my_addr);
        System.out.println("Registering under BelaGroup");
        boolean rc = stub.register("BelaGroup");
        System.out.println("Done, rc=" + rc);
        System.out.println("Getting members of BelaGroup: ");
        List mbrs = stub.get("BelaGroup");
        System.out.println("Done, mbrs are " + mbrs);
        int i = 0;
        while (i < 10) {
            msg = new Message(null, my_addr, (Serializable)((Object)("Bela #" + i)));
            msg.addHeader(new TunnelHeader("BelaGroup"));
            rc = stub.send(msg, "BelaGroup");
            System.out.println("Sent msg, rc=" + rc);
            ++i;
        }
        int i2 = 0;
        while (i2 < 10) {
            System.out.println("stub.receive():");
            msg = stub.receive();
            System.out.println("Received msg");
            ++i2;
        }
        stub.disconnect();
    }
}

