/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.util;

import java.util.Vector;
import org.javagroups.TimeoutException;
import org.javagroups.log.Trace;
import org.javagroups.util.QueueClosedException;

public class Queue {
    Element head = null;
    Element tail = null;
    boolean closed = false;
    int size = 0;
    Object mutex = new Object();
    int num_markers = 0;

    public boolean closed() {
        return this.closed;
    }

    public void add(Object obj) throws QueueClosedException {
        if (this.closed) {
            throw new QueueClosedException();
        }
        if (this.num_markers > 0) {
            throw new QueueClosedException("Queue.add(): queue has been closed. You can not add more elements. Waiting for removal of remaining elements.");
        }
        Object object = this.mutex;
        synchronized (object) {
            Element el = new Element(obj);
            if (this.head == null) {
                this.tail = this.head = el;
                this.size = 1;
            } else {
                this.tail.next = el;
                this.tail = el;
                ++this.size;
            }
            this.mutex.notifyAll();
        }
    }

    public void addAtHead(Object obj) throws QueueClosedException {
        if (this.closed) {
            throw new QueueClosedException();
        }
        if (this.num_markers > 0) {
            throw new QueueClosedException("Queue.addAtHead(): queue has been closed. You can not add more elements. Waiting for removal of remaining elements.");
        }
        Object object = this.mutex;
        synchronized (object) {
            Element el = new Element(obj);
            if (this.head == null) {
                this.tail = this.head = el;
                this.size = 1;
            } else {
                el.next = this.head;
                this.head = el;
                ++this.size;
            }
            this.mutex.notifyAll();
        }
    }

    private Object removeInternal() {
        Element retval = null;
        if (this.head == null) {
            return null;
        }
        retval = this.head;
        if (this.head == this.tail) {
            this.head = null;
            this.tail = null;
        } else {
            this.head = this.head.next;
        }
        --this.size;
        if (this.head != null && this.head.obj instanceof _EndMarker) {
            this.closed = true;
        }
        return retval.obj;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Object remove() throws QueueClosedException {
        Object retval = null;
        Object object = this.mutex;
        // MONITORENTER : object
        while (this.size == 0) {
            if (this.closed) {
                throw new QueueClosedException();
            }
            try {
                this.mutex.wait();
            }
            catch (IllegalMonitorStateException ex) {
                throw ex;
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        if (this.closed) {
            throw new QueueClosedException();
        }
        retval = this.removeInternal();
        // MONITOREXIT : object
        if (retval == null) {
            return null;
        }
        if (!(retval instanceof _EndMarker)) return retval;
        this.close(false);
        throw new QueueClosedException();
    }

    public Object remove(long timeout) throws QueueClosedException, TimeoutException {
        Object retval = null;
        Object object = this.mutex;
        synchronized (object) {
            if (this.size == 0) {
                if (this.closed) {
                    throw new QueueClosedException();
                }
                try {
                    this.mutex.wait(timeout);
                }
                catch (IllegalMonitorStateException ex) {
                    throw ex;
                }
                catch (IllegalArgumentException ex2) {
                    throw ex2;
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            if (this.closed) {
                throw new QueueClosedException();
            }
            retval = this.removeInternal();
            if (retval == null) {
                throw new TimeoutException();
            }
            if (retval instanceof _EndMarker) {
                this.close(false);
                throw new QueueClosedException();
            }
            Object object2 = retval;
            return object2;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void removeElement(Object obj) throws QueueClosedException {
        var4_2 = this.mutex;
        synchronized (var4_2) {
            el = this.head;
            if (el == null) {
                return;
            }
            if (!el.obj.equals(obj)) ** GOTO lbl21
            this.head = el.next;
            el.next = null;
            if (this.size == 1) {
                this.tail = this.head;
            }
            --this.size;
            return;
lbl-1000:
            // 1 sources

            {
                if (el.next.obj.equals(obj)) {
                    tmp_el = el.next;
                    el.next = el.next.next;
                    tmp_el.next = null;
                    --this.size;
                    break;
                }
                el = el.next;
lbl21:
                // 2 sources

                ** while (el.next != null)
            }
lbl22:
            // 2 sources

        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Object peek() throws QueueClosedException {
        Object retval = null;
        Object object = this.mutex;
        // MONITORENTER : object
        while (this.size == 0) {
            if (this.closed) {
                throw new QueueClosedException();
            }
            try {
                this.mutex.wait();
            }
            catch (IllegalMonitorStateException ex) {
                throw ex;
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        if (this.closed) {
            throw new QueueClosedException();
        }
        retval = this.head != null ? this.head.obj : null;
        // MONITOREXIT : object
        if (retval == null) {
            return null;
        }
        if (!(retval instanceof _EndMarker)) return retval;
        this.close(false);
        throw new QueueClosedException();
    }

    public Object peek(long timeout) throws QueueClosedException, TimeoutException {
        Object retval = null;
        Object object = this.mutex;
        synchronized (object) {
            if (this.size == 0) {
                if (this.closed) {
                    throw new QueueClosedException();
                }
                try {
                    this.mutex.wait(timeout);
                }
                catch (IllegalMonitorStateException ex) {
                    throw ex;
                }
                catch (IllegalArgumentException ex2) {
                    throw ex2;
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            if (this.closed) {
                throw new QueueClosedException();
            }
            Object object2 = retval = this.head != null ? this.head.obj : null;
            if (retval == null) {
                throw new TimeoutException();
            }
            if (retval instanceof _EndMarker) {
                this.close(false);
                throw new QueueClosedException();
            }
            Object object3 = retval;
            return object3;
        }
    }

    public void close(boolean flush_entries) {
        if (flush_entries) {
            try {
                this.add(new _EndMarker());
                ++this.num_markers;
            }
            catch (QueueClosedException queueClosedException) {
                // empty catch block
            }
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            this.closed = true;
            try {
                this.mutex.notifyAll();
            }
            catch (Exception e) {
                Trace.error("Queue.close()", "exception=" + e);
            }
        }
    }

    public void reset() {
        this.num_markers = 0;
        if (!this.closed) {
            this.close(false);
        }
        Object object = this.mutex;
        synchronized (object) {
            this.size = 0;
            this.head = null;
            this.tail = null;
        }
        this.closed = false;
    }

    public int size() {
        return this.size - this.num_markers;
    }

    public String toString() {
        return "Queue (" + this.size() + ") messages";
    }

    public Vector getContents() {
        Vector<Object> retval = new Vector<Object>();
        Object object = this.mutex;
        synchronized (object) {
            Element el = this.head;
            while (el != null) {
                retval.addElement(el.obj);
                el = el.next;
            }
        }
        return retval;
    }

    class Element {
        Object obj = null;
        Element next = null;

        Element(Object o) {
            this.obj = o;
        }

        public String toString() {
            return this.obj != null ? this.obj.toString() : "null";
        }
    }

    class _EndMarker {
        _EndMarker() {
        }
    }
}

