/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.util;

import org.javagroups.log.Trace;

public class ReusableThread
implements Runnable {
    volatile Thread thread = null;
    Runnable task = null;
    String thread_name = "ReusableThread";
    volatile boolean suspended = false;
    long TASK_JOIN_TIME = 3000L;

    public ReusableThread() {
    }

    public ReusableThread(String thread_name) {
        this.thread_name = thread_name;
    }

    public void finalize() {
        this.stop();
    }

    public void start() {
        ReusableThread reusableThread = this;
        synchronized (reusableThread) {
            if (this.thread == null) {
                this.thread = new Thread((Runnable)this, this.thread_name);
                this.thread.start();
            }
        }
    }

    public void stop() {
        Thread tmp = null;
        boolean ret = true;
        if (Trace.trace) {
            Trace.info("ReusableThread.stop()", "entering THIS");
        }
        ReusableThread reusableThread = this;
        synchronized (reusableThread) {
            if (Trace.trace) {
                Trace.info("ReusableThread.stop()", "entered THIS (thread=" + this.printObj(this.thread) + ", task=" + this.printObj(this.task) + ", suspended=" + this.suspended + ")");
            }
            if (this.thread != null && this.thread.isAlive()) {
                tmp = this.thread;
                this.thread = null;
                this.task = null;
                if (Trace.trace) {
                    Trace.info("ReusableThread.stop()", "notifying thread");
                }
                this.notifyAll();
                if (Trace.trace) {
                    Trace.info("ReusableThread.stop()", "notifying thread completed");
                }
            }
            this.thread = null;
            this.task = null;
        }
        if (tmp != null && tmp.isAlive()) {
            long s1 = System.currentTimeMillis();
            long s2 = 0L;
            if (Trace.trace) {
                Trace.info("ReusableThread.stop()", "join(" + this.TASK_JOIN_TIME + ")");
            }
            try {
                tmp.join(this.TASK_JOIN_TIME);
            }
            catch (Exception e) {
                // empty catch block
            }
            s2 = System.currentTimeMillis();
            if (Trace.trace) {
                Trace.info("ReusableThread.stop()", "join(" + this.TASK_JOIN_TIME + ") completed in " + (s2 - s1));
            }
            if (tmp.isAlive()) {
                Trace.error("ReusableThread.stop()", "thread is still alive");
            }
            Object var1_1 = null;
        }
    }

    public void suspend() {
        ReusableThread reusableThread = this;
        synchronized (reusableThread) {
            if (Trace.trace) {
                Trace.info("ReusableThread.suspend()", "suspended=" + this.suspended + ", task=" + this.printObj(this.task));
            }
            if (this.suspended) {
                return;
            }
            this.suspended = true;
        }
    }

    public void resume() {
        ReusableThread reusableThread = this;
        synchronized (reusableThread) {
            this.suspended = false;
            this.notifyAll();
        }
    }

    public boolean assignTask(Runnable task) {
        ReusableThread reusableThread = this;
        synchronized (reusableThread) {
            this.start();
            if (this.task == null) {
                this.task = task;
                this.notifyAll();
                boolean bl = true;
                return bl;
            }
            Trace.error("ReusableThread.assignTask()", "already working on a thread");
            boolean bl = false;
            return bl;
        }
    }

    public void run() {
        while (this.thread != null) {
            ReusableThread reusableThread;
            block35: {
                block34: {
                    try {
                        if (Trace.trace) {
                            Trace.info("ReusableThread.run()", "entering ASSIGN");
                        }
                        reusableThread = this;
                        synchronized (reusableThread) {
                            if (Trace.trace) {
                                Trace.info("ReusableThread.run()", "entered ASSIGN (task=" + this.printObj(this.task) + ", thread=" + this.printObj(this.thread) + ")");
                            }
                            while (this.task == null && this.thread != null) {
                                if (Trace.trace) {
                                    Trace.info("ReusableThread.run()", "wait ASSIGN");
                                }
                                this.wait();
                                if (!Trace.trace) continue;
                                Trace.info("ReusableThread.run()", "wait ASSIGN completed");
                            }
                        }
                    }
                    catch (InterruptedException ex) {
                        if (!Trace.trace) break block34;
                        Trace.info("ReusableThread.run()", "interrupt on ASSIGN");
                    }
                }
                if (this.thread == null) {
                    return;
                }
                try {
                    if (Trace.trace) {
                        Trace.info("ReusableThread.run()", "entering SUSPEND");
                    }
                    ReusableThread ex = this;
                    synchronized (ex) {
                        if (Trace.trace) {
                            Trace.info("ReusableThread.run()", "entered SUSPEND (suspended=" + this.suspended + ", task=" + this.printObj(this.task) + ")");
                        }
                        while (this.suspended && this.thread != null) {
                            if (Trace.trace) {
                                Trace.info("ReusableThread.run()", "wait SUSPEND");
                            }
                            this.wait();
                            if (!Trace.trace) continue;
                            Trace.info("ReusableThread.run()", "wait SUSPEND completed");
                        }
                    }
                }
                catch (InterruptedException ex) {
                    if (!Trace.trace) break block35;
                    Trace.info("ReusableThread.run()", "interrupt on RESUME");
                }
            }
            if (this.thread == null) {
                return;
            }
            if (this.task != null) {
                if (Trace.trace) {
                    Trace.info("ReusableThread.run()", "running task");
                }
                try {
                    this.task.run();
                }
                catch (Throwable ex) {
                    Trace.error("ReusableThread().run()", "exception=" + ex);
                }
                if (Trace.trace) {
                    Trace.info("ReusableThread.run()", "task completed");
                }
            }
            if (Trace.trace) {
                Trace.info("ReusableThread.run()", "entering THIS");
            }
            reusableThread = this;
            synchronized (reusableThread) {
                if (Trace.trace) {
                    Trace.info("ReusableThread.run()", "entered THIS");
                }
                this.task = null;
                if (Trace.trace) {
                    Trace.info("ReusableThread.run()", "notify THIS");
                }
                this.notifyAll();
                if (Trace.trace) {
                    Trace.info("ReusableThread.run()", "notify THIS completed");
                }
            }
        }
        if (Trace.trace) {
            Trace.info("ReusableThread.run()", "terminated");
        }
    }

    String printObj(Object obj) {
        if (obj == null) {
            return "null";
        }
        return "non-null";
    }

    public boolean done() {
        return this.task == null;
    }

    public boolean available() {
        return this.done();
    }

    public void waitUntilDone() {
        if (Trace.trace) {
            Trace.info("ReusableThread.waitUntilDone()", "entering THIS");
        }
        ReusableThread reusableThread = this;
        synchronized (reusableThread) {
            if (Trace.trace) {
                Trace.info("ReusableThread.waitUntilDone()", "entered THIS (task=" + this.printObj(this.task) + ")");
            }
            while (this.task != null) {
                try {
                    if (Trace.trace) {
                        Trace.info("ReusableThread.waitUntilDone()", "wait THIS");
                    }
                    this.wait();
                    if (!Trace.trace) continue;
                    Trace.info("ReusableThread.waitUntilDone()", "wait THIS completed");
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public String toString() {
        return "suspended=" + this.suspended;
    }
}

