/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.util;

import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.util.Rsp;

public class RspList {
    Vector rsps = new Vector();

    public void reset() {
        this.rsps.removeAllElements();
    }

    public void addRsp(Address sender, Object retval) {
        Rsp rsp = this.find(sender);
        if (rsp != null) {
            rsp.sender = sender;
            rsp.retval = retval;
            rsp.received = true;
            rsp.suspected = false;
            return;
        }
        this.rsps.addElement(new Rsp((Object)sender, retval));
    }

    public void addNotReceived(Address sender) {
        Rsp rsp = this.find(sender);
        if (rsp == null) {
            this.rsps.addElement(new Rsp(sender));
        }
    }

    public void addSuspect(Address sender) {
        Rsp rsp = this.find(sender);
        if (rsp != null) {
            rsp.sender = sender;
            rsp.retval = null;
            rsp.received = false;
            rsp.suspected = true;
            return;
        }
        this.rsps.addElement(new Rsp((Object)sender, true));
    }

    public boolean isReceived(Address sender) {
        Rsp rsp = this.find(sender);
        if (rsp == null) {
            return false;
        }
        return rsp.received;
    }

    public int numSuspectedMembers() {
        int num = 0;
        int i = 0;
        while (i < this.rsps.size()) {
            Rsp rsp = (Rsp)this.rsps.elementAt(i);
            if (rsp.wasSuspected()) {
                ++num;
            }
            ++i;
        }
        return num;
    }

    public Object getFirst() {
        return this.rsps.size() > 0 ? ((Rsp)this.rsps.elementAt(0)).getValue() : null;
    }

    public Vector getResults() {
        Vector<Object> ret = new Vector<Object>();
        int i = 0;
        while (i < this.rsps.size()) {
            Object val;
            Rsp rsp = (Rsp)this.rsps.elementAt(i);
            if (rsp.wasReceived() && (val = rsp.getValue()) != null) {
                ret.addElement(val);
            }
            ++i;
        }
        return ret;
    }

    public Vector getSuspectedMembers() {
        Vector<Object> retval = new Vector<Object>();
        int i = 0;
        while (i < this.rsps.size()) {
            Rsp rsp = (Rsp)this.rsps.elementAt(i);
            if (rsp.wasSuspected()) {
                retval.addElement(rsp.getSender());
            }
            ++i;
        }
        return retval;
    }

    public boolean isSuspected(Address sender) {
        Rsp rsp = this.find(sender);
        if (rsp == null) {
            return false;
        }
        return rsp.suspected;
    }

    public Object get(Address sender) {
        Rsp rsp = this.find(sender);
        if (rsp == null) {
            return null;
        }
        return rsp.retval;
    }

    public int size() {
        return this.rsps.size();
    }

    public Object elementAt(int i) throws ArrayIndexOutOfBoundsException {
        return this.rsps.elementAt(i);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        int i = 0;
        while (i < this.rsps.size()) {
            Rsp rsp = (Rsp)this.rsps.elementAt(i);
            ret.append("[" + rsp + "]\n");
            ++i;
        }
        return ret.toString();
    }

    boolean contains(Address sender) {
        int i = 0;
        while (i < this.rsps.size()) {
            Rsp rsp = (Rsp)this.rsps.elementAt(i);
            if (rsp.sender != null && sender != null && rsp.sender.equals(sender)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    Rsp find(Address sender) {
        int i = 0;
        while (i < this.rsps.size()) {
            Rsp rsp = (Rsp)this.rsps.elementAt(i);
            if (rsp.sender != null && sender != null && rsp.sender.equals(sender)) {
                return rsp;
            }
            ++i;
        }
        return null;
    }
}

