/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.util;

import org.javagroups.log.Trace;
import org.javagroups.util.Queue;
import org.javagroups.util.QueueClosedException;
import org.javagroups.util.ReusableThread;
import org.javagroups.util.SchedulerListener;
import org.javagroups.util.ThreadPool;
import org.javagroups.util.Util;

public class Scheduler
implements Runnable {
    Queue queue = new Queue();
    Thread sched_thread = null;
    Task current_task = null;
    ThreadPool pool = null;
    int NUM_THREADS = 10;
    final int WAIT_FOR_THREAD_AVAILABILITY = 3000;
    final int THREAD_JOIN_TIMEOUT = 1000;
    SchedulerListener listener = null;
    Object queue_mutex = new Object();
    boolean trace = false;

    public Scheduler() {
    }

    public Scheduler(int num_threads) {
        this.NUM_THREADS = num_threads;
    }

    public Scheduler(int num_threads, boolean trace) {
        this(num_threads);
        this.trace = trace;
    }

    public void setListener(SchedulerListener l) {
        this.listener = l;
    }

    public void run() {
        while (this.sched_thread != null && !this.queue.closed()) {
            try {
                this.current_task = (Task)this.queue.peek();
                if (this.current_task.suspended) {
                    this.current_task.suspended = false;
                    this.current_task.thread.resume();
                    if (this.listener != null) {
                        this.listener.resumed(this.current_task.target);
                    }
                } else if (this.current_task.thread == null) {
                    this.current_task.thread = this.pool.getThread();
                    if (this.current_task.thread == null) {
                        Util.sleep(3000L);
                        continue;
                    }
                    if (this.listener != null) {
                        this.listener.started(this.current_task.target);
                    }
                    if (!this.current_task.thread.assignTask(this.current_task.target)) {
                        continue;
                    }
                } else {
                    if (this.listener != null) {
                        this.listener.started(this.current_task.target);
                    }
                    if (!this.current_task.thread.assignTask(this.current_task.target)) continue;
                }
                if (this.sched_thread.isInterrupted()) {
                    this.sched_thread.interrupt();
                }
                ReusableThread reusableThread = this.current_task.thread;
                synchronized (reusableThread) {
                    while (!this.current_task.thread.done() && !this.current_task.thread.suspended) {
                        this.current_task.thread.wait();
                    }
                }
                if (this.listener != null) {
                    this.listener.stopped(this.current_task.target);
                }
                this.queue.removeElement(this.current_task);
            }
            catch (InterruptedException interrupted) {
                if (this.sched_thread == null || this.queue.closed()) {
                    return;
                }
                if (this.current_task.thread != null) {
                    this.current_task.thread.suspend();
                    if (this.listener != null) {
                        this.listener.suspended(this.current_task.target);
                    }
                    this.current_task.suspended = true;
                }
                Thread.interrupted();
            }
            catch (QueueClosedException closed_ex) {
                return;
            }
            catch (Exception ex) {
                Trace.error("Scheduler.run()", "exception=" + ex);
            }
        }
    }

    public void addPrio(Runnable task) {
        Task new_task = new Task(task);
        try {
            Object object = this.queue_mutex;
            synchronized (object) {
                if (this.queue.size() == 0) {
                    this.queue.add(new_task);
                } else {
                    this.queue.addAtHead(new_task);
                    this.sched_thread.interrupt();
                }
            }
        }
        catch (Exception e) {
            Trace.error("Scheduler.addPrio()", "exception=" + e);
        }
    }

    public void add(Runnable task) {
        Task new_task = new Task(task);
        try {
            Object object = this.queue_mutex;
            synchronized (object) {
                this.queue.add(new_task);
            }
        }
        catch (Exception e) {
            Trace.error("Scheduler.add()", "exception=" + e);
        }
    }

    public void start() {
        if (this.queue.closed()) {
            this.queue.reset();
        }
        if (this.sched_thread == null) {
            this.pool = new ThreadPool(this.NUM_THREADS);
            this.sched_thread = new Thread((Runnable)this, "Scheduler main thread");
            this.sched_thread.start();
        }
    }

    public void stop() {
        Thread tmp = null;
        if (this.queue != null) {
            this.queue.close(false);
        }
        if (this.sched_thread != null && this.sched_thread.isAlive()) {
            tmp = this.sched_thread;
            this.sched_thread = null;
            tmp.interrupt();
            try {
                tmp.join(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tmp.isAlive()) {
                Trace.error("Scheduler.stop()", "scheduler thread is still not dead  !!!");
            }
        }
        this.sched_thread = null;
        if (this.pool != null) {
            this.pool.destroy();
            this.pool = null;
        }
    }

    public class Task {
        ReusableThread thread = null;
        Runnable target = null;
        boolean suspended = false;

        Task(Runnable target) {
            this.target = target;
        }

        public String toString() {
            return "[thread=" + this.thread + ", target=" + this.target + ", suspended=" + this.suspended + "]";
        }
    }
}

