/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.util;

import org.javagroups.log.Trace;
import org.javagroups.util.ReusableThread;

public class ThreadPool {
    int MAX_NUM = 255;
    int current_index = 0;
    ReusableThread[] pool = null;
    boolean[] available_threads = null;

    public ThreadPool(int max_num) {
        this.MAX_NUM = max_num;
        this.pool = new ReusableThread[this.MAX_NUM];
        this.available_threads = new boolean[this.MAX_NUM];
        int i = 0;
        while (i < this.pool.length) {
            this.pool[i] = null;
            this.available_threads[i] = true;
            ++i;
        }
    }

    public ReusableThread getThread() {
        ReusableThread retval = null;
        ReusableThread[] reusableThreadArray = this.pool;
        synchronized (reusableThreadArray) {
            int i = 0;
            while (i < this.current_index) {
                ReusableThread tmp = this.pool[i];
                if (tmp.available()) {
                    ReusableThread reusableThread = tmp;
                    return reusableThread;
                }
                ++i;
            }
            if (this.current_index >= this.MAX_NUM) {
                Trace.error("ThreadPool.getThread()", "could not create new thread because pool's max size reached (" + this.MAX_NUM + ") !");
                ReusableThread reusableThread = null;
                return reusableThread;
            }
            retval = new ReusableThread();
            this.pool[this.current_index++] = retval;
            ReusableThread reusableThread = retval;
            return reusableThread;
        }
    }

    public void destroy() {
        this.deletePool();
    }

    public void finalize() {
        this.deletePool();
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ReusableThread[] reusableThreadArray = this.pool;
        synchronized (reusableThreadArray) {
            ret.append("ThreadPool: capacity=" + this.pool.length + ", index=" + this.current_index + "\n");
            ret.append("Threads are:\n");
            int i = 0;
            while (i < this.current_index) {
                ret.append("[" + i + ": " + this.pool[i] + "]\n");
                ++i;
            }
        }
        return ret.toString();
    }

    void deletePool() {
        ReusableThread[] reusableThreadArray = this.pool;
        synchronized (reusableThreadArray) {
            int i = 0;
            while (i < this.MAX_NUM) {
                ReusableThread t = this.pool[i];
                if (t != null) {
                    t.stop();
                    this.pool[i] = null;
                }
                ++i;
            }
            this.current_index = 0;
        }
    }
}

