/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.javagroups.log.Trace;

public class TimeScheduler {
    private static final long SUSPEND_INTERVAL = 2000L;
    private static final long TICK_INTERVAL = 1000L;
    private static final int RUN = 0;
    private static final int SUSPEND = 1;
    private static final int STOPPING = 2;
    private static final int STOP = 3;
    private static final String THREAD_NAME = "TimeScheduler.Thread";
    private Thread thread = null;
    private int thread_state = 1;
    private long suspend_interval = 2000L;
    private TaskQueue queue = new TaskQueue();

    private String _toString(Throwable ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        return sw.toString();
    }

    private void _start() {
        this.thread_state = 0;
        this.thread = new Thread((Runnable)new Loop(), THREAD_NAME);
        this.thread.start();
    }

    private void _unsuspend() {
        this.thread_state = 0;
        this.thread = new Thread((Runnable)new Loop(), THREAD_NAME);
        this.thread.start();
    }

    private void _suspend() {
        this.thread_state = 1;
        this.thread = null;
    }

    private void _stopping() {
        this.thread_state = 2;
    }

    private void _stop() {
        this.thread_state = 3;
        this.thread = null;
    }

    private void _run() {
        while (true) {
            Task task;
            TimeScheduler timeScheduler = this;
            synchronized (timeScheduler) {
                if (this.thread == null || this.thread.isInterrupted()) {
                    return;
                }
            }
            TaskQueue taskQueue = this.queue;
            synchronized (taskQueue) {
                long waitTime;
                IntTask intTask;
                if (this.queue.isEmpty()) {
                    try {
                        this.queue.wait(this.suspend_interval);
                    }
                    catch (InterruptedException ex) {
                        return;
                    }
                    if (this.queue.isEmpty()) {
                        this._suspend();
                        return;
                    }
                }
                Trace.debug("TimeScheduler._run()", "task queue has " + this.queue.size() + " items: " + this.queue);
                IntTask ex = intTask = this.queue.getFirst();
                synchronized (ex) {
                    task = intTask.task;
                    if (task.cancelled()) {
                        this.queue.removeFirst();
                        continue;
                    }
                    long execTime = intTask.sched;
                    long currTime = System.currentTimeMillis();
                    waitTime = execTime - currTime;
                    if (waitTime <= 0L) {
                        long intervalTime = task.nextInterval();
                        Trace.debug("TimeScheduler._run()", "nextInterval for " + task + " is " + intervalTime);
                        long schedTime = intTask.relative ? currTime + intervalTime : execTime + intervalTime;
                        this.queue.rescheduleFirst(schedTime);
                    }
                }
                if (waitTime > 0L) {
                    Trace.debug("TimeScheduler._run()", "waitTime=" + waitTime);
                    try {
                        this.queue.wait(waitTime);
                    }
                    catch (InterruptedException ex2) {
                        return;
                    }
                }
            }
            try {
                task.run();
                continue;
            }
            catch (Exception ex) {
                Trace.println("TimeScheduler", 4, this._toString(ex));
                continue;
            }
            break;
        }
    }

    public TimeScheduler(long suspend_interval) {
        this.suspend_interval = suspend_interval;
    }

    public TimeScheduler() {
        this(2000L);
    }

    public void add(Task t, boolean relative) {
        long interval = t.nextInterval();
        if (interval < 0L) {
            return;
        }
        long sched = System.currentTimeMillis() + interval;
        TaskQueue taskQueue = this.queue;
        synchronized (taskQueue) {
            this.queue.add(new IntTask(t, sched, relative));
            switch (this.thread_state) {
                case 0: {
                    this.queue.notifyAll();
                    break;
                }
                case 1: {
                    this._unsuspend();
                    break;
                }
                case 2: {
                    break;
                }
            }
        }
    }

    public void add(Task t) {
        this.add(t, true);
    }

    public void start() {
        TaskQueue taskQueue = this.queue;
        synchronized (taskQueue) {
            switch (this.thread_state) {
                case 0: {
                    break;
                }
                case 1: {
                    this._unsuspend();
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    this._start();
                }
            }
        }
    }

    public void stop() throws InterruptedException {
        TaskQueue taskQueue = this.queue;
        synchronized (taskQueue) {
            switch (this.thread_state) {
                case 0: {
                    this._stopping();
                    break;
                }
                case 1: {
                    this._stop();
                    return;
                }
                case 2: {
                    return;
                }
                case 3: {
                    return;
                }
            }
            this.thread.interrupt();
        }
        this.thread.join();
        TaskQueue taskQueue2 = this.queue;
        synchronized (taskQueue2) {
            this.queue.clear();
            this._stop();
        }
    }

    private static class TaskQueue {
        private SortedSet set = new TreeSet();

        public void add(IntTask t) {
            this.set.add(t);
        }

        public IntTask getFirst() {
            return (IntTask)this.set.first();
        }

        public void removeFirst() {
            Iterator it = this.set.iterator();
            IntTask t = (IntTask)it.next();
            it.remove();
        }

        public void rescheduleFirst(long sched) {
            Iterator it = this.set.iterator();
            IntTask t = (IntTask)it.next();
            it.remove();
            t.sched = sched;
            this.set.add(t);
        }

        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        public void clear() {
            this.set.clear();
        }

        public int size() {
            return this.set.size();
        }

        public String toString() {
            return this.set.toString();
        }
    }

    private class Loop
    implements Runnable {
        private Loop() {
        }

        public void run() {
            TimeScheduler.this._run();
        }
    }

    private static class IntTask
    implements Comparable {
        public Task task;
        public long sched;
        public boolean relative;

        public IntTask(Task task, long sched, boolean relative) {
            this.task = task;
            this.sched = sched;
            this.relative = relative;
        }

        public int compareTo(Object obj) {
            if (!(obj instanceof IntTask)) {
                return -1;
            }
            IntTask other = (IntTask)obj;
            if (this.sched < other.sched) {
                return -1;
            }
            if (this.sched > other.sched) {
                return 1;
            }
            return this.task.hashCode() - other.task.hashCode();
        }

        public String toString() {
            if (this.task == null) {
                return "<unnamed>";
            }
            return this.task.getClass().getName();
        }
    }

    public static interface Task {
        public boolean cancelled();

        public long nextInterval();

        public void run();
    }
}

