/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.util;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.javagroups.util.Util;

public class TimedWriter {
    Thread thread = null;
    long timeout = 2000L;
    boolean completed = true;
    Exception write_ex = null;
    Socket sock = null;

    void start(InetAddress local, InetAddress remote, int peer_port) {
        this.stop();
        this.thread = new SocketCreator(local, remote, peer_port);
        this.thread.start();
    }

    void start(OutputStream out, byte[] buf) {
        this.stop();
        this.thread = new WriterThread(out, buf);
        this.thread.start();
    }

    void start(OutputStream out, int i) {
        this.stop();
        this.thread = new WriterThread(out, i);
        this.thread.start();
    }

    void stop() {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.interrupt();
            try {
                this.thread.join(this.timeout);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void write(OutputStream out, byte[] buf, long timeout) throws Exception, Timeout, InterruptedException {
        if (out == null || buf == null) {
            System.err.println("TimedWriter.write(): output stream or buffer is null, ignoring write");
            return;
        }
        try {
            this.timeout = timeout;
            this.completed = false;
            this.start(out, buf);
            if (this.thread == null) {
                Object var7_4 = null;
                this.stop();
                return;
            }
            this.thread.join(timeout);
            if (!this.completed) {
                throw new Timeout();
            }
            if (this.write_ex != null) {
                Exception tmp = this.write_ex;
                this.write_ex = null;
                throw tmp;
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.stop();
            throw throwable;
        }
        Object var7_5 = null;
        this.stop();
    }

    public synchronized void write(OutputStream out, int i, long timeout) throws Exception, Timeout, InterruptedException {
        if (out == null) {
            System.err.println("TimedWriter.write(): output stream is null, ignoring write");
            return;
        }
        try {
            this.timeout = timeout;
            this.completed = false;
            this.start(out, i);
            if (this.thread == null) {
                Object var7_4 = null;
                this.stop();
                return;
            }
            this.thread.join(timeout);
            if (!this.completed) {
                throw new Timeout();
            }
            if (this.write_ex != null) {
                Exception tmp = this.write_ex;
                this.write_ex = null;
                throw tmp;
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.stop();
            throw throwable;
        }
        Object var7_5 = null;
        this.stop();
    }

    public synchronized Socket createSocket(InetAddress local, InetAddress remote, int port, long timeout) throws Exception, Timeout, InterruptedException {
        Socket socket;
        Object ret = null;
        try {
            this.timeout = timeout;
            this.completed = false;
            this.start(local, remote, port);
            if (this.thread == null) {
                Socket socket2 = null;
                Object var10_7 = null;
                this.stop();
                return socket2;
            }
            this.thread.join(timeout);
            if (!this.completed) {
                throw new Timeout();
            }
            if (this.write_ex != null) {
                Exception tmp = this.write_ex;
                this.write_ex = null;
                throw tmp;
            }
            socket = this.sock;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this.stop();
            throw throwable;
        }
        Object var10_8 = null;
        this.stop();
        return socket;
    }

    public static void main(String[] args) {
        TimedWriter w = new TimedWriter();
        InetAddress local = null;
        InetAddress remote = null;
        int port = 0;
        Socket sock = null;
        if (args.length != 3) {
            System.err.println("TimedWriter <local host> <remote host> <remote port>");
            return;
        }
        try {
            local = InetAddress.getByName(args[0]);
            remote = InetAddress.getByName(args[1]);
            port = new Integer(args[2]);
        }
        catch (Exception e) {
            System.err.println("Could find host " + remote);
            return;
        }
        while (true) {
            try {
                sock = w.createSocket(local, remote, port, 3000L);
                if (sock == null) continue;
                System.out.println("Connection created");
                return;
            }
            catch (Timeout timeout) {
                System.err.println("Timed out creating socket");
                continue;
            }
            catch (Exception io_ex) {
                System.err.println("Connection could not be created, retrying");
                Util.sleep(2000L);
                continue;
            }
            break;
        }
    }

    class SocketCreator
    extends Thread {
        InetAddress local = null;
        InetAddress remote = null;
        int peer_port = 0;

        public SocketCreator(InetAddress local, InetAddress remote, int peer_port) {
            this.local = local;
            this.remote = remote;
            this.peer_port = peer_port;
        }

        public void run() {
            TimedWriter.this.completed = false;
            TimedWriter.this.sock = null;
            try {
                TimedWriter.this.sock = new Socket(this.remote, this.peer_port, this.local, 0);
            }
            catch (IOException io_ex) {
                TimedWriter.this.write_ex = io_ex;
            }
            TimedWriter.this.completed = true;
        }
    }

    class WriterThread
    extends Thread {
        DataOutputStream out = null;
        byte[] buf = null;
        int i = 0;

        public WriterThread(OutputStream out, byte[] buf) {
            this.out = new DataOutputStream(out);
            this.buf = buf;
            this.setName("TimedWriter.WriterThread");
        }

        public WriterThread(OutputStream out, int i) {
            this.out = new DataOutputStream(out);
            this.i = i;
            this.setName("TimedWriter.WriterThread");
        }

        public void run() {
            try {
                if (this.buf != null) {
                    this.out.write(this.buf);
                } else {
                    this.out.writeInt(this.i);
                }
            }
            catch (IOException e) {
                TimedWriter.this.write_ex = e;
            }
            TimedWriter.this.completed = true;
        }
    }

    class Timeout
    extends Exception {
        Timeout() {
        }

        public String toString() {
            return "TimedWriter.Timeout";
        }
    }
}

