/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.rpc.namespace;

import org.apache.axis.Constants;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class QName {
    private String namespaceURI = "";
    private String localPart = "";

    public QName() {
    }

    public QName(String localPart) {
        this.setNamespaceURI("");
        this.setLocalPart(localPart);
    }

    public QName(String namespaceURI, String localPart) {
        this.setNamespaceURI(namespaceURI);
        this.setLocalPart(localPart);
    }

    public void setNamespaceURI(String namespaceURI) {
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        this.namespaceURI = namespaceURI;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void setLocalPart(String localPart) {
        if (localPart == null) {
            localPart = "";
        }
        this.localPart = localPart;
    }

    public String getLocalPart() {
        return this.localPart;
    }

    public String toString() {
        if (this.namespaceURI.equals("")) {
            return this.localPart;
        }
        return String.valueOf(this.namespaceURI) + ":" + this.localPart;
    }

    public boolean equals(Object p1) {
        if (p1 == this) {
            return true;
        }
        if (!(p1 instanceof QName)) {
            return false;
        }
        return this.namespaceURI.equals(((QName)p1).namespaceURI) && this.localPart.equals(((QName)p1).localPart);
    }

    public int hashCode() {
        return this.namespaceURI.hashCode() ^ this.localPart.hashCode();
    }

    public QName(String qName, Element element) {
        if (qName != null) {
            int i = qName.indexOf(":");
            if (i < 0) {
                this.setLocalPart(qName);
                while (element != null) {
                    Attr attr = element.getAttributeNodeNS(Constants.NS_URI_XMLNS, "xmlns");
                    if (attr != null) {
                        this.setNamespaceURI(attr.getValue());
                        return;
                    }
                    Node n = element.getParentNode();
                    if (!(n instanceof Element)) break;
                    element = (Element)n;
                }
                this.setNamespaceURI("");
            } else {
                String prefix = qName.substring(0, i);
                String local = qName.substring(i + 1);
                this.setLocalPart(local);
                this.setNamespaceURI(XMLUtils.getNamespace(prefix, element));
            }
        }
    }
}

