/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.soap;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.xml.soap.SOAPException;

class FactoryFinder {
    FactoryFinder() {
    }

    private static Object newInstance(String s, ClassLoader classloader) throws SOAPException {
        try {
            Class<?> class1 = classloader == null ? Class.forName(s) : classloader.loadClass(s);
            return class1.newInstance();
        }
        catch (ClassNotFoundException classnotfoundexception) {
            throw new SOAPException("Provider " + s + " not found", classnotfoundexception);
        }
        catch (Exception exception) {
            throw new SOAPException("Provider " + s + " could not be instantiated: " + exception, exception);
        }
    }

    static Object find(String s, String s1) throws SOAPException {
        ClassLoader classloader;
        try {
            classloader = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception exception) {
            throw new SOAPException(exception.toString(), exception);
        }
        try {
            String s2 = System.getProperty(s);
            if (s2 != null) {
                return FactoryFinder.newInstance(s2, classloader);
            }
        }
        catch (SecurityException s2) {
            // empty catch block
        }
        try {
            String s3 = System.getProperty("java.home");
            String s5 = String.valueOf(s3) + File.separator + "lib" + File.separator + "jaxm.properties";
            File file = new File(s5);
            if (file.exists()) {
                Properties properties = new Properties();
                properties.load(new FileInputStream(file));
                String s7 = properties.getProperty(s);
                return FactoryFinder.newInstance(s7, classloader);
            }
        }
        catch (Exception s3) {
            // empty catch block
        }
        String s4 = "META-INF/services/" + s;
        try {
            InputStream inputstream = null;
            inputstream = classloader == null ? ClassLoader.getSystemResourceAsStream(s4) : classloader.getResourceAsStream(s4);
            if (inputstream != null) {
                BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(inputstream, "UTF-8"));
                String s6 = bufferedreader.readLine();
                bufferedreader.close();
                if (s6 != null && !"".equals(s6)) {
                    return FactoryFinder.newInstance(s6, classloader);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (s1 == null) {
            throw new SOAPException("Provider for " + s + " cannot be found", null);
        }
        return FactoryFinder.newInstance(s1, classloader);
    }
}

