/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.ConfigurationException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.InternalException;
import org.apache.axis.MessageContext;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.session.Session;
import org.apache.axis.session.SimpleSession;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.cache.ClassCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AxisEngine
extends BasicHandler {
    protected static Log log;
    public static final String PROP_XML_DECL = "sendXMLDeclaration";
    public static final String PROP_DEBUG_LEVEL = "debugLevel";
    public static final String PROP_DEBUG_FILE = "debugFile";
    public static final String PROP_DOMULTIREFS = "sendMultiRefs";
    public static final String PROP_PASSWORD = "adminPassword";
    public static final String PROP_SYNC_CONFIG = "syncConfiguration";
    public static final String PROP_SEND_XSI = "sendXsiTypes";
    public static final String PROP_ATTACHMENT_DIR = "attachments.Directory";
    public static final String PROP_ATTACHMENT_IMPLEMENTATION = "attachments.implementation";
    public static final String PROP_ATTACHMENT_CLEANUP = "attachment.DirectoryCleanUp";
    public static final String DEFAULT_ATTACHMENT_IMPL = "org.apache.axis.attachments.AttachmentsImpl";
    private static final String DEFAULT_ADMIN_PASSWORD = "admin";
    protected EngineConfiguration config;
    protected boolean _hasSafePassword = false;
    protected boolean shouldSaveConfig = false;
    protected ClassCache classCache = new ClassCache();
    private Session session = new SimpleSession();
    private ArrayList actorURIs = new ArrayList();
    private static ThreadLocal currentMessageContext;
    private static final String[] BOOLEAN_OPTIONS;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.AxisEngine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        currentMessageContext = new ThreadLocal();
        BOOLEAN_OPTIONS = new String[]{PROP_DOMULTIREFS, PROP_SEND_XSI, PROP_XML_DECL};
    }

    protected static void setCurrentMessageContext(MessageContext mc) {
        currentMessageContext.set(mc);
    }

    public static MessageContext getCurrentMessageContext() {
        return (MessageContext)currentMessageContext.get();
    }

    private AxisEngine() {
    }

    public AxisEngine(EngineConfiguration config) {
        this.config = config;
        this.init();
    }

    public void init() {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("enter00", "AxisEngine::init"));
        }
        try {
            this.config.configureEngine(this);
        }
        catch (Exception e) {
            throw new InternalException(e);
        }
        String attachmentsImp = null;
        try {
            attachmentsImp = System.getProperty("axis.attachments.implementation");
            if (attachmentsImp != null) {
                this.setOption(PROP_ATTACHMENT_IMPLEMENTATION, attachmentsImp);
            }
        }
        catch (Throwable t) {
            attachmentsImp = null;
        }
        if (attachmentsImp == null && (attachmentsImp = (String)this.getOption(PROP_ATTACHMENT_IMPLEMENTATION)) == null) {
            this.setOption(PROP_ATTACHMENT_IMPLEMENTATION, DEFAULT_ATTACHMENT_IMPL);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("exit00", "AxisEngine::init"));
        }
    }

    public void saveConfiguration() {
        if (!this.shouldSaveConfig) {
            return;
        }
        try {
            this.config.writeEngineConfig(this);
        }
        catch (Exception e) {
            log.error((Object)JavaUtils.getMessage("saveConfigFail00"), (Throwable)e);
        }
    }

    public EngineConfiguration getConfig() {
        return this.config;
    }

    public boolean hasSafePassword() {
        return this._hasSafePassword;
    }

    public void setAdminPassword(String pw) {
        this.setOption(PROP_PASSWORD, pw);
        this._hasSafePassword = true;
        this.saveConfiguration();
    }

    public void setShouldSaveConfig(boolean shouldSaveConfig) {
        this.shouldSaveConfig = shouldSaveConfig;
    }

    public Handler getHandler(String name) throws AxisFault {
        try {
            return this.config.getHandler(new QName(null, name));
        }
        catch (ConfigurationException e) {
            throw new AxisFault(e);
        }
    }

    public SOAPService getService(String name) throws AxisFault {
        try {
            return this.config.getService(new QName(null, name));
        }
        catch (ConfigurationException e) {
            throw new AxisFault(e);
        }
    }

    public Handler getTransport(String name) throws AxisFault {
        try {
            return this.config.getTransport(new QName(null, name));
        }
        catch (ConfigurationException e) {
            throw new AxisFault(e);
        }
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        TypeMappingRegistry tmr = null;
        try {
            tmr = this.config.getTypeMappingRegistry();
        }
        catch (ConfigurationException e) {
            log.error((Object)JavaUtils.getMessage("axisConfigurationException00"), (Throwable)e);
        }
        return tmr;
    }

    public Handler getGlobalRequest() throws ConfigurationException {
        return this.config.getGlobalRequest();
    }

    public Handler getGlobalResponse() throws ConfigurationException {
        return this.config.getGlobalResponse();
    }

    public ArrayList getActorURIs() {
        return this.actorURIs;
    }

    public void addActorURI(String uri) {
        this.actorURIs.add(uri);
    }

    public void removeActorURI(String uri) {
        ((AbstractCollection)this.actorURIs).remove(uri);
    }

    public abstract AxisEngine getClientEngine();

    /*
     * Exception decompiling
     */
    private void normaliseOptions() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void refreshGlobalOptions() throws ConfigurationException {
        Hashtable globalOptions = this.config.getGlobalOptions();
        if (globalOptions != null) {
            this.setOptions(globalOptions);
        }
        this.normaliseOptions();
    }

    public Session getApplicationSession() {
        return this.session;
    }

    public ClassCache getClassCache() {
        return this.classCache;
    }
}

