/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.SOAPPart;
import org.apache.axis.attachments.Attachments;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.utils.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Message {
    protected static Log log;
    public static final String REQUEST = "request";
    public static final String RESPONSE = "response";
    public static final String MIME_MULTIPART_RELATED = "multipart/related";
    public static final String MIME_APPLICATION_DIME = "application/dime";
    public static final String DEFAULT_ATTACHMNET_IMPL = "org.apache.axis.attachments.AttachmentsImpl";
    private static String mAttachmentsImplClassName;
    public static final String MIME_UNKNOWN = "  ";
    private String messageType;
    private SOAPPart mSOAPPart;
    private Attachments mAttachments = null;
    private MessageContext msgContext;
    private static Class attachImpl;
    private static boolean checkForAttchmentSupport;
    private static boolean attachmentSupportEnabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.Message");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        mAttachmentsImplClassName = DEFAULT_ATTACHMNET_IMPL;
        attachImpl = null;
        checkForAttchmentSupport = true;
        attachmentSupportEnabled = false;
    }

    public static String getAttachmentImplClassName() {
        return mAttachmentsImplClassName;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public MessageContext getMessageContext() {
        return this.msgContext;
    }

    public void setMessageContext(MessageContext msgContext) {
        this.msgContext = msgContext;
    }

    public Message(Object initialContents, boolean bodyInStream) {
        this(initialContents, bodyInStream, null, null);
    }

    public Message(Object initialContents, boolean bodyInStream, String contentType, String contentLocation) {
        this.setup(initialContents, bodyInStream, contentType, contentLocation);
    }

    public Message(Object initialContents) {
        this.setup(initialContents, false, null, null);
    }

    public boolean isAttachmentSupportEnabled() {
        if (checkForAttchmentSupport) {
            checkForAttchmentSupport = false;
            Class<?> mailapiclass = null;
            Class<?> dataHandlerclass = null;
            try {
                AxisEngine ae;
                String attachImpName = DEFAULT_ATTACHMNET_IMPL;
                MessageContext mc = this.getMessageContext();
                if (mc != null && (ae = mc.getAxisEngine()) != null) {
                    attachImpName = (String)ae.getOption("attachments.implementation");
                }
                if (attachImpName == null) {
                    attachImpName = DEFAULT_ATTACHMNET_IMPL;
                }
                dataHandlerclass = Class.forName("javax.activation.DataHandler");
                mailapiclass = Class.forName("javax.mail.internet.MimeMultipart");
                attachImpl = Class.forName(attachImpName);
                attachmentSupportEnabled = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        log.debug((Object)(String.valueOf(JavaUtils.getMessage("attachEnabled")) + MIME_UNKNOWN + attachmentSupportEnabled));
        return attachmentSupportEnabled;
    }

    private void setup(Object initialContents, boolean bodyInStream, String contentType, String contentLocation) {
        if (this.isAttachmentSupportEnabled()) {
            Constructor<?> attachImplConstr = attachImpl.getConstructors()[0];
            try {
                this.mAttachments = (Attachments)attachImplConstr.newInstance(initialContents, contentType, contentLocation);
                this.mSOAPPart = (SOAPPart)this.mAttachments.getRootPart();
            }
            catch (InvocationTargetException ex) {
                log.fatal((Object)JavaUtils.getMessage("invocationTargetException00"), (Throwable)ex);
                throw new RuntimeException(ex.getMessage());
            }
            catch (InstantiationException ex) {
                log.fatal((Object)JavaUtils.getMessage("instantiationException00"), (Throwable)ex);
                throw new RuntimeException(ex.getMessage());
            }
            catch (IllegalAccessException ex) {
                log.fatal((Object)JavaUtils.getMessage("illegalAccessException00"), (Throwable)ex);
                throw new RuntimeException(ex.getMessage());
            }
        }
        if (this.mSOAPPart == null) {
            this.mSOAPPart = new SOAPPart(this, initialContents, bodyInStream);
        } else {
            this.mSOAPPart.setMessage(this);
        }
        if (this.mAttachments != null) {
            this.mAttachments.setRootPart(this.mSOAPPart);
        }
    }

    public SOAPPart getSOAPPart() {
        return this.mSOAPPart;
    }

    public SOAPEnvelope getSOAPEnvelope() throws AxisFault {
        return this.mSOAPPart.getAsSOAPEnvelope();
    }

    public Attachments getAttachments() {
        return this.mAttachments;
    }

    public String getContentType() throws AxisFault {
        this.mSOAPPart.getAsBytes();
        String ret = "text/xml; charset=utf-8";
        if (this.mAttachments != null && this.mAttachments.getAttachmentCount() != 0) {
            ret = this.mAttachments.getContentType();
        }
        return ret;
    }

    public int getContentLength() throws AxisFault {
        int ret = this.mSOAPPart.getAsBytes().length;
        if (this.mAttachments != null && this.mAttachments.getAttachmentCount() > 0) {
            ret = this.mAttachments.getContentLength();
        }
        return ret;
    }

    public void writeContentToStream(OutputStream os) {
        if (this.mAttachments == null || this.mAttachments.getAttachmentCount() == 0) {
            try {
                os.write(this.mSOAPPart.getAsBytes());
            }
            catch (IOException e) {
                log.error((Object)JavaUtils.getMessage("javaIOException00"), (Throwable)e);
            }
        } else {
            try {
                this.mAttachments.writeContentToStream(os);
            }
            catch (Exception e) {
                log.error((Object)JavaUtils.getMessage("exception00"), (Throwable)e);
            }
        }
    }
}

