/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis;

import java.io.File;
import java.util.Hashtable;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.ConfigurationException;
import org.apache.axis.Message;
import org.apache.axis.client.AxisClient;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.session.Session;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.LockableHashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageContext {
    protected static Log log;
    private Message requestMessage;
    private Message responseMessage;
    private String targetService;
    private String transportName;
    private ClassLoader classLoader;
    private AxisEngine axisEngine;
    private Session session;
    private boolean maintainSession = false;
    private boolean havePassedPivot = false;
    private int timeout = 0;
    private LockableHashtable bag;
    private String username = null;
    private String password = null;
    private int operationStyle = 0;
    private boolean useSOAPAction = false;
    private String SOAPActionURI = null;
    private String encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
    private boolean isEncoded = true;
    private OperationDesc currentOperation = null;
    protected static String systemTempDir;
    private TypeMappingRegistry mappingRegistry = null;
    private SOAPService serviceHandler;
    public static String ENGINE_HANDLER;
    public static String TRANS_URL;
    public static String QUIT_REQUESTED;
    public static String AUTHUSER;
    public static String CALL;
    public static String ATTACHMENTS_DIR;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.MessageContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        systemTempDir = null;
        try {
            systemTempDir = System.getProperty("axis.attachments.Directory");
        }
        catch (Throwable t) {
            systemTempDir = null;
        }
        if (systemTempDir == null) {
            try {
                File tf = File.createTempFile("Axis", "Axis");
                File dir = tf.getParentFile();
                if (tf.exists()) {
                    tf.delete();
                }
                if (dir != null) {
                    systemTempDir = dir.getCanonicalPath();
                }
            }
            catch (Throwable t) {
                systemTempDir = null;
            }
        }
        ENGINE_HANDLER = "engine.handler";
        TRANS_URL = "transport.url";
        QUIT_REQUESTED = "quit.requested";
        AUTHUSER = "authenticatedUser";
        CALL = "call_object";
        ATTACHMENTS_DIR = "attachments.directory";
    }

    public OperationDesc getOperation() {
        return this.currentOperation;
    }

    public void setOperation(OperationDesc operation) {
        this.currentOperation = operation;
    }

    public OperationDesc getOperationByQName(QName qname) {
        ServiceDesc desc;
        if (this.currentOperation != null) {
            return this.currentOperation;
        }
        if (this.serviceHandler == null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)JavaUtils.getMessage("dispatching00", qname.getNamespaceURI()));
                }
                this.setService(this.axisEngine.getConfig().getServiceByNamespaceURI(qname.getNamespaceURI()));
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
            if (this.serviceHandler == null) {
                return null;
            }
        }
        if ((desc = this.serviceHandler.getServiceDescription()) != null) {
            this.currentOperation = desc.getOperationByElementQName(qname);
            this.setOperationStyle(desc.getStyle());
        }
        return this.currentOperation;
    }

    public static MessageContext getCurrentContext() {
        return AxisEngine.getCurrentMessageContext();
    }

    public MessageContext(AxisEngine engine) {
        this.axisEngine = engine;
        if (engine != null) {
            Hashtable opts = engine.getOptions();
            String attachmentsdir = null;
            if (opts != null) {
                attachmentsdir = (String)opts.get("attachments.Directory");
            }
            if (attachmentsdir == null) {
                attachmentsdir = systemTempDir;
            }
            if (attachmentsdir != null) {
                this.setProperty(ATTACHMENTS_DIR, attachmentsdir);
            }
        }
    }

    public void setTypeMappingRegistry(TypeMappingRegistry reg) {
        this.mappingRegistry = reg;
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        if (this.mappingRegistry == null) {
            return this.axisEngine.getTypeMappingRegistry();
        }
        return this.mappingRegistry;
    }

    public String getTransportName() {
        return this.transportName;
    }

    public void setTransportName(String transportName) {
        this.transportName = transportName;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public boolean isEncoded() {
        return "http://schemas.xmlsoap.org/soap/encoding/".equals(this.encodingStyle);
    }

    public void setMaintainSession(boolean yesno) {
        this.maintainSession = yesno;
    }

    public boolean getMaintainSession() {
        return this.maintainSession;
    }

    public Message getRequestMessage() {
        return this.requestMessage;
    }

    public void setRequestMessage(Message reqMsg) {
        this.requestMessage = reqMsg;
        if (this.requestMessage != null) {
            this.requestMessage.setMessageContext(this);
        }
    }

    public Message getResponseMessage() {
        return this.responseMessage;
    }

    public void setResponseMessage(Message respMsg) {
        this.responseMessage = respMsg;
        if (this.responseMessage != null) {
            this.responseMessage.setMessageContext(this);
        }
    }

    public Message getCurrentMessage() {
        return this.havePassedPivot ? this.responseMessage : this.requestMessage;
    }

    public void setCurrentMessage(Message curMsg) {
        curMsg.setMessageContext(this);
        if (this.havePassedPivot) {
            this.responseMessage = curMsg;
        } else {
            this.requestMessage = curMsg;
        }
    }

    public boolean getPastPivot() {
        return this.havePassedPivot;
    }

    public void setPastPivot(boolean pastPivot) {
        this.havePassedPivot = pastPivot;
    }

    public void setTimeout(int value) {
        this.timeout = value;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = Thread.currentThread().getContextClassLoader();
        }
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader cl) {
        this.classLoader = cl;
    }

    public String getTargetService() {
        return this.targetService;
    }

    public AxisEngine getAxisEngine() {
        return this.axisEngine;
    }

    public void setTargetService(String tServ) throws AxisFault {
        block4: {
            log.debug((Object)("MessageContext: setTargetService(" + tServ + ")"));
            if (tServ == null) {
                this.setService(null);
            } else {
                try {
                    this.setService(this.getAxisEngine().getService(tServ));
                }
                catch (AxisFault fault) {
                    if (this.isClient()) break block4;
                    throw fault;
                }
            }
        }
        this.targetService = tServ;
    }

    public SOAPService getService() {
        return this.serviceHandler;
    }

    public void setService(SOAPService sh) {
        log.debug((Object)("MessageContext: setServiceHandler(" + sh + ")"));
        this.serviceHandler = sh;
        if (sh != null) {
            this.targetService = sh.getName();
            SOAPService service = sh;
            TypeMappingRegistry tmr = service.getTypeMappingRegistry();
            this.setTypeMappingRegistry(tmr);
            this.setOperationStyle(service.getStyle());
            this.setEncodingStyle(service.getStyle() == 0 ? "http://schemas.xmlsoap.org/soap/encoding/" : "");
        }
    }

    public boolean isClient() {
        return this.axisEngine instanceof AxisClient;
    }

    public String getStrProp(String propName) {
        return (String)this.getProperty(propName);
    }

    public boolean isPropertyTrue(String propName) {
        Object val = this.getProperty(propName);
        if (val == null) {
            return false;
        }
        if (val instanceof Boolean) {
            Boolean b = (Boolean)val;
            return b;
        }
        if (val instanceof Integer) {
            Integer i = (Integer)val;
            return i != 0;
        }
        if (val instanceof String) {
            String s = (String)val;
            return !s.equalsIgnoreCase("false") && !s.equalsIgnoreCase("no");
        }
        return true;
    }

    public boolean isPropertyTrue(String propName, boolean defaultVal) {
        Object val = this.getProperty(propName);
        if (val == null) {
            return defaultVal;
        }
        if (val instanceof Boolean) {
            Boolean b = (Boolean)val;
            return b;
        }
        if (val instanceof Integer) {
            Integer i = (Integer)val;
            return i != 0;
        }
        if (val instanceof String) {
            String s = (String)val;
            return !s.equalsIgnoreCase("false") && !s.equalsIgnoreCase("no");
        }
        return true;
    }

    public void setProperty(String name, Object value) {
        if (name == null || value == null) {
            return;
        }
        if (name.equals("javax.xml.rpc.security.auth.username")) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException(JavaUtils.getMessage("badProp00", new String[]{name, "java.lang.String", value.getClass().getName()}));
            }
            this.setUsername((String)value);
        } else if (name.equals("javax.xml.rpc.security.auth.password")) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException(JavaUtils.getMessage("badProp00", new String[]{name, "java.lang.String", value.getClass().getName()}));
            }
            this.setPassword((String)value);
        } else if (name.equals("javax.xml.rpc.http.session.maintain")) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException(JavaUtils.getMessage("badProp00", new String[]{name, "java.lang.Boolean", value.getClass().getName()}));
            }
            this.setMaintainSession((Boolean)value);
        } else if (name.equals("javax.xml.rpc.soap.operation.style")) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException(JavaUtils.getMessage("badProp00", new String[]{name, "java.lang.String", value.getClass().getName()}));
            }
            this.setOperationStyle(MessageContext.getStyleFromString((String)value));
        } else if (name.equals("javax.xml.rpc.soap.http.soapaction.use")) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException(JavaUtils.getMessage("badProp00", new String[]{name, "java.lang.Boolean", value.getClass().getName()}));
            }
            this.setUseSOAPAction((Boolean)value);
        } else if (name.equals("javax.xml.rpc.soap.http.soapaction.uri")) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException(JavaUtils.getMessage("badProp00", new String[]{name, "java.lang.String", value.getClass().getName()}));
            }
            this.setSOAPActionURI((String)value);
        } else if (name.equals("javax.xml.rpc.encodingstyle.namespace.uri")) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException(JavaUtils.getMessage("badProp00", new String[]{name, "java.lang.String", value.getClass().getName()}));
            }
            this.setEncodingStyle((String)value);
        } else {
            if (this.bag == null) {
                this.bag = new LockableHashtable();
            }
            this.bag.put(name, value);
        }
    }

    public Object getProperty(String name) {
        if (name != null) {
            if (name.equals("javax.xml.rpc.security.auth.username")) {
                return this.getUsername();
            }
            if (name.equals("javax.xml.rpc.security.auth.password")) {
                return this.getPassword();
            }
            if (name.equals("javax.xml.rpc.http.session.maintain")) {
                return new Boolean(this.getMaintainSession());
            }
            if (name.equals("javax.xml.rpc.soap.operation.style")) {
                return MessageContext.getStyleFromInt(this.getOperationStyle());
            }
            if (name.equals("javax.xml.rpc.soap.http.soapaction.use")) {
                return new Boolean(this.useSOAPAction());
            }
            if (name.equals("javax.xml.rpc.soap.http.soapaction.uri")) {
                return this.getSOAPActionURI();
            }
            if (name.equals("javax.xml.rpc.encodingstyle.namespace.uri")) {
                return this.getEncodingStyle();
            }
            if (this.bag == null) {
                return null;
            }
            return this.bag.get(name);
        }
        return null;
    }

    public void setPropertyParent(Hashtable parent) {
        this.bag.setParent(parent);
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setOperationStyle(int operationStyle) {
        this.operationStyle = operationStyle;
    }

    public int getOperationStyle() {
        return this.operationStyle;
    }

    public void setUseSOAPAction(boolean useSOAPAction) {
        this.useSOAPAction = useSOAPAction;
    }

    public boolean useSOAPAction() {
        return this.useSOAPAction;
    }

    public void setSOAPActionURI(String SOAPActionURI) throws IllegalArgumentException {
        this.SOAPActionURI = SOAPActionURI;
    }

    public String getSOAPActionURI() {
        return this.SOAPActionURI;
    }

    public void setEncodingStyle(String namespaceURI) {
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        this.encodingStyle = namespaceURI;
    }

    public String getEncodingStyle() {
        return this.encodingStyle;
    }

    public void clearProperty(String propName) {
        if (this.bag != null) {
            this.bag.remove(propName);
        }
    }

    public void reset() {
        if (this.bag != null) {
            this.bag.clear();
        }
        this.serviceHandler = null;
        this.havePassedPivot = false;
        this.currentOperation = null;
    }

    public static int getStyleFromString(String operationStyle) {
        if ("rpc".equalsIgnoreCase(operationStyle)) {
            return 0;
        }
        if ("document".equalsIgnoreCase(operationStyle)) {
            return 1;
        }
        if ("wrapped".equalsIgnoreCase(operationStyle)) {
            return 2;
        }
        log.error((Object)JavaUtils.getMessage("badStyle", operationStyle));
        return 0;
    }

    public static String getStyleFromInt(int style) {
        switch (style) {
            case 0: {
                return "rpc";
            }
            case 1: {
                return "document";
            }
            case 2: {
                return "wrapped";
            }
        }
        return null;
    }
}

