/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.axis.utils.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Part {
    protected static Log log;
    private Hashtable headers = new Hashtable();
    private String contentId;
    private String contentLocation;
    static String thisHost;
    private static int count;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.Part");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        thisHost = null;
        count = (int)(Math.random() * 100.0);
    }

    public Part() {
        this.addMimeHeader("Content-ID", Part.getNewContentIdValue());
    }

    public void addMimeHeader(String header, String value) {
        if (header == null) {
            throw new IllegalArgumentException(JavaUtils.getMessage("headerNotNull"));
        }
        if ((header = header.trim()).length() == 0) {
            throw new IllegalArgumentException(JavaUtils.getMessage("headerNotEmpty"));
        }
        if (value == null) {
            throw new IllegalArgumentException(JavaUtils.getMessage("headerValueNotNull"));
        }
        this.headers.put(header.toLowerCase(), value);
    }

    public String getMimeHeader(String header) {
        return (String)this.headers.get(header.toLowerCase());
    }

    public String getContentLocation() {
        return this.getMimeHeader("Content-Location");
    }

    public void setContentLocation(String loc) {
        this.addMimeHeader("Content-Location", loc);
    }

    public void setContentId(String newCid) {
        if (!newCid.toLowerCase().startsWith("cid:")) {
            newCid = "cid:" + newCid;
        }
        this.addMimeHeader("Content-ID", newCid);
    }

    public String getContentId() {
        String ret = this.getMimeHeader("Content-ID");
        if (ret == null) {
            ret = Part.getNewContentIdValue();
            this.addMimeHeader("Content-ID", ret);
        }
        if ((ret = ret.trim()).length() == 0) {
            ret = Part.getNewContentIdValue();
            this.addMimeHeader("Content-ID", ret);
        }
        return ret;
    }

    public Iterator getMatchingMimeHeaders(String[] match) {
        LinkedList<String> retList = new LinkedList<String>();
        if (match != null && match.length != 0) {
            int i = match.length - 1;
            while (i > -1) {
                String key;
                if (match[i] != null && this.headers.containsKey(key = match[i].toLowerCase())) {
                    retList.add(match[i]);
                }
                --i;
            }
        }
        return retList.iterator();
    }

    public Iterator getNonMatchingMimeHeaders(String[] match) {
        LinkedList retList = new LinkedList(this.headers.keySet());
        if (match != null && match.length != 0 && !this.headers.isEmpty()) {
            int i = match.length - 1;
            while (i > -1) {
                String remItem;
                if (match[i] != null && this.headers.containsKey(remItem = match[i].toLowerCase())) {
                    retList.remove(remItem);
                }
                --i;
            }
        }
        return retList.iterator();
    }

    public abstract String getContentType();

    public static String getNewContentIdValue() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.Part");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            int lcount = ++count;
            // ** MonitorExit[var1] (shouldn't be in output)
            if (thisHost == null) {
                try {
                    thisHost = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException e) {
                    log.error((Object)JavaUtils.getMessage("javaNetUnknownHostException00"), (Throwable)e);
                    thisHost = "localhost";
                }
            }
            StringBuffer s = new StringBuffer();
            s.append("cid:").append(lcount).append(s.hashCode()).append('.').append(System.currentTimeMillis()).append(".AXIS@").append(thisHost);
            return s.toString();
        }
    }
}

