/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.Part;
import org.apache.axis.encoding.DeserializationContextImpl;
import org.apache.axis.encoding.SerializationContextImpl;
import org.apache.axis.message.InputStreamBody;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.utils.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SOAPPart
extends Part {
    protected static Log log;
    private static final int FORM_STRING = 1;
    private static final int FORM_INPUTSTREAM = 2;
    private static final int FORM_SOAPENVELOPE = 3;
    private static final int FORM_BYTES = 4;
    private static final int FORM_BODYINSTREAM = 5;
    private static final int FORM_FAULT = 6;
    private int currentForm;
    private static final String[] formNames;
    private Object currentMessage;
    private Message msgObject;
    private Object originalMessage;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.SOAPPart");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        formNames = new String[]{"", "FORM_STRING", "FORM_INPUTSTREAM", "FORM_SOAPENVELOPE", "FORM_BYTES", "FORM_BODYINSTREAM", "FORM_FAULT"};
    }

    public SOAPPart(Message parent, Object initialContents, boolean isBodyStream) {
        this.msgObject = parent;
        this.originalMessage = initialContents;
        int form = 1;
        if (initialContents instanceof SOAPEnvelope) {
            form = 3;
        } else if (initialContents instanceof InputStream) {
            form = isBodyStream ? 5 : 2;
        } else if (initialContents instanceof byte[]) {
            form = 4;
        } else if (initialContents instanceof AxisFault) {
            form = 6;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("enter00", "SOAPPart ctor(" + formNames[form] + ")"));
        }
        this.setCurrentMessage(initialContents, form);
    }

    public Message getMessage() {
        return this.msgObject;
    }

    public void setMessage(Message msg) {
        this.msgObject = msg;
    }

    public String getContentType() {
        return "text/xml";
    }

    public int getContentLength() {
        try {
            byte[] bytes = this.getAsBytes();
            return bytes.length;
        }
        catch (AxisFault fault) {
            return 0;
        }
    }

    public void setSOAPEnvelope(SOAPEnvelope env) {
        this.setCurrentMessage(env, 3);
    }

    public int getSize() {
        return this.getContentLength();
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.getAsBytes());
    }

    public Object getCurrentMessage() {
        return this.currentMessage;
    }

    private void setCurrentMessage(Object currMsg, int form) {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("setMsgForm", formNames[form], "" + currMsg));
        }
        this.currentMessage = currMsg;
        this.currentForm = form;
    }

    public byte[] getAsBytes() throws AxisFault {
        log.debug((Object)JavaUtils.getMessage("enter00", "SOAPPart::getAsBytes"));
        if (this.currentForm == 4) {
            log.debug((Object)JavaUtils.getMessage("exit00", "SOAPPart::getAsBytes"));
            return (byte[])this.currentMessage;
        }
        if (this.currentForm == 5) {
            try {
                this.getAsSOAPEnvelope();
            }
            catch (Exception e) {
                log.fatal((Object)JavaUtils.getMessage("makeEnvFail00"), (Throwable)e);
                return null;
            }
        }
        if (this.currentForm == 2) {
            try {
                int len;
                InputStream inp = (InputStream)this.currentMessage;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buf = new byte[4096];
                while ((len = inp.read(buf, 0, 4096)) != -1) {
                    baos.write(buf, 0, len);
                }
                buf = baos.toByteArray();
                this.setCurrentMessage(buf, 4);
                log.debug((Object)JavaUtils.getMessage("exit00", "SOAPPart::getAsBytes"));
                return (byte[])this.currentMessage;
            }
            catch (Exception e) {
                log.error((Object)JavaUtils.getMessage("exception00"), (Throwable)e);
                log.debug((Object)JavaUtils.getMessage("exit00", "SOAPPart::getAsBytes"));
                return null;
            }
        }
        if (this.currentForm == 3 || this.currentForm == 6) {
            try {
                return this.getAsString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ue) {
                return this.getAsString().getBytes();
            }
        }
        if (this.currentForm == 1) {
            try {
                this.setCurrentMessage(((String)this.currentMessage).getBytes("UTF-8"), 4);
            }
            catch (UnsupportedEncodingException ue) {
                this.setCurrentMessage(((String)this.currentMessage).getBytes(), 4);
            }
            log.debug((Object)JavaUtils.getMessage("exit00", "SOAPPart::getAsBytes"));
            return (byte[])this.currentMessage;
        }
        log.error((Object)JavaUtils.getMessage("cantConvert00", "" + this.currentForm));
        log.debug((Object)JavaUtils.getMessage("exit00", "SOAPPart::getAsBytes"));
        return null;
    }

    public String getAsString() throws AxisFault {
        log.debug((Object)JavaUtils.getMessage("enter00", "SOAPPart::getAsString"));
        if (this.currentForm == 1) {
            log.debug((Object)JavaUtils.getMessage("exitCurrMsg", "SOAPPart::getAsString", "" + this.currentMessage));
            return (String)this.currentMessage;
        }
        if (this.currentForm == 2 || this.currentForm == 5) {
            this.getAsBytes();
        }
        if (this.currentForm == 4) {
            try {
                this.setCurrentMessage(new String((byte[])this.currentMessage, "UTF-8"), 1);
            }
            catch (UnsupportedEncodingException ue) {
                this.setCurrentMessage(new String((byte[])this.currentMessage), 1);
            }
            log.debug((Object)JavaUtils.getMessage("exitCurrMsg", "SOAPPart::getAsString", "" + this.currentMessage));
            return (String)this.currentMessage;
        }
        if (this.currentForm == 6) {
            StringWriter writer = new StringWriter();
            AxisFault env = (AxisFault)this.currentMessage;
            try {
                env.output(new SerializationContextImpl(writer, this.getMessage().getMessageContext()));
            }
            catch (Exception e) {
                log.error((Object)JavaUtils.getMessage("exception00"), (Throwable)e);
                return null;
            }
            this.setCurrentMessage(writer.getBuffer().toString(), 1);
            return (String)this.currentMessage;
        }
        if (this.currentForm == 3) {
            StringWriter writer = new StringWriter();
            SOAPEnvelope env = (SOAPEnvelope)this.currentMessage;
            try {
                env.output(new SerializationContextImpl(writer, this.getMessage().getMessageContext()));
            }
            catch (Exception e) {
                throw AxisFault.makeFault(e);
            }
            this.setCurrentMessage(writer.getBuffer().toString(), 1);
            return (String)this.currentMessage;
        }
        log.error((Object)JavaUtils.getMessage("cantConvert01", "" + this.currentForm));
        log.debug((Object)JavaUtils.getMessage("exit00", "SOAPPart::getAsString"));
        return null;
    }

    public SOAPEnvelope getAsSOAPEnvelope() throws AxisFault {
        log.debug((Object)(String.valueOf(JavaUtils.getMessage("enter00", "SOAPPart::getAsSOAPEnvelope")) + JavaUtils.getMessage("currForm", formNames[this.currentForm])));
        if (this.currentForm == 3) {
            return (SOAPEnvelope)this.currentMessage;
        }
        if (this.currentForm == 5) {
            InputStreamBody bodyEl = new InputStreamBody((InputStream)this.currentMessage);
            SOAPEnvelope env = new SOAPEnvelope();
            env.addBodyElement(bodyEl);
            this.setCurrentMessage(env, 3);
            return env;
        }
        InputSource is = this.currentForm == 2 ? new InputSource((InputStream)this.currentMessage) : new InputSource(new StringReader(this.getAsString()));
        DeserializationContextImpl dser = new DeserializationContextImpl(is, this.getMessage().getMessageContext(), this.getMessage().getMessageType());
        try {
            dser.parse();
        }
        catch (SAXException e) {
            Exception real = e.getException();
            if (real == null) {
                real = e;
            }
            throw AxisFault.makeFault(real);
        }
        this.setCurrentMessage(dser.getEnvelope(), 3);
        log.debug((Object)JavaUtils.getMessage("exit00", "SOAPPart::getAsSOAPEnvelope"));
        return (SOAPEnvelope)this.currentMessage;
    }
}

