/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.attachments;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Multipart;
import javax.mail.internet.MimeMultipart;
import org.apache.axis.AxisFault;
import org.apache.axis.Part;
import org.apache.axis.SOAPPart;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.attachments.AttachmentUtils;
import org.apache.axis.attachments.Attachments;
import org.apache.axis.attachments.ManagedMemoryDataSource;
import org.apache.axis.attachments.MimeUtils;
import org.apache.axis.attachments.MultiPartRelatedInputStream;
import org.apache.axis.utils.JavaUtils;

public class AttachmentsImpl
implements Attachments {
    private HashMap attachments = new HashMap();
    private LinkedList orderedAttachments = new LinkedList();
    protected SOAPPart soapPart = null;
    protected MultiPartRelatedInputStream mpartStream = null;
    protected String contentLocation = null;
    public MimeMultipart multipart = null;
    static /* synthetic */ Class class$0;

    public AttachmentsImpl(Object intialContents, String contentType, String contentLocation) throws AxisFault {
        StringTokenizer st;
        if (contentLocation != null && (contentLocation = contentLocation.trim()).length() == 0) {
            contentLocation = null;
        }
        this.contentLocation = contentLocation;
        if (contentType != null && !contentType.equals("  ") && (st = new StringTokenizer(contentType, " \t;")).hasMoreTokens()) {
            String mimetype = st.nextToken();
            if (mimetype.equalsIgnoreCase("multipart/related")) {
                this.mpartStream = new MultiPartRelatedInputStream(contentType, (InputStream)intialContents);
                if (contentLocation == null && (contentLocation = this.mpartStream.getContentLocation()) != null && (contentLocation = contentLocation.trim()).length() == 0) {
                    contentLocation = null;
                }
                this.soapPart = new SOAPPart(null, this.mpartStream, false);
            } else {
                mimetype.equalsIgnoreCase("application/dime");
            }
        }
    }

    private void mergeinAttachments() throws AxisFault {
        if (this.mpartStream != null) {
            Collection atts = this.mpartStream.getAttachments();
            this.mpartStream = null;
            this.setAttachmentParts(atts);
        }
    }

    public Part removeAttachmentPart(String reference) throws AxisFault {
        this.mergeinAttachments();
        Part removedPart = this.getAttachmentByReference(reference);
        if (removedPart != null) {
            this.attachments.remove(removedPart.getContentId());
            this.attachments.remove(removedPart.getContentLocation());
            this.orderedAttachments.remove(removedPart);
        }
        return removedPart;
    }

    public Part addAttachmentPart(Part newPart) throws AxisFault {
        this.mergeinAttachments();
        Part oldPart = this.attachments.put(newPart.getContentId(), newPart);
        if (oldPart != null) {
            this.orderedAttachments.remove(oldPart);
            this.attachments.remove(oldPart.getContentLocation());
        }
        this.orderedAttachments.add(newPart);
        if (newPart.getContentLocation() != null) {
            this.attachments.put(newPart.getContentLocation(), newPart);
        }
        return oldPart;
    }

    public Part createAttachmentPart(Object datahandler) throws AxisFault {
        this.mergeinAttachments();
        if (!(datahandler instanceof DataHandler)) {
            String string = datahandler.getClass().getName();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("javax.activation.DataHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new AxisFault(JavaUtils.getMessage("unsupportedAttach", string, clazz.getName()));
        }
        AttachmentPart ret = new AttachmentPart((DataHandler)datahandler);
        this.addAttachmentPart(ret);
        return ret;
    }

    public void setAttachmentParts(Collection parts) throws AxisFault {
        this.mergeinAttachments();
        this.attachments.clear();
        this.orderedAttachments.clear();
        if (parts != null && !parts.isEmpty()) {
            Iterator i = parts.iterator();
            while (i.hasNext()) {
                Part part = (Part)i.next();
                if (part == null) continue;
                this.addAttachmentPart(part);
            }
        }
    }

    public Part getAttachmentByReference(String reference) throws AxisFault {
        this.mergeinAttachments();
        if (reference == null) {
            return null;
        }
        if ((reference = reference.trim()).length() == 0) {
            return null;
        }
        Part ret = (Part)this.attachments.get(reference);
        if (ret != null) {
            return ret;
        }
        String referenceLC = reference.toLowerCase();
        if (!referenceLC.startsWith("cid:") && this.contentLocation != null) {
            String fqreference = this.contentLocation;
            if (!fqreference.endsWith("/")) {
                fqreference = String.valueOf(fqreference) + "/";
            }
            fqreference = reference.startsWith("/") ? String.valueOf(fqreference) + reference.substring(1) : String.valueOf(fqreference) + reference;
            ret = (AttachmentPart)this.attachments.get(fqreference);
        }
        return ret;
    }

    public Collection getAttachments() throws AxisFault {
        this.mergeinAttachments();
        return new LinkedList(this.orderedAttachments);
    }

    public Part getRootPart() {
        return this.soapPart;
    }

    public void setRootPart(Part newRoot) {
        try {
            this.soapPart = (SOAPPart)newRoot;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(JavaUtils.getMessage("onlySOAPParts"));
        }
    }

    public int getContentLength() throws AxisFault {
        this.mergeinAttachments();
        try {
            return (int)MimeUtils.getContentLength((Multipart)(this.multipart != null ? this.multipart : (this.multipart = MimeUtils.createMP(this.soapPart.getAsString(), this.orderedAttachments))));
        }
        catch (Exception e) {
            throw AxisFault.makeFault(e);
        }
    }

    public void writeContentToStream(OutputStream os) throws AxisFault {
        this.mergeinAttachments();
        MimeUtils.writeToMultiPartStream(os, this.multipart != null ? this.multipart : (this.multipart = MimeUtils.createMP(this.soapPart.getAsString(), this.orderedAttachments)));
        Iterator i = this.orderedAttachments.iterator();
        while (i.hasNext()) {
            AttachmentPart part = (AttachmentPart)i.next();
            DataHandler dh = AttachmentUtils.getActiviationDataHandler(part);
            DataSource ds = dh.getDataSource();
            if (ds == null || !(ds instanceof ManagedMemoryDataSource)) continue;
            ((ManagedMemoryDataSource)ds).delete();
        }
    }

    public String getContentType() throws AxisFault {
        this.mergeinAttachments();
        return MimeUtils.getContentType(this.multipart != null ? this.multipart : (this.multipart = MimeUtils.createMP(this.soapPart.getAsString(), this.orderedAttachments)));
    }

    public int getAttachmentCount() {
        try {
            this.mergeinAttachments();
            return this.orderedAttachments.size();
        }
        catch (AxisFault axisFault) {
            return 0;
        }
    }

    public boolean isAttachment(Object value) {
        return AttachmentUtils.isAttachment(value);
    }
}

