/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.attachments;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.axis.AxisFault;
import org.apache.axis.utils.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BoundaryDelimitedStream
extends FilterInputStream {
    protected static Log log;
    protected byte[] boundary = null;
    int boundaryLen = 0;
    int boundaryBufLen = 0;
    InputStream is = null;
    boolean closed = true;
    boolean eos = false;
    boolean theEnd = false;
    int readbufsz = 0;
    byte[] readbuf = null;
    int readBufPos = 0;
    int readBufEnd = 0;
    protected static final int BOUNDARY_NOT_FOUND = Integer.MAX_VALUE;
    int boundaryPos = Integer.MAX_VALUE;
    static int streamCount;
    protected int streamNo = -1;
    static boolean isDebugEnabled;
    private int[] skip = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.attachments.BoundaryDelimitedStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        streamCount = 0;
        isDebugEnabled = false;
    }

    protected static synchronized int newStreamNo() {
        log.debug((Object)JavaUtils.getMessage("streamNo", "" + (streamCount + 1)));
        return ++streamCount;
    }

    public synchronized BoundaryDelimitedStream getNextStream() {
        return this.getNextStream(this.readbufsz);
    }

    protected synchronized BoundaryDelimitedStream getNextStream(int readbufsz) {
        BoundaryDelimitedStream ret = null;
        if (!this.theEnd) {
            ret = new BoundaryDelimitedStream(this, readbufsz);
        }
        return ret;
    }

    protected BoundaryDelimitedStream(BoundaryDelimitedStream prev, int readbufsz) {
        super(prev.is);
        this.streamNo = BoundaryDelimitedStream.newStreamNo();
        this.boundary = prev.boundary;
        this.boundaryLen = prev.boundaryLen;
        this.boundaryBufLen = prev.boundaryBufLen;
        this.skip = prev.skip;
        this.is = prev.is;
        this.closed = false;
        this.eos = false;
        readbufsz = prev.readbufsz;
        this.readbuf = prev.readbuf;
        this.readBufPos = prev.readBufPos + this.boundaryBufLen;
        this.readBufEnd = prev.readBufEnd;
        this.boundaryPos = this.boundaryPosition(this.readbuf, this.readBufPos, this.readBufEnd - 1);
        prev.theEnd = this.theEnd;
    }

    BoundaryDelimitedStream(InputStream is, byte[] boundary, int readbufsz) throws AxisFault {
        super(is);
        isDebugEnabled = log.isDebugEnabled();
        this.streamNo = BoundaryDelimitedStream.newStreamNo();
        this.closed = false;
        this.is = is;
        this.boundary = boundary;
        this.boundaryLen = boundary.length;
        this.boundaryBufLen = this.boundaryLen + 2;
        this.readbufsz = Math.max(this.boundaryBufLen * 2, readbufsz);
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException(JavaUtils.getMessage("streamClosed"));
        }
        if (this.eos) {
            return -1;
        }
        if (this.readbuf == null) {
            this.readbuf = new byte[Math.max(len, this.readbufsz)];
            this.readBufEnd = this.is.read(this.readbuf);
            if (this.readBufEnd < 0) {
                throw new IOException(JavaUtils.getMessage("eosBeforeMarker"));
            }
            this.readBufPos = 0;
            this.boundaryPos = this.boundaryPosition(this.readbuf, 0, this.readBufEnd);
        }
        int bwritten = 0;
        do {
            int bcopy = Math.min(this.readBufEnd - this.readBufPos - this.boundaryBufLen, len - bwritten);
            if ((bcopy = Math.min(bcopy, this.boundaryPos - this.readBufPos)) > 0) {
                System.arraycopy(this.readbuf, this.readBufPos, b, off + bwritten, bcopy);
                bwritten += bcopy;
                this.readBufPos += bcopy;
            }
            if (this.readBufPos == this.boundaryPos) {
                this.eos = true;
                log.debug((Object)JavaUtils.getMessage("atEOS", "" + this.streamNo));
                continue;
            }
            if (bwritten >= len) continue;
            byte[] dstbuf = this.readbuf;
            if (this.readbuf.length < len) {
                dstbuf = new byte[len];
            }
            int movecnt = this.readBufEnd - this.readBufPos;
            System.arraycopy(this.readbuf, this.readBufPos, dstbuf, 0, movecnt);
            int readcnt = this.is.read(dstbuf, movecnt, dstbuf.length - movecnt);
            if (readcnt < 0) {
                throw new IOException(JavaUtils.getMessage("eosBeforeMarker"));
            }
            this.readBufEnd = readcnt + movecnt;
            this.readbuf = dstbuf;
            this.readBufPos = 0;
            if (Integer.MAX_VALUE != this.boundaryPos) {
                this.boundaryPos -= movecnt;
                continue;
            }
            this.boundaryPos = this.boundaryPosition(this.readbuf, this.readBufPos, this.readBufEnd - 1);
        } while (!this.eos && bwritten < len);
        if (log.isDebugEnabled() && bwritten > 0) {
            byte[] tb = new byte[bwritten];
            System.arraycopy(b, off, tb, 0, bwritten);
            log.debug((Object)JavaUtils.getMessage("readBStream", new String[]{"" + bwritten, "" + this.streamNo, new String(tb)}));
        }
        return bwritten;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        int read = this.read(b);
        if (read < 0) {
            return -1;
        }
        return b[0];
    }

    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        log.debug((Object)JavaUtils.getMessage("bStreamClosed", "" + this.streamNo));
        this.closed = true;
        if (!this.eos) {
            byte[] readrest = new byte[16384];
            int bread = 0;
            while ((bread = this.read(readrest)) > -1) {
            }
        }
    }

    int boundaryPosition(byte[] searchbuf, int start, int end) {
        int foundAt = this.boundarySearch(searchbuf, start, end);
        if (Integer.MAX_VALUE != foundAt) {
            if (searchbuf[foundAt + this.boundaryLen] == 45 && searchbuf[foundAt + this.boundaryLen + 1] == 45) {
                this.theEnd = true;
            } else if (searchbuf[foundAt + this.boundaryLen] != 13 || searchbuf[foundAt + this.boundaryLen + 1] != 10) {
                foundAt = Integer.MAX_VALUE;
            }
        }
        return foundAt;
    }

    private int boundarySearch(byte[] text, int start, int end) {
        int k;
        if (this.skip == null) {
            this.skip = new int[256];
            Arrays.fill(this.skip, this.boundaryLen);
            k = 0;
            while (k < this.boundaryLen - 1) {
                this.skip[this.boundary[k]] = this.boundaryLen - k - 1;
                ++k;
            }
        }
        k = start + this.boundaryLen - 1;
        while (k <= end) {
            int j = this.boundaryLen - 1;
            int i = k;
            while (j >= 0 && text[i] == this.boundary[j]) {
                --i;
                --j;
            }
            if (j == -1) {
                return i + 1;
            }
            k += this.skip[text[k] & 0xFF];
        }
        return Integer.MAX_VALUE;
    }

    public static void printarry(byte[] b, int start, int end) {
        if (log.isDebugEnabled()) {
            byte[] tb = new byte[end - start];
            System.arraycopy(b, start, tb, 0, end - start);
            log.debug((Object)("\"" + new String(tb) + "\""));
        }
    }
}

