/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.client;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AdminClient {
    protected static Log log;
    private static ThreadLocal defaultConfiguration;
    protected Call call;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.client.AdminClient");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        defaultConfiguration = new ThreadLocal();
    }

    public static void setDefaultConfiguration(EngineConfiguration config) {
        defaultConfiguration.set(config);
    }

    public AdminClient() {
        try {
            EngineConfiguration config = (EngineConfiguration)defaultConfiguration.get();
            Service service = config != null ? new Service(config) : new Service();
            this.call = (Call)service.createCall();
        }
        catch (ServiceException e) {
            log.fatal((Object)JavaUtils.getMessage("couldntCall00"), (Throwable)e);
            this.call = null;
        }
    }

    public Call getCall() {
        return this.call;
    }

    public String list(Options opts) throws Exception {
        this.processOpts(opts);
        return this.list();
    }

    public String list() throws Exception {
        log.debug((Object)JavaUtils.getMessage("doList00"));
        String str = "<m:list xmlns:m=\"AdminService\"/>";
        ByteArrayInputStream input = new ByteArrayInputStream(str.getBytes());
        return this.process(input);
    }

    public String quit(Options opts) throws Exception {
        this.processOpts(opts);
        return this.quit();
    }

    public String quit() throws Exception {
        log.debug((Object)JavaUtils.getMessage("doQuit00"));
        String str = "<m:quit xmlns:m=\"AdminService\"/>";
        ByteArrayInputStream input = new ByteArrayInputStream(str.getBytes());
        return this.process(input);
    }

    public String undeployHandler(String handlerName) throws Exception {
        log.debug((Object)JavaUtils.getMessage("doQuit00"));
        String str = "<m:undeploy xmlns:m=\"AdminService\"><handler name=\"" + handlerName + "\"/>" + "</m:undeploy>";
        ByteArrayInputStream input = new ByteArrayInputStream(str.getBytes());
        return this.process(input);
    }

    public String undeployService(String serviceName) throws Exception {
        log.debug((Object)JavaUtils.getMessage("doQuit00"));
        String str = "<m:undeploy xmlns:m=\"AdminService\"><service name=\"" + serviceName + "\"/>" + "</m:undeploy>";
        ByteArrayInputStream input = new ByteArrayInputStream(str.getBytes());
        return this.process(input);
    }

    public String process(String[] args) throws Exception {
        StringBuffer sb = new StringBuffer();
        Options opts = new Options(args);
        opts.setDefaultURL("http://localhost:8080/axis/services/AdminService");
        opts.isFlagSet('d');
        args = opts.getRemainingArgs();
        if (args == null) {
            log.info((Object)JavaUtils.getMessage("usage00", "AdminClient xml-files | list"));
            return null;
        }
        int i = 0;
        while (i < args.length) {
            ByteArrayInputStream input = null;
            if (args[i].equals("list")) {
                sb.append(this.list(opts));
            } else if (args[i].equals("quit")) {
                sb.append(this.quit(opts));
            } else if (args[i].equals("passwd")) {
                log.info((Object)JavaUtils.getMessage("changePwd00"));
                if (args[i + 1] == null) {
                    log.error((Object)JavaUtils.getMessage("needPwd00"));
                    return null;
                }
                String str = "<m:passwd xmlns:m=\"AdminService\">";
                str = String.valueOf(str) + args[i + 1];
                str = String.valueOf(str) + "</m:passwd>";
                input = new ByteArrayInputStream(str.getBytes());
                ++i;
                sb.append(this.process(opts, input));
            } else if (args[i].indexOf(File.pathSeparatorChar) == -1) {
                log.info((Object)JavaUtils.getMessage("processFile00", args[i]));
                sb.append(this.process(opts, args[i]));
            } else {
                StringTokenizer tokenizer = null;
                tokenizer = new StringTokenizer(args[i], File.pathSeparator);
                while (tokenizer.hasMoreTokens()) {
                    String file = tokenizer.nextToken();
                    log.info((Object)JavaUtils.getMessage("processFile00", file));
                    sb.append(this.process(opts, file));
                    if (!tokenizer.hasMoreTokens()) continue;
                    sb.append("\n");
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public void processOpts(Options opts) throws Exception {
        if (this.call == null) {
            throw new Exception(JavaUtils.getMessage("nullCall00"));
        }
        this.call.setTargetEndpointAddress(new URL(opts.getURL()));
        this.call.setUsername(opts.getUser());
        this.call.setPassword(opts.getPassword());
        String tName = opts.isValueSet('t');
        if (tName != null && !tName.equals("")) {
            this.call.setProperty("transport_name", tName);
        }
    }

    public String process(InputStream input) throws Exception {
        return this.process(null, input);
    }

    public String process(URL xmlURL) throws Exception {
        return this.process(null, xmlURL.openStream());
    }

    public String process(String xmlFile) throws Exception {
        FileInputStream in = new FileInputStream(xmlFile);
        String result = this.process(null, in);
        in.close();
        return result;
    }

    public String process(Options opts, String xmlFile) throws Exception {
        this.processOpts(opts);
        return this.process(xmlFile);
    }

    public String process(Options opts, InputStream input) throws Exception {
        if (this.call == null) {
            throw new Exception(JavaUtils.getMessage("nullCall00"));
        }
        if (opts != null) {
            this.processOpts(opts);
        }
        this.call.setUseSOAPAction(true);
        this.call.setSOAPActionURI("AdminService");
        Vector result = null;
        Object[] params = new Object[]{new SOAPBodyElement(input)};
        result = (Vector)this.call.invoke(params);
        input.close();
        if (result == null || result.isEmpty()) {
            throw new AxisFault(JavaUtils.getMessage("nullResponse00"));
        }
        SOAPBodyElement body = (SOAPBodyElement)result.elementAt(0);
        return body.toString();
    }

    public static void main(String[] args) {
        try {
            AdminClient admin = new AdminClient();
            String result = admin.process(args);
            if (result != null) {
                System.out.println(result);
            } else {
                System.exit(1);
            }
        }
        catch (AxisFault af) {
            log.error((Object)JavaUtils.getMessage("axisFault01", af.dumpToString()));
            System.exit(1);
        }
        catch (Exception e) {
            log.error((Object)JavaUtils.getMessage("exception00"), (Throwable)e);
            System.exit(1);
        }
    }
}

