/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.client;

import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.QName;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ParameterMode;
import org.apache.axis.AxisFault;
import org.apache.axis.InternalException;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.attachments.Attachments;
import org.apache.axis.client.Service;
import org.apache.axis.client.Transport;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.encoding.DeserializerFactory;
import org.apache.axis.encoding.SerializationContextImpl;
import org.apache.axis.encoding.SerializerFactory;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.encoding.XMLType;
import org.apache.axis.encoding.ser.BaseDeserializerFactory;
import org.apache.axis.encoding.ser.BaseSerializerFactory;
import org.apache.axis.message.RPCElement;
import org.apache.axis.message.RPCParam;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPFaultElement;
import org.apache.axis.message.SOAPHeader;
import org.apache.axis.utils.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Call
implements javax.xml.rpc.Call {
    protected static Log log;
    private boolean parmAndRetReq = true;
    private Service service = null;
    private javax.xml.rpc.namespace.QName portTypeName = null;
    private javax.xml.rpc.namespace.QName operationName = null;
    private Vector paramNames = null;
    private Vector paramTypes = null;
    private Vector paramModes = null;
    private javax.xml.rpc.namespace.QName returnType = null;
    private MessageContext msgContext = null;
    private Hashtable myProperties = new Hashtable();
    private String username = null;
    private String password = null;
    private boolean maintainSession = false;
    private int operationStyle = 0;
    private boolean useSOAPAction = false;
    private String SOAPActionURI = null;
    private String encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
    private Integer timeout = null;
    private Transport transport = null;
    private String transportName = null;
    private HashMap outParams = null;
    private Vector myHeaders = null;
    private Class returnJavaType = null;
    public static final String SEND_TYPE_ATTR = "send_type_attr";
    public static final String TRANSPORT_NAME = "transport_name";
    public static final String TRANSPORT_PROPERTY = "java.protocol.handler.pkgs";
    public static final String USERNAME_PROPERTY = "javax.xml.rpc.security.auth.username";
    public static final String PASSWORD_PROPERTY = "javax.xml.rpc.security.auth.password";
    public static final String SESSION_PROPERTY = "javax.xml.rpc.http.session.maintain";
    public static final String OPERATION_STYLE_PROPERTY = "javax.xml.rpc.soap.operation.style";
    public static final String SOAPACTION_USE_PROPERTY = "javax.xml.rpc.soap.http.soapaction.use";
    public static final String SOAPACTION_URI_PROPERTY = "javax.xml.rpc.soap.http.soapaction.uri";
    public static final String ENCODING_STYLE_PROPERTY = "javax.xml.rpc.encodingstyle.namespace.uri";
    private static Hashtable transports;
    private static Hashtable transportImpls;
    private static ArrayList transportPackages;
    protected Vector attachmentParts = new Vector();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.client.Call");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        transports = new Hashtable();
        transportImpls = new Hashtable();
        transportPackages = null;
    }

    public Call(Service service) {
        this.service = service;
        this.msgContext = new MessageContext(service.getEngine());
        this.maintainSession = service.getMaintainSession();
        Call.initialize();
    }

    public Call(String url) throws MalformedURLException {
        this(new Service());
        this.setTargetEndpointAddress(new URL(url));
    }

    public Call(URL url) {
        this(new Service());
        this.setTargetEndpointAddress(url);
    }

    public void setProperty(String name, Object value) {
        if (name == null || value == null) {
            return;
        }
        if (name.equals(USERNAME_PROPERTY)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException(JavaUtils.getMessage("badProp00", new String[]{name, "java.lang.String", value.getClass().getName()}));
            }
            this.setUsername((String)value);
        } else if (name.equals(PASSWORD_PROPERTY)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException(JavaUtils.getMessage("badProp00", new String[]{name, "java.lang.String", value.getClass().getName()}));
            }
            this.setPassword((String)value);
        } else if (name.equals(SESSION_PROPERTY)) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException(JavaUtils.getMessage("badProp00", new String[]{name, "java.lang.Boolean", value.getClass().getName()}));
            }
            this.setMaintainSession((Boolean)value);
        } else if (name.equals(OPERATION_STYLE_PROPERTY)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException(JavaUtils.getMessage("badProp00", new String[]{name, "java.lang.String", value.getClass().getName()}));
            }
            this.setOperationStyle((String)value);
        } else if (name.equals(SOAPACTION_USE_PROPERTY)) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException(JavaUtils.getMessage("badProp00", new String[]{name, "java.lang.Boolean", value.getClass().getName()}));
            }
            this.setUseSOAPAction((Boolean)value);
        } else if (name.equals(SOAPACTION_URI_PROPERTY)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException(JavaUtils.getMessage("badProp00", new String[]{name, "java.lang.String", value.getClass().getName()}));
            }
            this.setSOAPActionURI((String)value);
        } else if (name.equals(ENCODING_STYLE_PROPERTY)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException(JavaUtils.getMessage("badProp00", new String[]{name, "java.lang.String", value.getClass().getName()}));
            }
            this.setEncodingStyle((String)value);
        } else if (name.equals(TRANSPORT_NAME)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException(JavaUtils.getMessage("badProp00", new String[]{name, "java.lang.String", value.getClass().getName()}));
            }
            this.transportName = (String)value;
            if (this.transport != null) {
                this.transport.setTransportName((String)value);
            }
        } else {
            this.myProperties.put(name, value);
        }
    }

    public Object getProperty(String name) {
        if (name != null) {
            if (name.equals(USERNAME_PROPERTY)) {
                return this.getUsername();
            }
            if (name.equals(PASSWORD_PROPERTY)) {
                return this.getPassword();
            }
            if (name.equals(SESSION_PROPERTY)) {
                return new Boolean(this.getMaintainSession());
            }
            if (name.equals(OPERATION_STYLE_PROPERTY)) {
                return MessageContext.getStyleFromInt(this.operationStyle);
            }
            if (name.equals(SOAPACTION_USE_PROPERTY)) {
                return new Boolean(this.useSOAPAction());
            }
            if (name.equals(SOAPACTION_URI_PROPERTY)) {
                return this.getSOAPActionURI();
            }
            if (name.equals(ENCODING_STYLE_PROPERTY)) {
                return this.getEncodingStyle();
            }
            if (name.equals(TRANSPORT_NAME)) {
                return this.transportName;
            }
            return this.myProperties.get(name);
        }
        return null;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setMaintainSession(boolean yesno) {
        this.maintainSession = yesno;
    }

    public boolean getMaintainSession() {
        return this.maintainSession;
    }

    public void setOperationStyle(String operationStyle) {
        this.operationStyle = MessageContext.getStyleFromString(operationStyle);
    }

    public int getOperationStyle() {
        return this.operationStyle;
    }

    public void setUseSOAPAction(boolean useSOAPAction) {
        this.useSOAPAction = useSOAPAction;
    }

    public boolean useSOAPAction() {
        return this.useSOAPAction;
    }

    public void setSOAPActionURI(String SOAPActionURI) throws IllegalArgumentException {
        this.SOAPActionURI = SOAPActionURI;
    }

    public String getSOAPActionURI() {
        return this.SOAPActionURI;
    }

    public void setEncodingStyle(String namespaceURI) {
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        this.encodingStyle = namespaceURI;
    }

    public String getEncodingStyle() {
        return this.encodingStyle;
    }

    public void removeProperty(String name) {
        if (name == null || this.myProperties == null) {
            return;
        }
        this.myProperties.remove(name);
    }

    public void setTargetEndpointAddress(URL address) {
        try {
            URL tmpURL;
            String oldProto;
            String oldAddr;
            if (address == null) {
                this.setTransport(null);
                return;
            }
            String protocol = address.getProtocol();
            if (this.transport != null && (oldAddr = this.transport.getUrl()) != null && !oldAddr.equals("") && protocol.equals(oldProto = (tmpURL = new URL(oldAddr)).getProtocol())) {
                this.transport.setUrl(address.toString());
                return;
            }
            Transport transport = (Transport)transportImpls.get(address);
            if (transport != null) {
                this.setTransport(transport);
            } else {
                transport = this.getTransportForProtocol(protocol);
                if (transport == null) {
                    throw new AxisFault("Call.setTargetEndpointAddress", JavaUtils.getMessage("noTransport01", protocol), null, null);
                }
                transport.setUrl(address.toString());
                this.setTransport(transport);
                transportImpls.put(address, transport);
            }
        }
        catch (Exception exp) {
            log.error((Object)JavaUtils.getMessage("exception00"), (Throwable)exp);
        }
    }

    public URL getTargetEndpointAddress() {
        try {
            if (this.transport == null) {
                return null;
            }
            return new URL(this.transport.getUrl());
        }
        catch (Exception exp) {
            return null;
        }
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public boolean isParameterAndReturnSpecRequired() {
        return this.parmAndRetReq;
    }

    public void addParameter(String paramName, javax.xml.rpc.namespace.QName paramType, ParameterMode parameterMode) {
        if (this.parmAndRetReq) {
            if (this.paramNames == null) {
                this.paramNames = new Vector();
                this.paramTypes = new Vector();
                this.paramModes = new Vector();
            }
        } else {
            throw new JAXRPCException();
        }
        this.paramNames.add(new javax.xml.rpc.namespace.QName("", paramName));
        this.paramTypes.add(paramType);
        this.paramModes.add(parameterMode);
    }

    public void addParameter(javax.xml.rpc.namespace.QName paramName, javax.xml.rpc.namespace.QName paramType, ParameterMode parameterMode) {
        if (this.parmAndRetReq) {
            if (this.paramNames == null) {
                this.paramNames = new Vector();
                this.paramTypes = new Vector();
                this.paramModes = new Vector();
            }
        } else {
            throw new JAXRPCException();
        }
        this.paramNames.add(paramName);
        this.paramTypes.add(paramType);
        this.paramModes.add(parameterMode);
    }

    public javax.xml.rpc.namespace.QName getParameterTypeByName(String paramName) {
        javax.xml.rpc.namespace.QName paramQName = new javax.xml.rpc.namespace.QName("", paramName);
        return this.getParameterTypeByQName(paramQName);
    }

    public javax.xml.rpc.namespace.QName getParameterTypeByQName(javax.xml.rpc.namespace.QName paramQName) {
        if (this.paramNames == null) {
            return null;
        }
        int i = 0;
        while (i < this.paramNames.size()) {
            if (((javax.xml.rpc.namespace.QName)this.paramNames.get(i)).equals(paramQName)) {
                return (javax.xml.rpc.namespace.QName)this.paramTypes.get(i);
            }
            ++i;
        }
        return null;
    }

    public void setReturnType(javax.xml.rpc.namespace.QName type) {
        if (!this.parmAndRetReq) {
            throw new JAXRPCException();
        }
        this.returnType = type;
    }

    public javax.xml.rpc.namespace.QName getReturnType() {
        return this.returnType;
    }

    public void setReturnClass(Class cls) {
        this.returnJavaType = cls;
    }

    public void removeAllParameters() {
        if (!this.parmAndRetReq) {
            throw new JAXRPCException();
        }
        this.paramNames = null;
        this.paramTypes = null;
        this.paramModes = null;
    }

    public javax.xml.rpc.namespace.QName getOperationName() {
        return this.operationName;
    }

    public void setOperationName(javax.xml.rpc.namespace.QName opName) {
        this.operationName = opName;
    }

    public void setOperationName(String opName) {
        this.operationName = new javax.xml.rpc.namespace.QName(opName);
    }

    public void setOperation(javax.xml.rpc.namespace.QName portName, String opName) {
        QName type;
        if (this.service == null) {
            throw new JAXRPCException(JavaUtils.getMessage("noService04"));
        }
        Definition wsdlDefinition = this.service.getWSDLDefinition();
        javax.wsdl.Service wsdlService = this.service.getWSDLService();
        QName qn = new QName(portName.getNamespaceURI(), portName.getLocalPart());
        if (wsdlDefinition == null) {
            throw new JAXRPCException(JavaUtils.getMessage("wsdlMissing00"));
        }
        Port port = wsdlService.getPort(portName.getLocalPart());
        if (port == null) {
            throw new JAXRPCException(JavaUtils.getMessage("noPort00", "" + portName));
        }
        Binding binding = port.getBinding();
        PortType portType = binding.getPortType();
        if (portType == null) {
            throw new JAXRPCException(JavaUtils.getMessage("noPortType00", "" + portName));
        }
        List operations = portType.getOperations();
        if (operations == null) {
            throw new JAXRPCException(JavaUtils.getMessage("noOperation01", opName));
        }
        Operation op = null;
        int i = 0;
        while (i < operations.size()) {
            op = (Operation)operations.get(i);
            if (opName.equals(op.getName())) break;
            ++i;
            op = null;
        }
        if (op == null) {
            throw new JAXRPCException(JavaUtils.getMessage("noOperation01", opName));
        }
        this.setPortTypeName(portName);
        this.setOperationName(opName);
        this.setTargetEndpointAddress(null);
        List list = port.getExtensibilityElements();
        int i2 = 0;
        while (list != null && i2 < list.size()) {
            Object obj = list.get(i2);
            if (obj instanceof SOAPAddress) {
                try {
                    SOAPAddress addr = (SOAPAddress)obj;
                    URL url = new URL(addr.getLocationURI());
                    this.setTargetEndpointAddress(url);
                }
                catch (Exception exp) {
                    throw new JAXRPCException(JavaUtils.getMessage("cantSetURI00", "" + exp));
                }
            }
            ++i2;
        }
        BindingOperation bop = binding.getBindingOperation(opName, null, null);
        if (bop == null) {
            throw new JAXRPCException(JavaUtils.getMessage("noOperation02", opName));
        }
        list = bop.getExtensibilityElements();
        int i3 = 0;
        while (list != null && i3 < list.size()) {
            Object obj = list.get(i3);
            if (obj instanceof SOAPOperation) {
                SOAPOperation sop = (SOAPOperation)obj;
                String action = sop.getSoapActionURI();
                if (action != null) {
                    this.setUseSOAPAction(true);
                    this.setSOAPActionURI(action);
                    break;
                }
                this.setUseSOAPAction(false);
                this.setSOAPActionURI(null);
                break;
            }
            ++i3;
        }
        this.setEncodingStyle(null);
        BindingInput bIn = bop.getBindingInput();
        if (bIn != null) {
            list = bIn.getExtensibilityElements();
            int i4 = 0;
            while (list != null && i4 < list.size()) {
                Object obj = list.get(i4);
                if (obj instanceof MIMEMultipartRelated) {
                    MIMEMultipartRelated mpr = (MIMEMultipartRelated)obj;
                    Object part = null;
                    List l = mpr.getMIMEParts();
                    int j = 0;
                    while (l != null && j < l.size() && part == null) {
                        MIMEPart mp = (MIMEPart)l.get(j);
                        List ll = mp.getExtensibilityElements();
                        int k = 0;
                        while (ll != null && k < ll.size() && part == null) {
                            part = ll.get(k);
                            if (!(part instanceof SOAPBody)) {
                                part = null;
                            }
                            ++k;
                        }
                        ++j;
                    }
                    if (part != null) {
                        obj = part;
                    }
                }
                if (obj instanceof SOAPBody) {
                    String ns;
                    SOAPBody sBody = (SOAPBody)obj;
                    list = sBody.getEncodingStyles();
                    if (list != null && list.size() > 0) {
                        this.setEncodingStyle((String)list.get(0));
                    }
                    if ((ns = sBody.getNamespaceURI()) == null || ns.equals("")) break;
                    this.setOperationName(new javax.xml.rpc.namespace.QName(ns, opName));
                    break;
                }
                ++i4;
            }
        }
        List paramOrder = op.getParameterOrdering();
        Input input = op.getInput();
        javax.wsdl.Message message = null;
        List parts = null;
        this.removeAllParameters();
        if (input != null) {
            message = input.getMessage();
        }
        if (message != null) {
            parts = message.getOrderedParts(paramOrder);
        }
        if (parts != null) {
            int i5 = 0;
            while (i5 < parts.size()) {
                Part part = (Part)parts.get(i5);
                if (part != null) {
                    String name = part.getName();
                    type = part.getTypeName();
                    if (type == null) {
                        type = part.getElementName();
                        if (type != null) {
                            type = new QName("java", "org.w3c.dom.Element");
                        } else {
                            throw new JAXRPCException(JavaUtils.getMessage("typeNotSet00", name));
                        }
                    }
                    javax.xml.rpc.namespace.QName qname = new javax.xml.rpc.namespace.QName(type.getNamespaceURI(), type.getLocalPart());
                    ParameterMode mode = ParameterMode.PARAM_MODE_IN;
                    this.addParameter(name, qname, mode);
                }
                ++i5;
            }
        }
        Output output = op.getOutput();
        message = null;
        if (output != null) {
            message = output.getMessage();
        }
        if (message != null) {
            parts = message.getOrderedParts(null);
        }
        this.setReturnType(null);
        if (parts != null) {
            int i6 = 0;
            while (i6 < parts.size()) {
                Part part = (Part)parts.get(i6);
                if (paramOrder == null || !paramOrder.contains(part.getName())) {
                    type = part.getTypeName();
                    if (type == null) {
                        type = part.getElementName();
                        if (type != null) {
                            type = new QName("java", "org.w3c.dom.Element");
                        } else {
                            throw new JAXRPCException(JavaUtils.getMessage("typeNotSet00", "<return>"));
                        }
                    }
                    javax.xml.rpc.namespace.QName qname = new javax.xml.rpc.namespace.QName(type.getNamespaceURI(), type.getLocalPart());
                    this.setReturnType(qname);
                    break;
                }
                ++i6;
            }
        }
    }

    public javax.xml.rpc.namespace.QName getPortTypeName() {
        return this.portTypeName;
    }

    public void setPortTypeName(javax.xml.rpc.namespace.QName portType) {
        this.portTypeName = portType;
    }

    public Object invoke(javax.xml.rpc.namespace.QName operationName, Object[] params) throws RemoteException {
        javax.xml.rpc.namespace.QName origOpName = this.operationName;
        this.operationName = operationName;
        try {
            return this.invoke(params);
        }
        catch (RemoteException re) {
            this.operationName = origOpName;
            throw re;
        }
        catch (RuntimeException re) {
            this.operationName = origOpName;
            throw re;
        }
        catch (Error e) {
            this.operationName = origOpName;
            throw e;
        }
    }

    public Object invoke(Object[] params) throws RemoteException {
        SOAPEnvelope env = null;
        int i = 0;
        while (params != null && i < params.length) {
            if (!(params[i] instanceof SOAPBodyElement)) break;
            ++i;
        }
        if (params != null && params.length > 0 && i == params.length) {
            env = new SOAPEnvelope();
            i = 0;
            while (this.myHeaders != null && i < this.myHeaders.size()) {
                env.addHeader((SOAPHeader)this.myHeaders.get(i));
                ++i;
            }
            if (!(params[0] instanceof SOAPEnvelope)) {
                i = 0;
                while (i < params.length) {
                    env.addBodyElement((SOAPBodyElement)params[i]);
                    ++i;
                }
            }
            Message msg = new Message(env);
            this.setRequestMessage(msg);
            this.invoke();
            msg = this.msgContext.getResponseMessage();
            if (msg == null) {
                throw new AxisFault(JavaUtils.getMessage("nullResponse00"));
            }
            env = msg.getSOAPEnvelope();
            return env.getBodyElements();
        }
        if (this.operationName == null) {
            throw new AxisFault(JavaUtils.getMessage("noOperation00"));
        }
        try {
            return this.invoke(this.operationName.getNamespaceURI(), this.operationName.getLocalPart(), this.getParamList(params));
        }
        catch (AxisFault af) {
            throw af;
        }
        catch (Exception exp) {
            throw new AxisFault(JavaUtils.getMessage("errorInvoking00", "\n" + exp));
        }
    }

    public void invokeOneWay(Object[] params) {
        try {
            this.invoke(this.getParamList(params));
        }
        catch (Exception exp) {
            throw new JAXRPCException(exp.toString());
        }
    }

    public SOAPEnvelope invoke(SOAPEnvelope env) throws RemoteException {
        try {
            Message msg = null;
            int i = 0;
            while (this.myHeaders != null && i < this.myHeaders.size()) {
                env.addHeader((SOAPHeader)this.myHeaders.get(i));
                ++i;
            }
            msg = new Message(env);
            this.setRequestMessage(msg);
            this.invoke();
            msg = this.msgContext.getResponseMessage();
            if (msg == null) {
                throw new AxisFault(JavaUtils.getMessage("nullResponse00"));
            }
            return msg.getSOAPEnvelope();
        }
        catch (Exception exp) {
            if (exp instanceof AxisFault) {
                throw (AxisFault)exp;
            }
            throw new AxisFault(JavaUtils.getMessage("errorInvoking00", "\n" + exp));
        }
    }

    public static void setTransportForProtocol(String protocol, Class transportClass) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.apache.axis.client.Transport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.isAssignableFrom(transportClass)) {
            throw new InternalException(transportClass.toString());
        }
        transports.put(protocol, transportClass);
    }

    public static synchronized void initialize() {
        Call.addTransportPackage("org.apache.axis.transport");
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.apache.axis.transport.local.LocalTransport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Call.setTransportForProtocol("local", clazz);
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            try {
                clazz2 = class$3 = Class.forName("org.apache.axis.transport.http.HTTPTransport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Call.setTransportForProtocol("http", clazz2);
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("org.apache.axis.transport.http.HTTPTransport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Call.setTransportForProtocol("https", clazz3);
    }

    public static synchronized void addTransportPackage(String packageName) {
        CharSequence currentPackages;
        if (transportPackages == null) {
            transportPackages = new ArrayList();
            currentPackages = System.getProperty(TRANSPORT_PROPERTY);
            if (currentPackages != null) {
                StringTokenizer tok = new StringTokenizer((String)currentPackages, "|");
                while (tok.hasMoreTokens()) {
                    transportPackages.add(tok.nextToken());
                }
            }
        }
        if (transportPackages.contains(packageName)) {
            return;
        }
        transportPackages.add(packageName);
        currentPackages = new StringBuffer();
        Iterator i = ((AbstractList)transportPackages).iterator();
        while (i.hasNext()) {
            String thisPackage = (String)i.next();
            ((StringBuffer)currentPackages).append(thisPackage);
            ((StringBuffer)currentPackages).append('|');
        }
        System.setProperty(TRANSPORT_PROPERTY, ((StringBuffer)currentPackages).toString());
    }

    private Object[] getParamList(Object[] params) {
        int numParams = 0;
        if (this.paramNames == null) {
            return params;
        }
        int i = 0;
        while (i < this.paramNames.size()) {
            if (this.paramModes.get(i) != ParameterMode.PARAM_MODE_OUT) {
                ++numParams;
            }
            ++i;
        }
        if (numParams != params.length) {
            throw new JAXRPCException(JavaUtils.getMessage("parmMismatch00", "" + params.length, "" + numParams));
        }
        Vector<RPCParam> result = new Vector<RPCParam>();
        int j = 0;
        i = 0;
        while (i < this.paramNames.size()) {
            if (this.paramModes.get(i) != ParameterMode.PARAM_MODE_OUT) {
                javax.xml.rpc.namespace.QName paramQName = (javax.xml.rpc.namespace.QName)this.paramNames.get(i);
                RPCParam p = new RPCParam(paramQName.getNamespaceURI(), paramQName.getLocalPart(), params[j++]);
                result.add(p);
            }
            ++i;
        }
        return result.toArray();
    }

    public void setTransport(Transport trans) {
        this.transport = trans;
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("transport00", "" + this.transport));
        }
    }

    public Transport getTransportForProtocol(String protocol) {
        Class transportClass = (Class)transports.get(protocol);
        Transport ret = null;
        if (transportClass != null) {
            try {
                ret = (Transport)transportClass.newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return ret;
    }

    public void setRequestMessage(Message msg) {
        if (this.attachmentParts != null && !this.attachmentParts.isEmpty()) {
            try {
                Attachments attachments = msg.getAttachments();
                if (attachments == null) {
                    throw new RuntimeException(JavaUtils.getMessage("noAttachments"));
                }
                attachments.setAttachmentParts(this.attachmentParts);
            }
            catch (AxisFault ex) {
                log.debug((Object)JavaUtils.getMessage("axisFault00"), (Throwable)ex);
                throw new RuntimeException(ex.getMessage());
            }
        }
        this.msgContext.setRequestMessage(msg);
        this.attachmentParts.clear();
    }

    public Message getResponseMessage() {
        return this.msgContext.getResponseMessage();
    }

    public MessageContext getMessageContext() {
        return this.msgContext;
    }

    public void addHeader(SOAPHeader header) {
        if (this.myHeaders == null) {
            this.myHeaders = new Vector();
        }
        this.myHeaders.add(header);
    }

    public void clearHeaders() {
        this.myHeaders = null;
    }

    public void registerTypeMapping(Class javaType, javax.xml.rpc.namespace.QName xmlType, SerializerFactory sf, DeserializerFactory df) {
        this.registerTypeMapping(javaType, xmlType, sf, df, true);
    }

    public void registerTypeMapping(Class javaType, javax.xml.rpc.namespace.QName xmlType, SerializerFactory sf, DeserializerFactory df, boolean force) {
        TypeMappingRegistry tmr = this.msgContext.getTypeMappingRegistry();
        TypeMapping tm = (TypeMapping)tmr.getTypeMapping(this.encodingStyle);
        TypeMapping defaultTM = (TypeMapping)tmr.getDefaultTypeMapping();
        try {
            if (tm == null || tm == defaultTM) {
                tm = (TypeMapping)tmr.createTypeMapping();
                tm.setSupportedNamespaces(new String[]{this.encodingStyle});
                tmr.register(this.encodingStyle, tm);
            }
            if (!force && tm.isRegistered(javaType, xmlType)) {
                return;
            }
            tm.register(javaType, xmlType, sf, df);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void registerTypeMapping(Class javaType, javax.xml.rpc.namespace.QName xmlType, Class sfClass, Class dfClass) {
        this.registerTypeMapping(javaType, xmlType, sfClass, dfClass, true);
    }

    public void registerTypeMapping(Class javaType, javax.xml.rpc.namespace.QName xmlType, Class sfClass, Class dfClass, boolean force) {
        SerializerFactory sf = BaseSerializerFactory.createFactory(sfClass, javaType, xmlType);
        DeserializerFactory df = BaseDeserializerFactory.createFactory(dfClass, javaType, xmlType);
        if (sf != null || df != null) {
            this.registerTypeMapping(javaType, xmlType, sf, df, force);
        }
    }

    public Object invoke(String namespace, String method, Object[] args) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("enter00", "Call::invoke(ns, meth, args)"));
        }
        if (this.returnType != null && args != null && args.length != 0 && this.paramTypes == null) {
            throw new AxisFault(JavaUtils.getMessage("mustSpecifyParms"));
        }
        RPCElement body = new RPCElement(namespace, method, args);
        Object ret = this.invoke(body);
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("exit00", "Call::invoke(ns, meth, args)"));
        }
        return ret;
    }

    public Object invoke(String method, Object[] args) throws AxisFault {
        return this.invoke("", method, args);
    }

    public Object invoke(RPCElement body) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("enter00", "Call::invoke(RPCElement)"));
        }
        if (this.paramTypes != null && this.returnType == null) {
            throw new AxisFault(JavaUtils.getMessage("mustSpecifyReturnType"));
        }
        SOAPEnvelope reqEnv = new SOAPEnvelope();
        SOAPEnvelope resEnv = null;
        Message reqMsg = new Message(reqEnv);
        Message resMsg = null;
        Vector resArgs = null;
        Object result = null;
        this.outParams = new HashMap();
        if (this.myHeaders != null) {
            int i = 0;
            while (i < this.myHeaders.size()) {
                reqEnv.addHeader((SOAPHeader)this.myHeaders.get(i));
                ++i;
            }
        }
        try {
            body.setEncodingStyle(this.encodingStyle);
            reqEnv.setEncodingStyle(this.encodingStyle);
            this.setRequestMessage(reqMsg);
            reqEnv.addBodyElement(body);
            body.setParent(reqEnv);
            reqEnv.setMessageType("request");
            this.invoke();
        }
        catch (Exception e) {
            log.debug((Object)JavaUtils.getMessage("exception00"), (Throwable)e);
            throw AxisFault.makeFault(e);
        }
        resMsg = this.msgContext.getResponseMessage();
        resEnv = resMsg.getSOAPEnvelope();
        SOAPBodyElement bodyEl = resEnv.getFirstBody();
        if (bodyEl instanceof RPCElement) {
            try {
                resArgs = ((RPCElement)bodyEl).getParams();
            }
            catch (Exception e) {
                log.error((Object)JavaUtils.getMessage("exception00"), (Throwable)e);
                throw AxisFault.makeFault(e);
            }
            if (resArgs != null && resArgs.size() > 0) {
                int outParamStart = 0;
                if (!XMLType.AXIS_VOID.equals(this.returnType)) {
                    RPCParam param = (RPCParam)resArgs.get(0);
                    result = param.getValue();
                    outParamStart = 1;
                }
                int i = outParamStart;
                while (i < resArgs.size()) {
                    RPCParam param = (RPCParam)resArgs.get(i);
                    this.outParams.put(param.getQName(), param.getValue());
                    ++i;
                }
            }
        } else {
            try {
                result = bodyEl.getValueAsType(this.returnType);
            }
            catch (Exception e) {
                result = bodyEl;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("exit00", "Call::invoke(RPCElement)"));
        }
        if (this.returnJavaType != null && !this.returnJavaType.isAssignableFrom(result.getClass())) {
            result = JavaUtils.convert(result, this.returnJavaType);
        }
        return result;
    }

    public void setOption(String name, Object value) {
        this.service.getEngine().setOption(name, value);
    }

    public void invoke() throws AxisFault {
        Message resMsg;
        SOAPBodyElement body;
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("enter00", "Call::invoke()"));
        }
        Message reqMsg = null;
        SOAPEnvelope reqEnv = null;
        this.msgContext.reset();
        this.msgContext.setResponseMessage(null);
        this.msgContext.setProperty(MessageContext.CALL, this);
        if (this.username != null) {
            this.msgContext.setUsername(this.username);
        }
        if (this.password != null) {
            this.msgContext.setPassword(this.password);
        }
        this.msgContext.setMaintainSession(this.maintainSession);
        OperationDesc operationDesc = new OperationDesc();
        this.msgContext.setOperation(operationDesc);
        operationDesc.setStyle(this.operationStyle);
        this.msgContext.setOperationStyle(this.operationStyle);
        if (this.useSOAPAction) {
            this.msgContext.setUseSOAPAction(true);
        }
        if (this.SOAPActionURI != null) {
            this.msgContext.setSOAPActionURI(this.SOAPActionURI);
        }
        if (this.timeout != null) {
            this.msgContext.setTimeout(this.timeout);
        }
        this.msgContext.setEncodingStyle(this.encodingStyle);
        if (this.myProperties != null) {
            this.msgContext.setPropertyParent(this.myProperties);
        }
        if ((body = (reqEnv = (reqMsg = this.msgContext.getRequestMessage()).getSOAPEnvelope()).getFirstBody()).getPrefix() == null) {
            body.setPrefix("m");
        }
        if (body.getNamespaceURI() == null) {
            throw new AxisFault("Call.invoke", JavaUtils.getMessage("cantInvoke00", body.getName()), null, null);
        }
        if (this.msgContext.getService() == null) {
            this.msgContext.setTargetService(body.getNamespaceURI());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("targetService", this.msgContext.getTargetService()));
        }
        if (this.transport != null) {
            this.transport.setupMessageContext(this.msgContext, this, this.service.getEngine());
        } else {
            this.msgContext.setTransportName(this.transportName);
        }
        if (log.isDebugEnabled()) {
            StringWriter writer = new StringWriter();
            try {
                try {
                    SerializationContextImpl ctx = new SerializationContextImpl(writer, this.msgContext);
                    reqEnv.output(ctx);
                    writer.close();
                }
                catch (Exception e) {
                    log.debug((Object)JavaUtils.getMessage("exceptionPrinting"), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                log.debug((Object)writer.getBuffer().toString());
                throw throwable;
            }
            Object var8_11 = null;
            log.debug((Object)writer.getBuffer().toString());
        }
        this.service.getEngine().invoke(this.msgContext);
        if (this.transport != null) {
            this.transport.processReturnedMessageContext(this.msgContext);
        }
        if ((resMsg = this.msgContext.getResponseMessage()) == null) {
            throw new AxisFault(JavaUtils.getMessage("nullResponse00"));
        }
        resMsg.setMessageType("response");
        SOAPEnvelope resEnv = resMsg.getSOAPPart().getAsSOAPEnvelope();
        SOAPBodyElement respBody = resEnv.getFirstBody();
        if (respBody instanceof SOAPFaultElement) {
            throw ((SOAPFaultElement)respBody).getFault();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("exit00", "Call::invoke()"));
        }
    }

    public Map getOutputParams() {
        return this.outParams;
    }

    public Service getService() {
        return this.service;
    }

    public void addAttachmentPart(Object attachment) {
        this.attachmentParts.add(attachment);
    }
}

