/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.client;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.QName;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import org.apache.axis.AxisEngine;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.AxisClient;
import org.apache.axis.client.AxisClientProxy;
import org.apache.axis.client.Call;
import org.apache.axis.configuration.DefaultEngineConfigurationFactory;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Document;

public class Service
implements javax.xml.rpc.Service,
Serializable,
Referenceable {
    private transient AxisEngine engine = null;
    private transient EngineConfiguration config = new DefaultEngineConfigurationFactory().getClientEngineConfig();
    private URL wsdlLocation = null;
    private Definition wsdlDefinition = null;
    private javax.wsdl.Service wsdlService = null;
    private boolean maintainSession = false;
    static /* synthetic */ Class class$0;

    Definition getWSDLDefinition() {
        return this.wsdlDefinition;
    }

    javax.wsdl.Service getWSDLService() {
        return this.wsdlService;
    }

    protected AxisClient getAxisClient() {
        return new AxisClient(this.config);
    }

    public Service() {
        this.engine = this.getAxisClient();
    }

    public Service(EngineConfiguration config) {
        this.config = config;
        this.engine = this.getAxisClient();
    }

    public Service(URL wsdlDoc, javax.xml.rpc.namespace.QName serviceName) throws ServiceException {
        this.engine = this.getAxisClient();
        this.wsdlLocation = wsdlDoc;
        Document doc = XMLUtils.newDocument(wsdlDoc.toString());
        this.initService(doc, serviceName);
    }

    public Service(String wsdlLocation, javax.xml.rpc.namespace.QName serviceName) throws ServiceException {
        this.engine = this.getAxisClient();
        try {
            this.wsdlLocation = new URL(wsdlLocation);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            FileInputStream fis = new FileInputStream(wsdlLocation);
            Document doc = XMLUtils.newDocument(fis);
            this.initService(doc, serviceName);
        }
        catch (FileNotFoundException exp) {
            throw new ServiceException(JavaUtils.getMessage("wsdlError00", "" + wsdlLocation, "\n" + exp));
        }
    }

    public Service(InputStream wsdlInputStream, javax.xml.rpc.namespace.QName serviceName) throws ServiceException {
        this.engine = this.getAxisClient();
        Document doc = XMLUtils.newDocument(wsdlInputStream);
        this.initService(doc, serviceName);
    }

    private void initService(Document doc, javax.xml.rpc.namespace.QName serviceName) throws ServiceException {
        try {
            Definition def;
            WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
            reader.setFeature("javax.wsdl.verbose", false);
            this.wsdlDefinition = def = reader.readWSDL(null, doc);
            String ns = serviceName.getNamespaceURI();
            String lp = serviceName.getLocalPart();
            QName qn = new QName(ns, lp);
            this.wsdlService = def.getService(qn);
            if (this.wsdlService == null) {
                throw new ServiceException(JavaUtils.getMessage("noService00", "" + serviceName));
            }
        }
        catch (Exception exp) {
            throw new ServiceException(JavaUtils.getMessage("wsdlError00", "", "\n" + exp));
        }
    }

    public Remote getPort(javax.xml.rpc.namespace.QName portName, Class proxyInterface) throws ServiceException {
        return null;
    }

    public Remote getPort(Class proxyInterface) throws ServiceException {
        return null;
    }

    public Remote getPort(String endpoint, Class proxyInterface) throws ServiceException {
        if (!proxyInterface.isInterface()) {
            throw new ServiceException(JavaUtils.getMessage("mustBeIface00"));
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.rmi.Remote");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.isAssignableFrom(proxyInterface)) {
            throw new ServiceException(JavaUtils.getMessage("mustExtendRemote00"));
        }
        try {
            Call call = new Call(endpoint);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            return (Remote)Proxy.newProxyInstance(classLoader, new Class[]{proxyInterface}, (InvocationHandler)new AxisClientProxy(call));
        }
        catch (Exception e) {
            throw new ServiceException(e.toString());
        }
    }

    public javax.xml.rpc.Call createCall(javax.xml.rpc.namespace.QName portName) throws ServiceException {
        QName qn = new QName(portName.getNamespaceURI(), portName.getLocalPart());
        if (this.wsdlDefinition == null) {
            throw new ServiceException(JavaUtils.getMessage("wsdlMissing00"));
        }
        Port port = this.wsdlService.getPort(portName.getLocalPart());
        if (port == null) {
            throw new ServiceException(JavaUtils.getMessage("noPort00", "" + portName));
        }
        Binding binding = port.getBinding();
        PortType portType = binding.getPortType();
        if (portType == null) {
            throw new ServiceException(JavaUtils.getMessage("noPortType00", "" + portName));
        }
        Call call = new Call(this);
        call.setPortTypeName(portName);
        List list = port.getExtensibilityElements();
        int i = 0;
        while (list != null && i < list.size()) {
            Object obj = list.get(i);
            if (obj instanceof SOAPAddress) {
                try {
                    SOAPAddress addr = (SOAPAddress)obj;
                    URL url = new URL(addr.getLocationURI());
                    call.setTargetEndpointAddress(url);
                }
                catch (Exception exp) {
                    throw new ServiceException(JavaUtils.getMessage("cantSetURI00", "" + exp));
                }
            }
            ++i;
        }
        return call;
    }

    public javax.xml.rpc.Call createCall(javax.xml.rpc.namespace.QName portName, String operationName) throws ServiceException {
        Call call = new Call(this);
        call.setOperation(portName, operationName);
        return call;
    }

    public javax.xml.rpc.Call createCall(javax.xml.rpc.namespace.QName portName, javax.xml.rpc.namespace.QName operationName) throws ServiceException {
        Call call = new Call(this);
        call.setOperation(portName, operationName.getLocalPart());
        return call;
    }

    public javax.xml.rpc.Call createCall() throws ServiceException {
        return new Call(this);
    }

    public URL getWSDLDocumentLocation() {
        return this.wsdlLocation;
    }

    public javax.xml.rpc.namespace.QName getServiceName() {
        if (this.wsdlService == null) {
            return null;
        }
        QName qn = this.wsdlService.getQName();
        return new javax.xml.rpc.namespace.QName(qn.getNamespaceURI(), qn.getLocalPart());
    }

    public Iterator getPorts() {
        if (this.wsdlService == null) {
            return null;
        }
        Map map = this.wsdlService.getPorts();
        if (map == null) {
            return null;
        }
        Set set = map.keySet();
        Iterator iter = set.iterator();
        HashSet<Port> ports = null;
        while (iter.hasNext()) {
            String name = (String)iter.next();
            Port port = (Port)map.get(name);
            if (ports == null) {
                ports = new HashSet<Port>();
            }
            ports.add(port);
        }
        if (ports == null) {
            return null;
        }
        return ports.iterator();
    }

    public void setTypeMappingRegistry(TypeMappingRegistry registry) throws ServiceException {
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        return null;
    }

    public Reference getReference() {
        String classname = this.getClass().getName();
        Reference reference = new Reference(classname, "org.apache.axis.client.ServiceFactory", null);
        StringRefAddr addr = null;
        if (!classname.equals("org.apache.axis.client.Service")) {
            addr = new StringRefAddr("service classname", classname);
            reference.add(addr);
        } else {
            javax.xml.rpc.namespace.QName serviceName;
            if (this.wsdlLocation != null) {
                addr = new StringRefAddr("WSDL location", this.wsdlLocation.toString());
                reference.add(addr);
            }
            if ((serviceName = this.getServiceName()) != null) {
                addr = new StringRefAddr("service namespace", serviceName.getNamespaceURI());
                reference.add(addr);
                addr = new StringRefAddr("service local part", serviceName.getLocalPart());
                reference.add(addr);
            }
        }
        if (this.maintainSession) {
            addr = new StringRefAddr("maintain session", "true");
            reference.add(addr);
        }
        return reference;
    }

    public void setEngine(AxisEngine engine) {
        this.engine = engine;
    }

    public AxisEngine getEngine() {
        return this.engine;
    }

    public void setEngineConfiguration(EngineConfiguration config) {
        this.config = config;
    }

    public void setMaintainSession(boolean yesno) {
        this.maintainSession = yesno;
    }

    public boolean getMaintainSession() {
        return this.maintainSession;
    }
}

