/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.client;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Service;
import org.apache.axis.configuration.DefaultEngineConfigurationFactory;

public class ServiceFactory
implements ObjectFactory {
    public static final String SERVICE_CLASSNAME = "service classname";
    public static final String WSDL_LOCATION = "WSDL location";
    public static final String MAINTAIN_SESSION = "maintain session";
    public static final String SERVICE_NAMESPACE = "service namespace";
    public static final String SERVICE_LOCAL_PART = "service local part";
    private static EngineConfiguration defaultEngineConfig = new DefaultEngineConfigurationFactory().getClientEngineConfig();
    private static ThreadLocal threadDefaultConfig = new ThreadLocal();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static void setThreadDefaultConfig(EngineConfiguration config) {
        threadDefaultConfig.set(config);
    }

    public static Service getService(Map environment) {
        Service service = null;
        InitialContext context = null;
        EngineConfiguration configProvider = (EngineConfiguration)environment.get("engineConfig");
        if (configProvider == null) {
            configProvider = (EngineConfiguration)threadDefaultConfig.get();
        }
        if (configProvider == null) {
            configProvider = defaultEngineConfig;
        }
        try {
            context = new InitialContext();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (context != null) {
            String name = (String)environment.get("jndiName");
            if (name == null) {
                name = "axisServiceName";
            }
            try {
                service = (Service)context.lookup(name);
            }
            catch (NamingException e) {
                service = new Service(configProvider);
                try {
                    context.bind(name, (Object)service);
                }
                catch (NamingException e1) {}
            }
        } else {
            service = new Service(configProvider);
        }
        return service;
    }

    public Object getObjectInstance(Object refObject, Name name, Context nameCtx, Hashtable environment) throws Exception {
        Object instance = null;
        if (refObject instanceof Reference) {
            Reference ref = (Reference)refObject;
            RefAddr addr = ref.get(SERVICE_CLASSNAME);
            Object obj = null;
            if (addr != null && (obj = addr.getContent()) instanceof String) {
                instance = Class.forName((String)obj).newInstance();
            } else {
                addr = ref.get(WSDL_LOCATION);
                if (addr != null && (obj = addr.getContent()) instanceof String) {
                    URL wsdlLocation = new URL((String)obj);
                    addr = ref.get(SERVICE_NAMESPACE);
                    if (addr != null && (obj = addr.getContent()) instanceof String) {
                        String namespace = (String)obj;
                        addr = ref.get(SERVICE_LOCAL_PART);
                        if (addr != null && (obj = addr.getContent()) instanceof String) {
                            String localPart = (String)obj;
                            QName serviceName = new QName(namespace, localPart);
                            Class[] classArray = new Class[2];
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = class$0 = Class.forName("java.net.URL");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            classArray[0] = clazz;
                            Class<?> clazz2 = class$1;
                            if (clazz2 == null) {
                                try {
                                    clazz2 = class$1 = Class.forName("javax.xml.rpc.namespace.QName");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            classArray[1] = clazz2;
                            Class[] formalArgs = classArray;
                            Object[] actualArgs = new Object[]{wsdlLocation, serviceName};
                            Class<?> clazz3 = class$2;
                            if (clazz3 == null) {
                                try {
                                    clazz3 = class$2 = Class.forName("org.apache.axis.client.Service");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            Constructor ctor = clazz3.getDeclaredConstructor(formalArgs);
                            instance = ctor.newInstance(actualArgs);
                        }
                    }
                }
            }
            addr = ref.get(MAINTAIN_SESSION);
            if (addr != null && instance instanceof Service) {
                ((Service)instance).setMaintainSession(true);
            }
        }
        return instance;
    }
}

