/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.deployment.v2dd;

import java.io.Serializable;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.deployment.DeployableItem;
import org.apache.axis.deployment.DeploymentException;
import org.apache.axis.deployment.DeploymentRegistry;
import org.apache.axis.deployment.v2dd.V2DDProvider;
import org.apache.axis.deployment.v2dd.V2DDService;
import org.apache.axis.deployment.v2dd.providers.V2DDComProvider;
import org.apache.axis.deployment.v2dd.providers.V2DDScriptProvider;
import org.apache.axis.providers.BSFProvider;
import org.apache.axis.providers.BasicProvider;
import org.apache.axis.providers.ComProvider;
import org.apache.axis.providers.java.RPCProvider;

public class V2DDDeployableItem
implements DeployableItem,
Serializable {
    V2DDService service;
    QName qname;

    public V2DDDeployableItem(V2DDService service) {
        this.service = service;
    }

    public QName getQName() {
        if (this.qname == null) {
            this.qname = new QName(null, this.service.getID());
        }
        return this.qname;
    }

    public Handler getInstance(EngineConfiguration registry) {
        try {
            V2DDProvider prov = this.service.getProvider();
            String[] methods = prov.getMethods();
            BasicProvider provider = null;
            if (prov instanceof V2DDComProvider) {
                provider = new ComProvider();
            }
            if (prov instanceof V2DDScriptProvider) {
                provider = new BSFProvider();
            }
            if (provider == null) {
                provider = new RPCProvider();
            }
            provider.setOptions(prov.getOptionsTable());
            prov.newInstance(provider);
            int n = 0;
            while (n < methods.length) {
                provider.addOperation(methods[n], new QName("http://xml.apache.org/xml-soap/deployment", methods[n]));
                ++n;
            }
            return provider;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void deployToRegistry(DeploymentRegistry registry) throws DeploymentException {
    }
}

