/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.deployment.wsdd;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.ConfigurationException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.deployment.DeployableItem;
import org.apache.axis.deployment.wsdd.WSDDConstants;
import org.apache.axis.deployment.wsdd.WSDDElement;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.utils.LockableHashtable;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public abstract class WSDDDeployableItem
extends WSDDElement
implements DeployableItem {
    public static final int SCOPE_PER_ACCESS = 0;
    public static final int SCOPE_PER_REQUEST = 1;
    public static final int SCOPE_SINGLETON = 2;
    public static String[] scopeStrings = new String[]{"per-access", "per-request", "singleton"};
    LockableHashtable parameters;
    QName qname;
    QName type;
    int scope = 2;
    Handler singletonInstance = null;

    public WSDDDeployableItem() {
    }

    public WSDDDeployableItem(Element e) throws WSDDException {
        super(e);
        String scopeStr;
        String typeStr;
        String name = e.getAttribute("name");
        if (name != null && !name.equals("")) {
            this.qname = new QName("", name);
        }
        if ((typeStr = e.getAttribute("type")) != null && !typeStr.equals("")) {
            this.type = XMLUtils.getQNameFromString(typeStr, e);
        }
        if ((scopeStr = e.getAttribute("scope")) != null) {
            int i = 0;
            while (i < scopeStrings.length) {
                if (scopeStr.equals(scopeStrings[i])) {
                    this.scope = i;
                    break;
                }
                ++i;
            }
        }
        if (this.parameters == null) {
            this.parameters = new LockableHashtable();
        }
        Element[] paramElements = this.getChildElements(e, "parameter");
        int i = 0;
        while (i < paramElements.length) {
            Element param = paramElements[i];
            String pname = param.getAttribute("name");
            String value = param.getAttribute("value");
            String locked = param.getAttribute("locked");
            this.parameters.put(pname, value, locked != null && locked.equalsIgnoreCase("true"));
            ++i;
        }
    }

    public void setName(String name) {
        this.qname = new QName(null, name);
    }

    public void setQName(QName qname) {
        this.qname = qname;
    }

    public QName getQName() {
        return this.qname;
    }

    public QName getType() {
        return this.type;
    }

    public void setType(QName type) {
        this.type = type;
    }

    public void setParameter(String name, String value) {
        if (this.parameters == null) {
            this.parameters = new LockableHashtable();
        }
        this.parameters.put(name, value);
    }

    public String getParameter(String name) {
        if (name == null) {
            return null;
        }
        return (String)this.parameters.get(name);
    }

    public LockableHashtable getParametersTable() {
        return this.parameters;
    }

    public void setOptionsHashtable(Hashtable hashtable) {
        if (hashtable == null) {
            return;
        }
        this.parameters = new LockableHashtable((Map)hashtable);
    }

    public void writeParamsToContext(SerializationContext context) throws IOException {
        if (this.parameters == null) {
            return;
        }
        Set keys = this.parameters.keySet();
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "name", "name", "CDATA", name);
            attrs.addAttribute("", "value", "value", "CDATA", this.parameters.get(name).toString());
            if (this.parameters.isKeyLocked(name)) {
                attrs.addAttribute("", "locked", "locked", "CDATA", "true");
            }
            context.startElement(WSDDConstants.PARAM_QNAME, attrs);
            context.endElement();
        }
    }

    public void removeParameter(String name) {
        this.parameters.remove(name);
    }

    public final Handler getInstance(EngineConfiguration registry) throws ConfigurationException {
        if (this.scope == 2) {
            WSDDDeployableItem wSDDDeployableItem = this;
            synchronized (wSDDDeployableItem) {
                if (this.singletonInstance == null) {
                    this.singletonInstance = this.makeNewInstance(registry);
                }
            }
            return this.singletonInstance;
        }
        return this.makeNewInstance(registry);
    }

    protected Handler makeNewInstance(EngineConfiguration registry) throws ConfigurationException {
        Class c = null;
        Handler h = null;
        try {
            c = this.getJavaClass();
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException(e);
        }
        if (c != null) {
            try {
                h = (Handler)this.createInstance(c);
            }
            catch (Exception e) {
                throw new ConfigurationException(e);
            }
            if (h != null) {
                if (this.qname != null) {
                    h.setName(this.qname.getLocalPart());
                }
                h.setOptions(this.getParametersTable());
                h.init();
            }
        } else {
            h = registry.getHandler(this.getType());
        }
        return h;
    }

    Object createInstance(Class _class) throws InstantiationException, IllegalAccessException {
        return _class.newInstance();
    }

    public Class getJavaClass() throws ClassNotFoundException {
        QName type = this.getType();
        if (type != null && "http://xml.apache.org/axis/wsdd/providers/java".equals(type.getNamespaceURI())) {
            return Class.forName(type.getLocalPart());
        }
        return null;
    }
}

