/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.deployment.wsdd;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import org.apache.axis.deployment.DeploymentException;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.deployment.wsdd.WSDDUndeployment;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.SerializationContextImpl;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class WSDDDocument {
    protected static Log log;
    private Document doc;
    private WSDDDeployment deployment;
    private WSDDUndeployment undeployment;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.deployment.wsdd.WSDDDocument");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
    }

    public WSDDDocument() {
    }

    public WSDDDocument(Document doc) throws WSDDException {
        this.doc = doc;
        Element docEl = doc.getDocumentElement();
        if ("undeployment".equals(docEl.getLocalName())) {
            this.undeployment = new WSDDUndeployment(docEl);
        } else {
            this.deployment = new WSDDDeployment(docEl);
        }
    }

    public WSDDDocument(Element e) throws WSDDException {
        this.doc = e.getOwnerDocument();
        if ("undeployment".equals(e.getLocalName())) {
            this.undeployment = new WSDDUndeployment(e);
        } else {
            this.deployment = new WSDDDeployment(e);
        }
    }

    public WSDDDeployment getDeployment() {
        if (this.deployment == null) {
            this.deployment = new WSDDDeployment();
        }
        return this.deployment;
    }

    public Document getDOMDocument() throws DeploymentException {
        StringWriter writer = new StringWriter();
        SerializationContextImpl context = new SerializationContextImpl(writer, null);
        context.setPretty(true);
        try {
            this.deployment.writeToContext(context);
        }
        catch (Exception e) {
            log.error((Object)JavaUtils.getMessage("exception00"), (Throwable)e);
        }
        try {
            writer.close();
            return XMLUtils.newDocument(new InputSource(new StringReader(writer.getBuffer().toString())));
        }
        catch (IOException e) {
            return null;
        }
    }

    public void writeToContext(SerializationContext context) throws IOException {
        this.getDeployment().writeToContext(context);
    }

    public void setDocument(Document document) {
        this.doc = document;
        this.deployment = null;
    }

    public void deploy(WSDDDeployment registry) throws DeploymentException {
        if (this.deployment != null) {
            this.deployment.deployToRegistry(registry);
        }
        if (this.undeployment != null) {
            this.undeployment.undeployFromRegistry(registry);
        }
    }
}

