/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.deployment.wsdd;

import java.io.IOException;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.deployment.wsdd.WSDDConstants;
import org.apache.axis.deployment.wsdd.WSDDElement;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public class WSDDOperation
extends WSDDElement {
    OperationDesc desc = new OperationDesc();

    public WSDDOperation(Element e, ServiceDesc parent) throws WSDDException {
        super(e);
        this.desc.setName(e.getAttribute("name"));
        String retQNameStr = e.getAttribute("returnQName");
        if (retQNameStr != null && !retQNameStr.equals("")) {
            this.desc.setReturnQName(XMLUtils.getQNameFromString(retQNameStr, e));
        }
        if (parent.getStyle() == 1) {
            Element[] mappingElements = this.getChildElements(e, "elementMapping");
            if (mappingElements.length > 1) {
                throw new WSDDException(JavaUtils.getMessage("onlyOneMapping"));
            }
            Element el = mappingElements[0];
            String elString = el.getAttribute("qname");
            QName elQName = XMLUtils.getQNameFromString(elString, el);
            this.desc.setElementQName(elQName);
        }
    }

    public void writeToContext(SerializationContext context) throws IOException {
        AttributesImpl attrs = new AttributesImpl();
        if (this.desc.getReturnQName() != null) {
            attrs.addAttribute("", "returnQName", "returnQName", "CDATA", context.qName2String(this.desc.getReturnQName()));
        }
        if (this.desc.getName() != null) {
            attrs.addAttribute("", "name", "name", "CDATA", this.desc.getName());
        }
        context.startElement(this.getElementName(), attrs);
        if (this.desc.getElementQName() != null) {
            attrs = new AttributesImpl();
            attrs.addAttribute("", "qname", "qname", "CDATA", context.qName2String(this.desc.getElementQName()));
            context.startElement(WSDDConstants.ELEMENTMAP_QNAME, attrs);
            context.endElement();
        }
        context.endElement();
    }

    protected QName getElementName() {
        return WSDDConstants.OPERATION_QNAME;
    }

    public OperationDesc getOperationDesc() {
        return this.desc;
    }
}

