/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.deployment.wsdd;

import java.io.IOException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.ConfigurationException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.FaultableHandler;
import org.apache.axis.Handler;
import org.apache.axis.MessageContext;
import org.apache.axis.deployment.wsdd.WSDDBeanMapping;
import org.apache.axis.deployment.wsdd.WSDDConstants;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.deployment.wsdd.WSDDFaultFlow;
import org.apache.axis.deployment.wsdd.WSDDOperation;
import org.apache.axis.deployment.wsdd.WSDDProvider;
import org.apache.axis.deployment.wsdd.WSDDRequestFlow;
import org.apache.axis.deployment.wsdd.WSDDResponseFlow;
import org.apache.axis.deployment.wsdd.WSDDTargetedChain;
import org.apache.axis.deployment.wsdd.WSDDTypeMapping;
import org.apache.axis.deployment.wsdd.WSDDTypeMappingContainer;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.encoding.DeserializerFactory;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.SerializerFactory;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.encoding.TypeMappingRegistryImpl;
import org.apache.axis.encoding.ser.BaseDeserializerFactory;
import org.apache.axis.encoding.ser.BaseSerializerFactory;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public class WSDDService
extends WSDDTargetedChain
implements WSDDTypeMappingContainer {
    public TypeMappingRegistry tmr = null;
    private Vector faultFlows = new Vector();
    private Vector typeMappings = new Vector();
    private Vector operations = new Vector();
    private Vector namespaces = new Vector();
    private String descriptionURL;
    private int style = 0;
    private SOAPService cachedService = null;
    private QName providerQName;
    ServiceDesc desc = new ServiceDesc();

    public WSDDService() {
    }

    public WSDDService(Element e) throws WSDDException {
        super(e);
        String modeStr = e.getAttribute("style");
        if (modeStr != null && !modeStr.equals("")) {
            this.desc.setStyle(MessageContext.getStyleFromString(modeStr));
        }
        Element[] operationElements = this.getChildElements(e, "operation");
        int i = 0;
        while (i < operationElements.length) {
            WSDDOperation operation = new WSDDOperation(operationElements[i], this.desc);
            this.operations.add(operation);
            ++i;
        }
        Element[] typeMappingElements = this.getChildElements(e, "typeMapping");
        int i2 = 0;
        while (i2 < typeMappingElements.length) {
            WSDDTypeMapping mapping = new WSDDTypeMapping(typeMappingElements[i2]);
            this.typeMappings.add(mapping);
            ++i2;
        }
        Element[] beanMappingElements = this.getChildElements(e, "beanMapping");
        int i3 = 0;
        while (i3 < beanMappingElements.length) {
            WSDDBeanMapping mapping = new WSDDBeanMapping(beanMappingElements[i3]);
            this.typeMappings.add(mapping);
            ++i3;
        }
        Element[] namespaceElements = this.getChildElements(e, "namespace");
        int i4 = 0;
        while (i4 < namespaceElements.length) {
            String ns = XMLUtils.getChildCharacterData(namespaceElements[i4]);
            this.namespaces.add(ns);
            ++i4;
        }
        String typeStr = e.getAttribute("provider");
        if (typeStr != null && !typeStr.equals("")) {
            this.providerQName = XMLUtils.getQNameFromString(typeStr, e);
        }
    }

    public void addTypeMapping(WSDDTypeMapping mapping) {
        this.typeMappings.add(mapping);
    }

    protected QName getElementName() {
        return WSDDConstants.SERVICE_QNAME;
    }

    public String getServiceDescriptionURL() {
        return this.descriptionURL;
    }

    public void setServiceDescriptionURL(String sdUrl) {
        this.descriptionURL = sdUrl;
    }

    public QName getProviderQName() {
        return this.providerQName;
    }

    public void setProviderQName(QName providerQName) {
        this.providerQName = providerQName;
    }

    public int getStyle() {
        return this.style;
    }

    public ServiceDesc getServiceDesc() {
        return this.desc;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public WSDDFaultFlow[] getFaultFlows() {
        WSDDFaultFlow[] t = new WSDDFaultFlow[this.faultFlows.size()];
        this.faultFlows.toArray(t);
        return t;
    }

    public Vector getNamespaces() {
        return this.namespaces;
    }

    public WSDDFaultFlow getFaultFlow(QName name) {
        WSDDFaultFlow[] t = this.getFaultFlows();
        int n = 0;
        while (n < t.length) {
            if (t[n].getQName().equals(name)) {
                return t[n];
            }
            ++n;
        }
        return null;
    }

    public Handler makeNewInstance(EngineConfiguration registry) throws ConfigurationException {
        if (this.cachedService != null) {
            return this.cachedService;
        }
        Handler reqHandler = null;
        WSDDRequestFlow request = this.getRequestFlow();
        if (request != null) {
            reqHandler = request.getInstance(registry);
        }
        Handler providerHandler = null;
        if (this.providerQName != null) {
            try {
                providerHandler = WSDDProvider.getInstance(this.providerQName, this, registry);
            }
            catch (Exception e) {
                throw new ConfigurationException(e);
            }
            if (providerHandler == null) {
                throw new WSDDException(JavaUtils.getMessage("couldntConstructProvider00"));
            }
        }
        Handler respHandler = null;
        WSDDResponseFlow response = this.getResponseFlow();
        if (response != null) {
            respHandler = response.getInstance(registry);
        }
        SOAPService service = new SOAPService(reqHandler, providerHandler, respHandler);
        service.setStyle(this.style);
        if (this.getQName() != null) {
            service.setName(this.getQName().getLocalPart());
        }
        service.setOptions(this.getParametersTable());
        if (this.tmr == null) {
            this.tmr = new TypeMappingRegistryImpl();
        }
        int i = 0;
        while (i < this.typeMappings.size()) {
            this.deployTypeMapping((WSDDTypeMapping)this.typeMappings.get(i));
            ++i;
        }
        service.setTypeMappingRegistry(this.tmr);
        this.tmr.delegate(registry.getTypeMappingRegistry());
        WSDDFaultFlow[] faultFlows = this.getFaultFlows();
        if (faultFlows != null && faultFlows.length > 0) {
            FaultableHandler wrapper = new FaultableHandler(service);
            int i2 = 0;
            while (i2 < faultFlows.length) {
                WSDDFaultFlow flow = faultFlows[i2];
                Handler faultHandler = flow.getInstance(registry);
                wrapper.setOption("fault-" + flow.getQName().getLocalPart(), faultHandler);
                ++i2;
            }
        }
        Iterator i3 = ((AbstractList)this.operations).iterator();
        while (i3.hasNext()) {
            OperationDesc operationDesc = ((WSDDOperation)i3.next()).getOperationDesc();
            this.desc.addOperationDesc(operationDesc);
        }
        service.setServiceDescription(this.desc);
        this.cachedService = service;
        return service;
    }

    public void deployTypeMapping(WSDDTypeMapping mapping) throws WSDDException {
        if (!this.typeMappings.contains(mapping)) {
            this.typeMappings.add(mapping);
        }
        if (this.tmr == null) {
            this.tmr = new TypeMappingRegistryImpl();
        }
        try {
            String encodingStyle = mapping.getEncodingStyle();
            if (encodingStyle == null) {
                encodingStyle = this.style == 0 ? "http://schemas.xmlsoap.org/soap/encoding/" : "";
            }
            TypeMapping tm = (TypeMapping)this.tmr.getTypeMapping(encodingStyle);
            TypeMapping df = (TypeMapping)this.tmr.getDefaultTypeMapping();
            if (tm == null || tm == df) {
                tm = (TypeMapping)this.tmr.createTypeMapping();
                tm.setSupportedNamespaces(new String[]{encodingStyle});
                this.tmr.register(encodingStyle, tm);
            }
            SerializerFactory ser = null;
            DeserializerFactory deser = null;
            if (mapping.getSerializerName() != null && !mapping.getSerializerName().equals("")) {
                ser = BaseSerializerFactory.createFactory(mapping.getSerializer(), mapping.getLanguageSpecificType(), mapping.getQName());
            }
            if (mapping.getDeserializerName() != null && !mapping.getDeserializerName().equals("")) {
                deser = BaseDeserializerFactory.createFactory(mapping.getDeserializer(), mapping.getLanguageSpecificType(), mapping.getQName());
            }
            tm.register(mapping.getLanguageSpecificType(), mapping.getQName(), ser, deser);
        }
        catch (ClassNotFoundException e) {
            throw new WSDDException(e);
        }
        catch (Exception e) {
            throw new WSDDException(e);
        }
    }

    public void writeToContext(SerializationContext context) throws IOException {
        AttributesImpl attrs = new AttributesImpl();
        QName name = this.getQName();
        if (name != null) {
            attrs.addAttribute("", "name", "name", "CDATA", context.qName2String(name));
        }
        if (this.providerQName != null) {
            attrs.addAttribute("", "provider", "provider", "CDATA", context.qName2String(this.providerQName));
        }
        if (this.style == 1) {
            attrs.addAttribute("", "style", "style", "CDATA", "document");
        }
        context.startElement(WSDDConstants.SERVICE_QNAME, attrs);
        int i = 0;
        while (i < this.operations.size()) {
            WSDDOperation operation = (WSDDOperation)this.operations.elementAt(i);
            operation.writeToContext(context);
            ++i;
        }
        this.writeFlowsToContext(context);
        this.writeParamsToContext(context);
        i = 0;
        while (i < this.typeMappings.size()) {
            ((WSDDTypeMapping)this.typeMappings.elementAt(i)).writeToContext(context);
            ++i;
        }
        i = 0;
        while (i < this.namespaces.size()) {
            context.startElement(new QName("", "namespace"), null);
            context.writeString((String)this.namespaces.get(i));
            context.endElement();
            ++i;
        }
        context.endElement();
    }

    public void setCachedService(SOAPService service) {
        this.cachedService = service;
    }

    public void deployToRegistry(WSDDDeployment registry) {
        registry.addService(this);
        registry.registerNamespaceForService(this.getQName().getLocalPart(), this);
        int i = 0;
        while (i < this.namespaces.size()) {
            String namespace = (String)this.namespaces.elementAt(i);
            registry.registerNamespaceForService(namespace, this);
            ++i;
        }
        super.deployToRegistry(registry);
    }

    public void removeNamespaceMappings(WSDDDeployment registry) {
        int i = 0;
        while (i < this.namespaces.size()) {
            String namespace = (String)this.namespaces.elementAt(i);
            registry.removeNamespaceMapping(namespace);
            ++i;
        }
    }
}

