/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.description;

import java.lang.reflect.Method;
import java.util.HashMap;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.description.FieldDesc;
import org.apache.axis.encoding.ser.BeanSerializer;

public class TypeDesc {
    public static Class[] noClasses = new Class[0];
    private FieldDesc[] fields;
    private HashMap fieldNameMap = new HashMap();
    private boolean _hasAttributes = false;

    public static TypeDesc getTypeDescForClass(Class cls) {
        try {
            Method getTypeDesc = cls.getMethod("getTypeDesc", noClasses);
            if (getTypeDesc != null) {
                return (TypeDesc)getTypeDesc.invoke(null, BeanSerializer.noArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public FieldDesc[] getFields() {
        return this.fields;
    }

    public void setFields(FieldDesc[] newFields) {
        this.fieldNameMap = new HashMap();
        this.fields = newFields;
        this._hasAttributes = false;
        int i = 0;
        while (i < newFields.length) {
            FieldDesc field = newFields[i];
            if (field.isElement()) {
                this.fieldNameMap.put(field.getFieldName(), field);
            } else {
                this._hasAttributes = true;
            }
            ++i;
        }
    }

    public void addFieldDesc(FieldDesc field) {
        if (field == null) {
            throw new NullPointerException();
        }
        int numFields = 0;
        if (this.fields != null) {
            numFields = this.fields.length;
        }
        FieldDesc[] newFields = new FieldDesc[numFields + 1];
        if (this.fields != null) {
            System.arraycopy(this.fields, 0, newFields, 0, numFields);
        }
        newFields[numFields] = field;
        this.fields = newFields;
        this.fieldNameMap.put(field.getFieldName(), field);
        if (!this._hasAttributes && !field.isElement()) {
            this._hasAttributes = true;
        }
    }

    public QName getElementNameForField(String fieldName) {
        FieldDesc desc = (FieldDesc)this.fieldNameMap.get(fieldName);
        if (desc == null || !desc.isElement()) {
            return null;
        }
        return desc.getXmlName();
    }

    public QName getAttributeNameForField(String fieldName) {
        FieldDesc desc = (FieldDesc)this.fieldNameMap.get(fieldName);
        if (desc == null || desc.isElement()) {
            return null;
        }
        QName ret = desc.getXmlName();
        if (ret == null) {
            ret = new QName("", fieldName);
        }
        return ret;
    }

    public String getFieldNameForElement(QName qname) {
        if (this.fields == null) {
            return null;
        }
        int i = 0;
        while (i < this.fields.length) {
            FieldDesc field = this.fields[i];
            if (field.isElement() && qname.equals(field.getXmlName())) {
                return field.getFieldName();
            }
            ++i;
        }
        return null;
    }

    public String getFieldNameForAttribute(QName qname) {
        if (this.fields == null) {
            return null;
        }
        String possibleMatch = null;
        int i = 0;
        while (i < this.fields.length) {
            FieldDesc field = this.fields[i];
            if (!field.isElement()) {
                if (qname.equals(field.getXmlName())) {
                    return field.getFieldName();
                }
                if (qname.getNamespaceURI().equals("") && qname.getLocalPart().equals(field.getFieldName())) {
                    possibleMatch = field.getFieldName();
                }
            }
            ++i;
        }
        return possibleMatch;
    }

    public FieldDesc getFieldByName(String name) {
        return (FieldDesc)this.fieldNameMap.get(name);
    }

    public boolean hasAttributes() {
        return this._hasAttributes;
    }
}

