/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.attachments.Attachments;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.DeserializerFactory;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.message.EnvelopeBuilder;
import org.apache.axis.message.EnvelopeHandler;
import org.apache.axis.message.HandlerFactory;
import org.apache.axis.message.IDResolver;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SAX2EventRecorder;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.NSStack;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DeserializationContextImpl
extends DefaultHandler
implements DeserializationContext {
    protected static Log log;
    private NSStack namespaces = new NSStack();
    private Locator locator;
    private Stack handlerStack = new Stack();
    private SAX2EventRecorder recorder = new SAX2EventRecorder();
    private SOAPEnvelope envelope;
    private HashMap idMap;
    private LocalIDResolver localIDs;
    private HashMap fixups;
    static final SOAPHandler nullHandler;
    protected MessageContext msgContext;
    protected HandlerFactory initialFactory;
    private boolean doneParsing = false;
    protected InputSource inputSource = null;
    private MessageElement curElement;
    protected int startOfMappingsPos = -1;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.encoding.DeserializationContextImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        nullHandler = new SOAPHandler();
    }

    public DeserializationContextImpl(MessageContext ctx, EnvelopeBuilder initialHandler) {
        this.msgContext = ctx;
        this.envelope = initialHandler.getEnvelope();
        this.envelope.setRecorder(this.recorder);
        this.pushElementHandler(new EnvelopeHandler(initialHandler));
    }

    public DeserializationContextImpl(InputSource is, MessageContext ctx, String messageType) {
        EnvelopeBuilder builder = new EnvelopeBuilder(messageType);
        this.msgContext = ctx;
        this.envelope = builder.getEnvelope();
        this.envelope.setRecorder(this.recorder);
        this.pushElementHandler(new EnvelopeHandler(builder));
        this.inputSource = is;
    }

    public DeserializationContextImpl(InputSource is, MessageContext ctx, String messageType, SOAPEnvelope env) {
        EnvelopeBuilder builder = new EnvelopeBuilder(env, messageType);
        this.msgContext = ctx;
        this.envelope = builder.getEnvelope();
        this.envelope.setRecorder(this.recorder);
        this.pushElementHandler(new EnvelopeHandler(builder));
        this.inputSource = is;
    }

    public void parse() throws SAXException {
        if (this.inputSource != null) {
            SAXParser parser = XMLUtils.getSAXParser();
            try {
                parser.parse(this.inputSource, (DefaultHandler)this);
                XMLUtils.releaseSAXParser(parser);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
            this.inputSource = null;
        }
    }

    public MessageElement getCurElement() {
        return this.curElement;
    }

    public void setCurElement(MessageElement el) {
        this.curElement = el;
    }

    public MessageContext getMessageContext() {
        return this.msgContext;
    }

    public SOAPEnvelope getEnvelope() {
        return this.envelope;
    }

    public SAX2EventRecorder getRecorder() {
        return this.recorder;
    }

    public void setRecorder(SAX2EventRecorder recorder) {
        this.recorder = recorder;
    }

    public ArrayList getCurrentNSMappings() {
        return (ArrayList)this.namespaces.peek().clone();
    }

    public String getNamespaceURI(String prefix) {
        if (this.curElement != null) {
            return this.curElement.getNamespaceURI(prefix);
        }
        return this.namespaces.getNamespaceURI(prefix);
    }

    public QName getQNameFromString(String qNameStr) {
        if (qNameStr == null) {
            return null;
        }
        int i = qNameStr.indexOf(58);
        if (i == -1) {
            return null;
        }
        String nsURI = this.getNamespaceURI(qNameStr.substring(0, i));
        if (nsURI == null) {
            return null;
        }
        return new QName(nsURI, qNameStr.substring(i + 1));
    }

    public QName getTypeFromAttributes(String namespace, String localName, Attributes attrs) {
        QName typeQName = null;
        String type = Constants.getValue(attrs, "http://www.w3.org/2001/XMLSchema-instance", "type");
        if (type != null) {
            return this.getQNameFromString(type);
        }
        if (typeQName == null) {
            QName myQName = new QName(namespace, localName);
            if ("http://schemas.xmlsoap.org/soap/encoding/".equals("http://www.w3.org/2001/06/soap-encoding") && Constants.isSOAP_ENC(namespace)) {
                typeQName = myQName;
            } else if (myQName.equals(Constants.SOAP_ARRAY)) {
                typeQName = Constants.SOAP_ARRAY;
            } else if (myQName.equals(Constants.SOAP_STRING)) {
                typeQName = Constants.SOAP_STRING;
            } else if (myQName.equals(Constants.SOAP_BOOLEAN)) {
                typeQName = Constants.SOAP_BOOLEAN;
            } else if (myQName.equals(Constants.SOAP_DOUBLE)) {
                typeQName = Constants.SOAP_DOUBLE;
            } else if (myQName.equals(Constants.SOAP_FLOAT)) {
                typeQName = Constants.SOAP_FLOAT;
            } else if (myQName.equals(Constants.SOAP_INT)) {
                typeQName = Constants.SOAP_INT;
            } else if (myQName.equals(Constants.SOAP_LONG)) {
                typeQName = Constants.SOAP_LONG;
            } else if (myQName.equals(Constants.SOAP_SHORT)) {
                typeQName = Constants.SOAP_SHORT;
            } else if (myQName.equals(Constants.SOAP_BYTE)) {
                typeQName = Constants.SOAP_BYTE;
            }
        }
        if (typeQName != null) {
            return typeQName;
        }
        return null;
    }

    public boolean isNil(Attributes attrs) {
        if (attrs == null) {
            return false;
        }
        String nil = Constants.getValue(attrs, "http://www.w3.org/2001/XMLSchema-instance", "nil");
        return nil != null && nil.equals("true");
    }

    public final Deserializer getDeserializerForType(QName xmlType) {
        if (xmlType == null) {
            return null;
        }
        DeserializerFactory dserF = null;
        Deserializer dser = null;
        try {
            dserF = (DeserializerFactory)this.getTypeMapping().getDeserializer(xmlType);
        }
        catch (JAXRPCException e) {
            log.error((Object)JavaUtils.getMessage("noFactory00", xmlType.toString()));
        }
        if (dserF != null) {
            try {
                dser = (Deserializer)dserF.getDeserializerAs("Axis SAX Mechanism");
            }
            catch (JAXRPCException e) {
                log.error((Object)JavaUtils.getMessage("noDeser00", xmlType.toString()));
            }
        }
        return dser;
    }

    public TypeMapping getTypeMapping() {
        TypeMappingRegistry tmr = this.msgContext.getTypeMappingRegistry();
        return (TypeMapping)tmr.getTypeMapping(this.msgContext.getEncodingStyle());
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        return this.msgContext.getTypeMappingRegistry();
    }

    public MessageElement getElementByID(String id) {
        Object ret;
        IDResolver resolver;
        if (this.idMap != null && (resolver = (IDResolver)this.idMap.get(id)) != null && (ret = resolver.getReferencedObject(id)) instanceof MessageElement) {
            return (MessageElement)ret;
        }
        return null;
    }

    public Object getObjectByRef(String href) {
        Object ret = null;
        if (href != null) {
            IDResolver resolver;
            if (this.idMap != null && (resolver = (IDResolver)this.idMap.get(href)) != null) {
                ret = resolver.getReferencedObject(href);
            }
            if (ret == null && !href.startsWith("#")) {
                Message msg = null;
                msg = this.msgContext.getCurrentMessage();
                if (msg != null) {
                    Attachments attch = null;
                    attch = msg.getAttachments();
                    if (attch != null) {
                        try {
                            ret = attch.getAttachmentByReference(href);
                        }
                        catch (AxisFault axisFault) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return ret;
    }

    public void addObjectById(String _id, Object obj) {
        String id = "#" + _id;
        if (this.idMap == null || id == null) {
            return;
        }
        IDResolver resolver = (IDResolver)this.idMap.get(id);
        if (resolver == null) {
            return;
        }
        resolver.addReferencedObject(id, obj);
    }

    public void registerFixup(String href, Deserializer dser) {
        Deserializer prev;
        if (this.fixups == null) {
            this.fixups = new HashMap();
        }
        if ((prev = this.fixups.put(href, dser)) != null && prev != dser) {
            dser.moveValueTargets(prev);
            if (dser.getDefaultType() == null) {
                dser.setDefaultType(prev.getDefaultType());
            }
        }
    }

    public void registerElementByID(String id, MessageElement elem) {
        Deserializer dser;
        if (this.localIDs == null) {
            this.localIDs = new LocalIDResolver();
        }
        String absID = "#" + id;
        this.localIDs.addReferencedObject(absID, elem);
        this.registerResolverForID(absID, this.localIDs);
        if (this.fixups != null && (dser = (Deserializer)this.fixups.get(absID)) != null) {
            elem.setFixupDeserializer(dser);
        }
    }

    public void registerResolverForID(String id, IDResolver resolver) {
        if (id == null || resolver == null) {
            return;
        }
        if (this.idMap == null) {
            this.idMap = new HashMap();
        }
        this.idMap.put(id, resolver);
    }

    public int getCurrentRecordPos() {
        if (this.recorder == null) {
            return -1;
        }
        return this.recorder.getLength() - 1;
    }

    public int getStartOfMappingsPos() {
        if (this.startOfMappingsPos == -1) {
            return this.getCurrentRecordPos() + 1;
        }
        return this.startOfMappingsPos;
    }

    public void pushNewElement(MessageElement elem) {
        if (this.recorder != null) {
            this.recorder.newElement(elem);
        }
        try {
            elem.setParent(this.curElement);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.curElement = elem;
    }

    public SOAPHandler getTopHandler() {
        try {
            return (SOAPHandler)this.handlerStack.peek();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void pushElementHandler(SOAPHandler handler) {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("pushHandler00", "" + handler));
        }
        this.handlerStack.push(handler);
    }

    public void replaceElementHandler(SOAPHandler handler) {
        this.handlerStack.pop();
        this.handlerStack.push(handler);
    }

    public SOAPHandler popElementHandler() {
        if (!this.handlerStack.empty()) {
            SOAPHandler handler = this.getTopHandler();
            if (log.isDebugEnabled()) {
                log.debug((Object)JavaUtils.getMessage("popHandler00", "" + handler));
            }
            this.handlerStack.pop();
            return handler;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("popHandler00", "(null)"));
        }
        return null;
    }

    public void startDocument() throws SAXException {
        if (this.recorder != null) {
            this.recorder.startDocument();
        }
    }

    public void endDocument() throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("endDoc00"));
        }
        if (this.recorder != null) {
            this.recorder.endDocument();
        }
        this.doneParsing = true;
    }

    public boolean isDoneParsing() {
        return this.doneParsing;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        SOAPHandler handler;
        if (this.recorder != null) {
            this.recorder.startPrefixMapping(prefix, uri);
        }
        if (this.startOfMappingsPos == -1) {
            this.startOfMappingsPos = this.getCurrentRecordPos();
        }
        if (prefix != null) {
            this.namespaces.add(uri, prefix);
        } else {
            this.namespaces.add(uri, "");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("startPrefix00", prefix, uri));
        }
        if ((handler = this.getTopHandler()) != null) {
            handler.startPrefixMapping(prefix, uri);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        SOAPHandler handler;
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("endPrefix00", prefix));
        }
        if (this.recorder != null) {
            this.recorder.endPrefixMapping(prefix);
        }
        if ((handler = this.getTopHandler()) != null) {
            handler.endPrefixMapping(prefix);
        }
    }

    public void setDocumentLocator(Locator locator) {
        if (this.recorder != null) {
            this.recorder.setDocumentLocator(locator);
        }
        this.locator = locator;
    }

    public void characters(char[] p1, int p2, int p3) throws SAXException {
        if (this.recorder != null) {
            this.recorder.characters(p1, p2, p3);
        }
        if (this.getTopHandler() != null) {
            this.getTopHandler().characters(p1, p2, p3);
        }
    }

    public void ignorableWhitespace(char[] p1, int p2, int p3) throws SAXException {
        if (this.recorder != null) {
            this.recorder.ignorableWhitespace(p1, p2, p3);
        }
        if (this.getTopHandler() != null) {
            this.getTopHandler().ignorableWhitespace(p1, p2, p3);
        }
    }

    public void processingInstruction(String p1, String p2) throws SAXException {
        throw new SAXException(JavaUtils.getMessage("noInstructions00"));
    }

    public void skippedEntity(String p1) throws SAXException {
        if (this.recorder != null) {
            this.recorder.skippedEntity(p1);
        }
        this.getTopHandler().skippedEntity(p1);
    }

    public void startElement(String namespace, String localName, String qName, Attributes attributes) throws SAXException {
        SOAPHandler nextHandler = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("startElem00", "['" + namespace + "' " + localName + "]"));
        }
        String prefix = "";
        int idx = qName.indexOf(":");
        if (idx > 0) {
            prefix = qName.substring(0, idx);
        }
        if (!this.handlerStack.isEmpty()) {
            nextHandler = this.getTopHandler().onStartChild(namespace, localName, prefix, attributes, this);
        }
        if (nextHandler == null) {
            nextHandler = new SOAPHandler();
        }
        this.pushElementHandler(nextHandler);
        nextHandler.startElement(namespace, localName, qName, attributes, this);
        if (this.recorder != null) {
            this.recorder.startElement(namespace, localName, qName, attributes);
            if (!this.doneParsing) {
                this.curElement.setContentsIndex(this.recorder.getLength());
            }
        }
        this.namespaces.push();
        this.startOfMappingsPos = -1;
    }

    public void endElement(String namespace, String localName, String qName) throws SAXException {
        block8: {
            if (log.isDebugEnabled()) {
                log.debug((Object)JavaUtils.getMessage("endElem00", "['" + namespace + "' " + localName + "]"));
            }
            if (this.recorder != null) {
                this.recorder.endElement(namespace, localName, qName);
            }
            try {
                SOAPHandler handler = this.popElementHandler();
                handler.endElement(namespace, localName, this);
                if (!this.handlerStack.isEmpty()) {
                    this.getTopHandler().onEndChild(namespace, localName, this);
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)JavaUtils.getMessage("endDoc01"));
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (this.curElement != null) {
                    this.curElement = this.curElement.getParent();
                }
                throw throwable;
            }
            Object var6_7 = null;
            if (this.curElement == null) break block8;
            this.curElement = this.curElement.getParent();
        }
    }

    private static class LocalIDResolver
    implements IDResolver {
        HashMap idMap = null;

        LocalIDResolver() {
        }

        public void addReferencedObject(String id, Object referent) {
            if (this.idMap == null) {
                this.idMap = new HashMap();
            }
            this.idMap.put(id, referent);
        }

        public Object getReferencedObject(String href) {
            if (this.idMap == null || href == null) {
                return null;
            }
            return this.idMap.get(href);
        }
    }
}

