/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding;

import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.Constants;
import org.apache.axis.Part;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.SerializationContextImpl;
import org.apache.axis.encoding.Target;
import org.apache.axis.message.EnvelopeHandler;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SAX2EventRecorder;
import org.apache.axis.message.SAXOutputter;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.utils.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DeserializerImpl
extends SOAPHandler
implements Deserializer {
    protected static Log log;
    protected Object value = null;
    protected boolean isEnded = false;
    protected Vector targets = null;
    protected QName defaultType = null;
    private int startIdx = 0;
    private int endIdx = -1;
    protected boolean isHref = false;
    protected boolean isNil = false;
    protected String id = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.encoding.DeserializerImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue(Object hint) {
        return null;
    }

    public void setValue(Object value, Object hint) throws SAXException {
    }

    public void setDefaultType(QName qName) {
        this.defaultType = qName;
    }

    public QName getDefaultType() {
        return this.defaultType;
    }

    public void registerValueTarget(Target target) {
        if (this.targets == null) {
            this.targets = new Vector();
        }
        this.targets.addElement(target);
    }

    public Vector getValueTargets() {
        return this.targets;
    }

    public void removeValueTargets() {
        if (this.targets != null) {
            this.targets.clear();
            this.targets = null;
        }
    }

    public void moveValueTargets(Deserializer other) {
        if (other == null || other.getValueTargets() == null) {
            return;
        }
        if (this.targets == null) {
            this.targets = new Vector();
        }
        Enumeration e = other.getValueTargets().elements();
        while (e.hasMoreElements()) {
            this.targets.addElement(e.nextElement());
        }
        other.removeValueTargets();
    }

    public boolean componentsReady() {
        return true;
    }

    public void valueComplete() throws SAXException {
        if (this.componentsReady() && this.targets != null) {
            Enumeration e = this.targets.elements();
            while (e.hasMoreElements()) {
                Target target = (Target)e.nextElement();
                target.set(this.value);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)JavaUtils.getMessage("setValueInTarget00", "" + this.value, "" + target));
            }
            this.removeValueTargets();
        }
    }

    public void startElement(String namespace, String localName, String qName, Attributes attributes, DeserializationContext context) throws SAXException {
        String href;
        String nil = Constants.getValue(attributes, "http://www.w3.org/2001/XMLSchema-instance", "nil");
        if (nil != null && nil.equals("true")) {
            this.value = null;
            this.isNil = true;
            return;
        }
        this.id = attributes.getValue("id");
        if (this.id != null) {
            context.addObjectById(this.id, this.value);
            if (log.isDebugEnabled()) {
                log.debug((Object)JavaUtils.getMessage("deserInitPutValueDebug00", "" + this.value, this.id));
            }
            context.registerFixup("#" + this.id, this);
        }
        if ((href = attributes.getValue("href")) != null) {
            this.isHref = true;
            Object ref = context.getObjectByRef(href);
            if (log.isDebugEnabled()) {
                log.debug((Object)JavaUtils.getMessage("gotForID00", new String[]{"" + ref, href, "" + ref.getClass()}));
            }
            if (ref == null) {
                context.registerFixup(href, this);
            }
            if (ref instanceof MessageElement) {
                context.replaceElementHandler(new EnvelopeHandler(this));
                SAX2EventRecorder r = context.getRecorder();
                context.setRecorder(null);
                ((MessageElement)ref).publishToHandler((DefaultHandler)((Object)context));
                context.setRecorder(r);
            } else {
                Deserializer dser;
                if (!href.startsWith("#") && this.defaultType != null && ref instanceof Part && (dser = context.getDeserializerForType(this.defaultType)) != null) {
                    dser.startElement(namespace, localName, qName, attributes, context);
                    ref = dser.getValue();
                }
                this.value = ref;
                this.valueComplete();
            }
        } else {
            this.isHref = false;
            this.onStartElement(namespace, localName, qName, attributes, context);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onStartElement(String namespace, String localName, String qName, Attributes attributes, DeserializationContext context) throws SAXException {
        Class<?> clazz = this.getClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.apache.axis.encoding.DeserializerImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.equals(clazz2)) return;
        QName type = context.getTypeFromAttributes(namespace, localName, attributes);
        if (type == null && (type = this.defaultType) == null) {
            type = Constants.XSD_STRING;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("gotType00", "Deser", "" + type));
        }
        if (type != null) {
            Deserializer dser = context.getDeserializerForType(type);
            if (dser == null) throw new SAXException(JavaUtils.getMessage("noDeser00", "" + type));
            dser.moveValueTargets(this);
            context.replaceElementHandler((SOAPHandler)((Object)dser));
            dser.startElement(namespace, localName, qName, attributes, context);
            return;
        } else {
            this.startIdx = context.getCurrentRecordPos();
        }
    }

    public SOAPHandler onStartChild(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        return null;
    }

    public final void endElement(String namespace, String localName, DeserializationContext context) throws SAXException {
        this.isEnded = true;
        if (!this.isHref) {
            this.onEndElement(namespace, localName, context);
        }
        if (this.componentsReady()) {
            this.valueComplete();
        }
        if (this.id != null) {
            context.addObjectById(this.id, this.value);
            if (log.isDebugEnabled()) {
                log.debug((Object)JavaUtils.getMessage("deserPutValueDebug00", "" + this.value, this.id));
            }
        }
    }

    public void onEndElement(String namespace, String localName, DeserializationContext context) throws SAXException {
        Class<?> clazz = this.getClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.apache.axis.encoding.DeserializerImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz2) && this.targets != null && !this.targets.isEmpty()) {
            this.endIdx = context.getCurrentRecordPos();
            StringWriter writer = new StringWriter();
            SerializationContextImpl serContext = new SerializationContextImpl(writer, context.getMessageContext());
            serContext.setSendDecl(false);
            SAXOutputter so = null;
            so = new SAXOutputter(serContext);
            context.getCurElement().publishContents(so);
            if (!this.isNil) {
                this.value = writer.getBuffer().toString();
            }
        }
    }
}

