/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Stack;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.AxisEngine;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.attachments.Attachments;
import org.apache.axis.encoding.DefaultTypeMappingImpl;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.encoding.SerializerFactory;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Mapping;
import org.apache.axis.utils.NSStack;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class SerializationContextImpl
implements SerializationContext {
    protected static Log log;
    private NSStack nsStack = new NSStack();
    private boolean writingStartTag = false;
    private boolean onlyXML = true;
    private int indent = 0;
    private boolean startOfDocument = true;
    private Stack elementStack = new Stack();
    private Writer writer;
    private int lastPrefixIndex = 1;
    private MessageContext msgContext;
    private boolean pretty = false;
    private static QName multirefQName;
    private boolean doMultiRefs = false;
    private boolean sendXMLDecl = true;
    private boolean sendXSIType = true;
    private HashMap multiRefValues = null;
    private int multiRefIndex = -1;
    private HashSet secondLevelObjects = null;
    private Object forceSer = null;
    private boolean outputMultiRefsFlag = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.encoding.SerializationContextImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        multirefQName = new QName("", "multiRef");
    }

    public SerializationContextImpl(Writer writer) {
        this.writer = writer;
    }

    public SerializationContextImpl(Writer writer, MessageContext msgContext) {
        this.writer = writer;
        this.msgContext = msgContext;
        AxisEngine engine = null;
        if (msgContext != null) {
            SOAPService service;
            Boolean opt;
            Boolean shouldSendMultiRefs;
            engine = msgContext.getAxisEngine();
            Boolean shouldSendDecl = (Boolean)engine.getOption("sendXMLDeclaration");
            if (shouldSendDecl != null) {
                this.sendXMLDecl = shouldSendDecl;
            }
            if ((shouldSendMultiRefs = (Boolean)msgContext.getProperty("sendMultiRefs")) == null) {
                shouldSendMultiRefs = (Boolean)engine.getOption("sendMultiRefs");
            }
            if (shouldSendMultiRefs != null) {
                this.doMultiRefs = shouldSendMultiRefs;
            }
            if (!msgContext.isPropertyTrue("send_type_attr", true)) {
                this.sendXSIType = false;
            }
            if ((opt = (Boolean)engine.getOption("sendXsiTypes")) != null && opt.equals(Boolean.FALSE)) {
                this.sendXSIType = false;
            }
            if ((service = msgContext.getService()) != null && service.getStyle() == 1) {
                this.sendXSIType = false;
                this.doMultiRefs = false;
            }
        }
    }

    public boolean getPretty() {
        return this.pretty;
    }

    public void setPretty(boolean pretty) {
        this.pretty = pretty;
    }

    public void setDoMultiRefs(boolean shouldDo) {
        this.doMultiRefs = shouldDo;
    }

    public void setSendDecl(boolean sendDecl) {
        this.sendXMLDecl = sendDecl;
    }

    public boolean shouldSendXSIType() {
        return this.sendXSIType;
    }

    public TypeMapping getTypeMapping() {
        if (this.msgContext == null) {
            return DefaultTypeMappingImpl.create();
        }
        String encodingStyle = this.msgContext.getEncodingStyle();
        if (encodingStyle == null) {
            encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
        }
        return (TypeMapping)this.msgContext.getTypeMappingRegistry().getTypeMapping(encodingStyle);
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        if (this.msgContext == null) {
            return null;
        }
        return this.msgContext.getTypeMappingRegistry();
    }

    public String getPrefixForURI(String uri) {
        return this.getPrefixForURI(uri, null);
    }

    public String getPrefixForURI(String uri, String defaultPrefix) {
        if (uri == null || uri.equals("")) {
            return null;
        }
        String prefix = this.nsStack.getPrefix(uri);
        if (prefix == null && uri.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
            prefix = "SOAP-ENC";
            this.registerPrefixForURI(prefix, uri);
        }
        if (prefix == null) {
            prefix = defaultPrefix == null ? "ns" + this.lastPrefixIndex++ : defaultPrefix;
            this.registerPrefixForURI(prefix, uri);
        }
        return prefix;
    }

    public void registerPrefixForURI(String prefix, String uri) {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("register00", prefix, uri));
        }
        if (uri != null && prefix != null) {
            this.nsStack.add(uri, prefix);
        }
    }

    public Message getCurrentMessage() {
        if (this.msgContext == null) {
            return null;
        }
        return this.msgContext.getCurrentMessage();
    }

    public MessageContext getMessageContext() {
        return this.msgContext;
    }

    public String qName2String(QName qName) {
        String prefix = this.getPrefixForURI(qName.getNamespaceURI());
        return String.valueOf(prefix != null && !prefix.equals("") ? String.valueOf(prefix) + ":" : "") + qName.getLocalPart();
    }

    public QName getQNameForClass(Class cls) {
        return this.getTypeMapping().getTypeQName(cls);
    }

    public boolean isPrimitive(Object value, Class javaType) {
        if (value == null) {
            return true;
        }
        if (javaType.isPrimitive()) {
            return true;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(javaType)) {
            return true;
        }
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.isAssignableFrom(javaType)) {
            return true;
        }
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("org.apache.axis.encoding.Hex");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz3.isAssignableFrom(javaType)) {
            return true;
        }
        Class<?> clazz4 = class$4;
        if (clazz4 == null) {
            try {
                clazz4 = class$4 = Class.forName("org.w3c.dom.Element");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz4.isAssignableFrom(javaType)) {
            return true;
        }
        Class<?> clazz5 = class$5;
        if (clazz5 == null) {
            try {
                clazz5 = class$5 = Class.forName("[B");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz5.isAssignableFrom(javaType)) {
            return true;
        }
        if (javaType.isArray()) {
            return true;
        }
        QName qName = this.getQNameForClass(javaType);
        return qName != null && Constants.isSchemaXSD(qName.getNamespaceURI()) && (qName.equals(Constants.XSD_BOOLEAN) || qName.equals(Constants.XSD_DOUBLE) || qName.equals(Constants.XSD_FLOAT) || qName.equals(Constants.XSD_INT) || qName.equals(Constants.XSD_LONG) || qName.equals(Constants.XSD_SHORT) || qName.equals(Constants.XSD_BYTE) || qName.equals(Constants.XSD_STRING) || qName.equals(Constants.XSD_INTEGER) || qName.equals(Constants.XSD_DECIMAL));
    }

    public void serialize(QName qName, Attributes attributes, Object value, Class javaType) throws IOException {
        Attachments attachments;
        Message msg;
        if (value == null) {
            AttributesImpl attrs = new AttributesImpl();
            if (attributes != null) {
                attrs.setAttributes(attributes);
            }
            attrs.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "nil", "xsi:nil", "CDATA", "true");
            this.startElement(qName, attrs);
            this.endElement();
        }
        if ((msg = this.getCurrentMessage()) != null && (attachments = this.getCurrentMessage().getAttachments()) != null && attachments.isAttachment(value)) {
            this.serializeActual(qName, attributes, value, javaType);
            return;
        }
        if (this.doMultiRefs && value != this.forceSer && !this.isPrimitive(value, javaType)) {
            String href;
            if (this.multiRefIndex == -1) {
                this.multiRefValues = new HashMap();
            }
            if ((href = (String)this.multiRefValues.get(value)) == null) {
                ++this.multiRefIndex;
                href = "id" + this.multiRefIndex;
                this.multiRefValues.put(value, href);
                if (this.outputMultiRefsFlag) {
                    if (this.secondLevelObjects == null) {
                        this.secondLevelObjects = new HashSet();
                    }
                    this.secondLevelObjects.add(value);
                }
            }
            AttributesImpl attrs = new AttributesImpl();
            if (attributes != null) {
                attrs.setAttributes(attributes);
            }
            attrs.addAttribute("", "href", "href", "CDATA", "#" + href);
            this.startElement(qName, attrs);
            this.endElement();
            return;
        }
        if (value == this.forceSer) {
            this.forceSer = null;
        }
        this.serializeActual(qName, attributes, value, javaType);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void outputMultiRefs() throws IOException {
        if (!this.doMultiRefs || this.multiRefValues == null) {
            return;
        }
        this.outputMultiRefsFlag = true;
        attrs = new AttributesImpl();
        attrs.addAttribute("", "", "", "", "");
        prefix = this.getPrefixForURI("http://schemas.xmlsoap.org/soap/encoding/");
        root = String.valueOf(prefix) + ":root";
        attrs.addAttribute("http://schemas.xmlsoap.org/soap/encoding/", "root", root, "CDATA", "0");
        i /* !! */  = ((HashMap)this.multiRefValues.clone()).keySet().iterator();
        ** GOTO lbl21
        {
            val = i /* !! */ .next();
            id = (String)this.multiRefValues.get(val);
            attrs.setAttribute(0, "", "id", "id", "CDATA", id);
            this.forceSer = val;
            this.serialize(SerializationContextImpl.multirefQName, attrs, val, val.getClass());
            do {
                if (i /* !! */ .hasNext()) continue block0;
                if (this.secondLevelObjects == null) continue;
                i /* !! */  = this.secondLevelObjects.iterator();
                this.secondLevelObjects = null;
lbl21:
                // 3 sources

            } while (i /* !! */ .hasNext());
        }
        this.forceSer = null;
        this.outputMultiRefsFlag = false;
    }

    public void startElement(QName qName, Attributes attributes) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("startElem00", "[" + qName.getNamespaceURI() + "]:" + qName.getLocalPart()));
        }
        if (this.startOfDocument && this.sendXMLDecl) {
            this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            this.startOfDocument = false;
        }
        if (this.writingStartTag) {
            this.writer.write(">");
            if (this.pretty) {
                this.writer.write("\n");
            }
            ++this.indent;
        }
        if (this.pretty) {
            int i = 0;
            while (i < this.indent) {
                this.writer.write(32);
                ++i;
            }
        }
        String elementQName = this.qName2String(qName);
        this.writer.write("<");
        this.writer.write(elementQName);
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                String qname = attributes.getQName(i);
                this.writer.write(" ");
                String prefix = "";
                String uri = attributes.getURI(i);
                if (uri != null && !uri.equals("")) {
                    if (qname.equals("")) {
                        prefix = this.getPrefixForURI(uri);
                    } else {
                        int idx = qname.indexOf(58);
                        if (idx > -1) {
                            prefix = qname.substring(0, idx);
                            prefix = this.getPrefixForURI(uri, prefix);
                        }
                    }
                    qname = !prefix.equals("") ? String.valueOf(prefix) + ":" + attributes.getLocalName(i) : attributes.getLocalName(i);
                } else {
                    qname = attributes.getLocalName(i);
                    if (qname == null) {
                        qname = attributes.getQName(i);
                    }
                }
                this.writer.write(qname);
                this.writer.write("=\"");
                this.writer.write(XMLUtils.xmlEncodeString(attributes.getValue(i)));
                this.writer.write("\"");
                ++i;
            }
        }
        ArrayList currentMappings = this.nsStack.peek();
        int i = 0;
        while (i < currentMappings.size()) {
            Mapping map = (Mapping)currentMappings.get(i);
            this.writer.write(" xmlns");
            if (!map.getPrefix().equals("")) {
                this.writer.write(":");
                this.writer.write(map.getPrefix());
            }
            this.writer.write("=\"");
            this.writer.write(map.getNamespaceURI());
            this.writer.write("\"");
            ++i;
        }
        this.writingStartTag = true;
        this.elementStack.push(elementQName);
        this.nsStack.push();
        this.writer.flush();
        this.onlyXML = true;
    }

    public void endElement() throws IOException {
        String elementQName = (String)this.elementStack.pop();
        if (log.isDebugEnabled()) {
            log.debug((Object)JavaUtils.getMessage("endElem00", "" + elementQName));
        }
        this.nsStack.pop();
        this.nsStack.peek().clear();
        if (this.writingStartTag) {
            this.writer.write("/>");
            if (this.pretty) {
                this.writer.write("\n");
            }
            this.writingStartTag = false;
            return;
        }
        if (this.onlyXML) {
            --this.indent;
            if (this.pretty) {
                int i = 0;
                while (i < this.indent) {
                    this.writer.write(32);
                    ++i;
                }
            }
        }
        this.writer.write("</");
        this.writer.write(elementQName);
        this.writer.write(62);
        if (this.pretty && this.indent > 0) {
            this.writer.write(10);
        }
        this.writer.flush();
        this.onlyXML = true;
    }

    public void writeChars(char[] p1, int p2, int p3) throws IOException {
        if (this.writingStartTag) {
            this.writer.write(">");
            this.writingStartTag = false;
        }
        this.writeSafeString(String.valueOf(p1, p2, p3));
        this.writer.flush();
        this.onlyXML = false;
    }

    public void writeString(String string) throws IOException {
        if (this.writingStartTag) {
            this.writer.write(">");
            this.writingStartTag = false;
        }
        this.writer.write(string);
        this.writer.flush();
        this.onlyXML = false;
    }

    public void writeSafeString(String string) throws IOException {
        this.writeString(XMLUtils.xmlEncodeString(string));
    }

    public void writeDOMElement(Element el) throws IOException {
        AttributesImpl attributes = null;
        NamedNodeMap attrMap = el.getAttributes();
        if (attrMap.getLength() > 0) {
            attributes = new AttributesImpl();
            int i = 0;
            while (i < attrMap.getLength()) {
                Attr attr = (Attr)attrMap.item(i);
                String tmp = attr.getNamespaceURI();
                if (tmp != null && tmp.equals(Constants.NS_URI_XMLNS)) {
                    String prefix = attr.getLocalName();
                    if (prefix != null) {
                        if (prefix.equals("xmlns")) {
                            prefix = "";
                        }
                        String nsURI = attr.getValue();
                        this.registerPrefixForURI(prefix, nsURI);
                    }
                } else {
                    attributes.addAttribute(attr.getNamespaceURI(), attr.getLocalName(), attr.getName(), "CDATA", attr.getValue());
                }
                ++i;
            }
        }
        String namespaceURI = el.getNamespaceURI();
        String localPart = el.getLocalName();
        if (namespaceURI == null || namespaceURI.length() == 0) {
            localPart = el.getNodeName();
        }
        QName qName = new QName(namespaceURI, localPart);
        this.startElement(qName, attributes);
        NodeList children = el.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof Element) {
                this.writeDOMElement((Element)child);
            } else if (child instanceof Text) {
                this.writeSafeString(((Text)child).getData());
            }
            ++i;
        }
        this.endElement();
    }

    public final Serializer getSerializerForJavaType(Class javaType) {
        SerializerFactory serF = null;
        Serializer ser = null;
        try {
            serF = (SerializerFactory)this.getTypeMapping().getSerializer(javaType);
            if (serF != null) {
                ser = (Serializer)serF.getSerializerAs("Axis SAX Mechanism");
            }
        }
        catch (JAXRPCException jAXRPCException) {
            // empty catch block
        }
        return ser;
    }

    public Attributes setTypeAttribute(Attributes attributes, QName type) {
        if (type == null || !this.shouldSendXSIType() || attributes != null && attributes.getIndex("http://www.w3.org/2001/XMLSchema-instance", "type") != -1) {
            return attributes;
        }
        AttributesImpl attrs = new AttributesImpl();
        if (attributes != null) {
            attrs.setAttributes(attributes);
        }
        String prefix = this.getPrefixForURI("http://www.w3.org/2001/XMLSchema-instance", "xsi");
        attrs.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", String.valueOf(prefix) + ":type", "CDATA", this.qName2String(type));
        return attrs;
    }

    public void serializeActual(QName name, Attributes attributes, Object value, Class javaType) throws IOException {
        if (value != null) {
            TypeMapping tm = this.getTypeMapping();
            if (tm == null) {
                throw new IOException(JavaUtils.getMessage("noSerializer00", value.getClass().getName(), "" + this));
            }
            Class_Serializer pair = this.getSerializer(javaType, value);
            if (pair != null) {
                QName type = tm.getTypeQName(pair.javaType);
                attributes = this.setTypeAttribute(attributes, type);
                pair.ser.serialize(name, attributes, value, this);
                return;
            }
            throw new IOException(JavaUtils.getMessage("noSerializer00", value.getClass().getName(), "" + this));
        }
    }

    private Class_Serializer getSerializer(Class javaType, Object value) {
        Class_Serializer pair = null;
        SerializerFactory serFactory = null;
        TypeMapping tm = this.getTypeMapping();
        ArrayList classes = null;
        boolean firstPass = true;
        Class<Object> _class = javaType;
        while (_class != null) {
            try {
                serFactory = (SerializerFactory)tm.getSerializer(_class);
            }
            catch (JAXRPCException jAXRPCException) {
                // empty catch block
            }
            if (serFactory != null) break;
            if (classes == null) {
                classes = new ArrayList();
            }
            Class<?>[] ifaces = _class.getInterfaces();
            int i = 0;
            while (i < ifaces.length) {
                classes.add(ifaces[i]);
                ++i;
            }
            if ((_class = _class.getSuperclass()) != null && !_class.getName().equals("java.lang.Object")) {
                classes.add(_class);
            }
            Class<Object> clazz = _class = !classes.isEmpty() ? (Class<Object>)classes.remove(0) : null;
            if (_class != null || value == null || value.getClass() == javaType || !firstPass) continue;
            firstPass = false;
            _class = value.getClass();
        }
        Serializer ser = null;
        if (serFactory != null) {
            try {
                ser = (Serializer)serFactory.getSerializerAs("Axis SAX Mechanism");
            }
            catch (JAXRPCException jAXRPCException) {
                // empty catch block
            }
        }
        if (ser != null) {
            pair = new Class_Serializer();
            pair.ser = ser;
            pair.javaType = _class;
        }
        return pair;
    }

    class Class_Serializer {
        Serializer ser;
        Class javaType;

        Class_Serializer() {
        }
    }
}

