/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.List;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.Constants;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.fromJava.Types;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class ArraySerializer
implements Serializer {
    protected static Log log;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.encoding.ser.ArraySerializer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
    }

    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context) throws IOException {
        boolean isEncoded;
        Class<?> componentType;
        if (value == null) {
            throw new IOException(JavaUtils.getMessage("cantDoNullArray00"));
        }
        Class<?> cls = value.getClass();
        List list = null;
        if (!cls.isArray()) {
            if (!(value instanceof List)) {
                throw new IOException(JavaUtils.getMessage("cantSerialize00", cls.getName()));
            }
            list = (List)value;
        }
        if (list == null) {
            componentType = cls.getComponentType();
        } else {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            componentType = clazz;
        }
        String dims = "";
        while (componentType.isArray() && context.getQNameForClass(componentType).equals(Constants.SOAP_ARRAY)) {
            componentType = componentType.getComponentType();
            dims = String.valueOf(dims) + "[]";
        }
        QName componentQName = context.getQNameForClass(componentType);
        if (componentQName == null) {
            throw new IOException(JavaUtils.getMessage("noType00", componentType.getName()));
        }
        String prefix = context.getPrefixForURI(componentQName.getNamespaceURI());
        String compType = String.valueOf(prefix) + ":" + componentQName.getLocalPart();
        int len = list == null ? Array.getLength(value) : list.size();
        String arrayType = String.valueOf(compType) + dims + "[" + len + "]";
        int dim2Len = -1;
        boolean enable2Dim = true;
        if (enable2Dim && !dims.equals("") && cls.isArray() && len > 0) {
            boolean okay = true;
            int i = 0;
            while (i < len && okay) {
                Object elementValue = Array.get(value, i);
                if (elementValue == null) {
                    okay = false;
                } else if (dim2Len < 0) {
                    dim2Len = Array.getLength(elementValue);
                    if (dim2Len <= 0) {
                        okay = false;
                    }
                } else if (dim2Len != Array.getLength(elementValue)) {
                    okay = false;
                }
                ++i;
            }
            if (okay) {
                dims = dims.substring(0, dims.length() - 2);
                arrayType = String.valueOf(compType) + dims + "[" + len + "," + dim2Len + "]";
            } else {
                dim2Len = -1;
            }
        }
        if (isEncoded = context.getMessageContext().isEncoded()) {
            int typeI;
            AttributesImpl attrs = attributes != null ? new AttributesImpl(attributes) : new AttributesImpl();
            if (attrs.getIndex("http://schemas.xmlsoap.org/soap/encoding/", "arrayType") == -1) {
                String encprefix = context.getPrefixForURI("http://schemas.xmlsoap.org/soap/encoding/");
                attrs.addAttribute("http://schemas.xmlsoap.org/soap/encoding/", "arrayType", String.valueOf(encprefix) + ":arrayType", "CDATA", arrayType);
            }
            if ((typeI = attrs.getIndex("http://www.w3.org/2001/XMLSchema-instance", "type")) != -1) {
                String qname = String.valueOf(context.getPrefixForURI("http://www.w3.org/2001/XMLSchema-instance", "xsi")) + ":type";
                attrs.setAttribute(typeI, "http://www.w3.org/2001/XMLSchema-instance", "type", qname, "CDATA", context.qName2String(Constants.SOAP_ARRAY));
            }
            attributes = attrs;
        }
        QName elementName = name;
        if (isEncoded) {
            context.startElement(name, attributes);
            elementName = new QName("", "item");
        }
        if (dim2Len < 0) {
            int index = 0;
            while (index < len) {
                Object aValue = list == null ? Array.get(value, index) : list.get(index);
                Class<?> aClass = aValue == null ? null : aValue.getClass();
                context.serialize(elementName, null, aValue, aClass);
                ++index;
            }
        } else {
            int index = 0;
            while (index < len) {
                int index2 = 0;
                while (index2 < dim2Len) {
                    Object aValue = Array.get(Array.get(value, index), index2);
                    Class<?> aClass = aValue == null ? null : aValue.getClass();
                    context.serialize(elementName, null, aValue, aClass);
                    ++index2;
                }
                ++index;
            }
        }
        if (isEncoded) {
            context.endElement();
        }
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    public boolean writeSchema(Types types) throws Exception {
        return false;
    }
}

