/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.io.Serializable;
import java.util.HashMap;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.DeserializerImpl;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.ser.BeanPropertyDescriptor;
import org.apache.axis.encoding.ser.BeanPropertyTarget;
import org.apache.axis.encoding.ser.BeanSerializer;
import org.apache.axis.encoding.ser.SimpleDeserializer;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.utils.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BeanDeserializer
extends DeserializerImpl
implements Deserializer,
Serializable {
    protected static Log log;
    QName xmlType;
    Class javaType;
    private HashMap propertyMap = new HashMap();
    private TypeDesc typeDesc = null;
    protected int collectionIndex = -1;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.encoding.ser.BeanDeserializer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
    }

    public BeanDeserializer(Class javaType, QName xmlType) {
        this.xmlType = xmlType;
        this.javaType = javaType;
        BeanPropertyDescriptor[] pd = BeanSerializer.getPd(javaType);
        int i = 0;
        while (i < pd.length) {
            BeanPropertyDescriptor descriptor = pd[i];
            this.propertyMap.put(descriptor.getName(), descriptor);
            this.propertyMap.put(JavaUtils.xmlNameToJava(descriptor.getName()), descriptor);
            ++i;
        }
        this.typeDesc = TypeDesc.getTypeDescForClass(javaType);
        try {
            this.value = javaType.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SOAPHandler onStartChild(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        BeanPropertyDescriptor propDesc = null;
        if (this.typeDesc != null) {
            QName elemQName = new QName(namespace, localName);
            String fieldName = this.typeDesc.getFieldNameForElement(elemQName);
            propDesc = (BeanPropertyDescriptor)this.propertyMap.get(fieldName);
        }
        if (propDesc == null) {
            propDesc = (BeanPropertyDescriptor)this.propertyMap.get(localName);
        }
        if (propDesc == null) {
            propDesc = (BeanPropertyDescriptor)this.propertyMap.get(JavaUtils.xmlNameToJava(localName));
        }
        if (propDesc == null) {
            throw new SAXException(JavaUtils.getMessage("badElem00", this.javaType.getName(), localName));
        }
        QName qn = context.getTypeFromAttributes(namespace, localName, attributes);
        Deserializer dSer = context.getDeserializerForType(qn);
        if (dSer == null) {
            dSer = new DeserializerImpl();
            TypeMapping tm = context.getTypeMapping();
            Class type = propDesc.getType();
            dSer.setDefaultType(tm.getTypeQName(type));
        }
        if (propDesc.getWriteMethod().getParameterTypes().length == 1) {
            this.collectionIndex = -1;
            dSer.registerValueTarget(new BeanPropertyTarget(this.value, propDesc));
        } else {
            ++this.collectionIndex;
            dSer.registerValueTarget(new BeanPropertyTarget(this.value, propDesc, this.collectionIndex));
        }
        return (SOAPHandler)((Object)dSer);
    }

    public void onStartElement(String namespace, String localName, String qName, Attributes attributes, DeserializationContext context) throws SAXException {
        if (this.typeDesc == null) {
            return;
        }
        int i = 0;
        while (i < attributes.getLength()) {
            QName attrQName = new QName(attributes.getURI(i), attributes.getLocalName(i));
            String fieldName = this.typeDesc.getFieldNameForAttribute(attrQName);
            if (fieldName != null) {
                String attrName = attributes.getLocalName(i);
                BeanPropertyDescriptor bpd = (BeanPropertyDescriptor)this.propertyMap.get(fieldName);
                if (bpd != null && bpd.getWriteMethod() != null) {
                    Class type;
                    TypeMapping tm = context.getTypeMapping();
                    QName qn = tm.getTypeQName(type = bpd.getType());
                    if (qn == null) {
                        throw new SAXException(JavaUtils.getMessage("unregistered00", type.toString()));
                    }
                    Deserializer dSer = context.getDeserializerForType(qn);
                    if (dSer == null) {
                        throw new SAXException(JavaUtils.getMessage("noDeser00", type.toString()));
                    }
                    if (!(dSer instanceof SimpleDeserializer)) {
                        throw new SAXException(JavaUtils.getMessage("AttrNotSimpleType00", bpd.getName(), type.toString()));
                    }
                    if (bpd.getWriteMethod().getParameterTypes().length == 1) {
                        try {
                            Object val = ((SimpleDeserializer)dSer).makeValue(attributes.getValue(i));
                            bpd.getWriteMethod().invoke(this.value, val);
                        }
                        catch (Exception e) {
                            throw new SAXException(e);
                        }
                    }
                }
            }
            ++i;
        }
    }
}

