/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.InternalException;
import org.apache.axis.description.FieldDesc;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.encoding.ser.BeanPropertyDescriptor;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.fromJava.FieldRep;
import org.apache.axis.wsdl.fromJava.Types;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class BeanSerializer
implements Serializer,
Serializable {
    protected static Log log;
    public static final Object[] noArgs;
    QName xmlType;
    Class javaType;
    private BeanPropertyDescriptor[] propertyDescriptor = null;
    private TypeDesc typeDesc = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.encoding.ser.BeanSerializer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        noArgs = new Object[0];
    }

    public BeanSerializer(Class javaType, QName xmlType) {
        this.xmlType = xmlType;
        this.javaType = javaType;
        this.propertyDescriptor = BeanSerializer.getPd(javaType);
        this.typeDesc = TypeDesc.getTypeDescForClass(javaType);
    }

    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context) throws IOException {
        boolean isSOAP_ENC = Constants.isSOAP_ENC(context.getMessageContext().getEncodingStyle());
        Attributes beanAttrs = this.getObjectAttributes(value, attributes, context);
        context.startElement(name, beanAttrs);
        try {
            int i = 0;
            while (i < this.propertyDescriptor.length) {
                block12: {
                    Method readMethod;
                    QName qname;
                    String propName;
                    block13: {
                        FieldDesc field;
                        propName = this.propertyDescriptor[i].getName();
                        if (propName.equals("class")) break block12;
                        qname = null;
                        if (this.typeDesc == null || (field = this.typeDesc.getFieldByName(propName)) == null) break block13;
                        if (!field.isElement()) break block12;
                        qname = field.getXmlName();
                    }
                    if (qname == null) {
                        qname = new QName("", propName);
                    }
                    if ((readMethod = this.propertyDescriptor[i].getReadMethod()) != null && readMethod.getParameterTypes().length == 0) {
                        Object propValue = this.propertyDescriptor[i].getReadMethod().invoke(value, noArgs);
                        context.serialize(qname, null, propValue, this.propertyDescriptor[i].getReadMethod().getReturnType());
                    } else {
                        int j = 0;
                        while (j >= 0) {
                            Object propValue = null;
                            try {
                                propValue = this.propertyDescriptor[i].getReadMethod().invoke(value, new Integer(j));
                                ++j;
                            }
                            catch (Exception e) {
                                j = -1;
                            }
                            if (j < 0) continue;
                            context.serialize(qname, null, propValue, this.propertyDescriptor[i].getReadMethod().getReturnType());
                        }
                    }
                }
                ++i;
            }
        }
        catch (InvocationTargetException ite) {
            Throwable target = ite.getTargetException();
            log.error((Object)JavaUtils.getMessage("exception00"), target);
            throw new IOException(target.toString());
        }
        catch (Exception e) {
            log.error((Object)JavaUtils.getMessage("exception00"), (Throwable)e);
            throw new IOException(e.toString());
        }
        context.endElement();
    }

    static BeanPropertyDescriptor[] getPd(Class javaType) {
        BeanPropertyDescriptor[] pd;
        try {
            PropertyDescriptor[] rawPd = Introspector.getBeanInfo(javaType).getPropertyDescriptors();
            pd = BeanPropertyDescriptor.processPropertyDescriptors(rawPd, javaType);
        }
        catch (Exception e) {
            throw new InternalException(e);
        }
        return pd;
    }

    static Vector getBeanAttributes(Class javaType, TypeDesc typeDesc) {
        Vector<String> ret = new Vector<String>();
        if (typeDesc == null) {
            try {
                Method getAttributeElements = javaType.getMethod("getAttributeElements", new Class[0]);
                String[] array = (String[])getAttributeElements.invoke(null, noArgs);
                ret = new Vector(array.length);
                int i = 0;
                while (i < array.length) {
                    ret.add(array[i]);
                    ++i;
                }
            }
            catch (Exception e) {
                ret.clear();
            }
        } else {
            FieldDesc[] fields = typeDesc.getFields();
            if (fields != null) {
                int i = 0;
                while (i < fields.length) {
                    FieldDesc field = fields[i];
                    if (!field.isElement()) {
                        ret.add(field.getFieldName());
                    }
                    ++i;
                }
            }
        }
        return ret;
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    /*
     * Unable to fully structure code
     */
    public boolean writeSchema(Types types) throws Exception {
        qName = types.getWsdlQName(this.xmlType);
        complexType = types.createElement("complexType");
        types.writeSchemaElement(qName, complexType);
        complexType.setAttribute("name", qName.getLocalPart());
        e = null;
        superClass = this.javaType.getSuperclass();
        stopClasses = types.getStopClasses();
        if (superClass == null) ** GOTO lbl-1000
        v0 = BeanSerializer.class$1;
        if (v0 == null) {
            try {
                v0 = BeanSerializer.class$1 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException v1) {
                throw new NoClassDefFoundError(v1.getMessage());
            }
        }
        if (!(superClass == v0 || stopClasses != null && stopClasses.contains(superClass.getName()))) {
            base = types.writeType(superClass);
            complexContent = types.createElement("complexContent");
            complexType.appendChild(complexContent);
            extension = types.createElement("extension");
            complexContent.appendChild(extension);
            extension.setAttribute("base", base);
            e = extension;
        } else lbl-1000:
        // 2 sources

        {
            e = complexType;
        }
        all = types.createElement("sequence");
        e.appendChild(all);
        clsRep = types.getBeanBuilder().build(this.javaType);
        fields = clsRep.getFields();
        i = 0;
        while (i < fields.size()) {
            field = (FieldRep)fields.elementAt(i);
            name = field.getName();
            name = String.valueOf(name.substring(0, 1).toLowerCase()) + name.substring(1);
            if (this.typeDesc != null && (fieldDesc = this.typeDesc.getFieldByName(field.getName())) != null) {
                if (!fieldDesc.isElement()) {
                    attrName = this.typeDesc.getAttributeNameForField(field.getName());
                    this.writeAttribute(types, attrName.getLocalPart(), field.getType(), complexType);
                } else {
                    xmlName = this.typeDesc.getElementNameForField(field.getName());
                    if (xmlName != null) {
                        xmlName.getNamespaceURI();
                        name = xmlName.getLocalPart();
                    }
                }
                return true;
            }
            this.writeField(types, name, field.getType(), field.getIndexed(), all);
            ++i;
        }
        return true;
    }

    private void writeField(Types types, String fieldName, Class fieldType, boolean isUnbounded, Element where) throws Exception {
        String elementType = types.writeType(fieldType);
        Element elem = types.createElement(fieldName, elementType, types.isNullable(fieldType), where.getOwnerDocument());
        if (isUnbounded) {
            elem.setAttribute("maxOccurs", "unbounded");
        }
        where.appendChild(elem);
    }

    private void writeAttribute(Types types, String fieldName, Class fieldType, Element where) throws Exception {
        if (!types.isSimpleSchemaType(fieldType)) {
            throw new AxisFault(JavaUtils.getMessage("AttrNotSimpleType00", fieldName, fieldType.getName()));
        }
        String elementType = types.writeType(fieldType);
        Element elem = types.createAttributeElement(fieldName, elementType, false, where.getOwnerDocument());
        where.appendChild(elem);
    }

    private Attributes getObjectAttributes(Object value, Attributes attributes, SerializationContext context) {
        if (this.typeDesc == null || !this.typeDesc.hasAttributes()) {
            return attributes;
        }
        AttributesImpl attrs = attributes != null ? new AttributesImpl(attributes) : new AttributesImpl();
        try {
            int i = 0;
            while (i < this.propertyDescriptor.length) {
                FieldDesc field;
                String propName = this.propertyDescriptor[i].getName();
                if (!propName.equals("class") && (field = this.typeDesc.getFieldByName(propName)) != null && !field.isElement()) {
                    Object propValue;
                    Method readMethod;
                    QName qname = field.getXmlName();
                    if (qname == null) {
                        qname = new QName("", propName);
                    }
                    if ((readMethod = this.propertyDescriptor[i].getReadMethod()) != null && readMethod.getParameterTypes().length == 0 && (propValue = readMethod.invoke(value, noArgs)) != null) {
                        String propString = propValue.toString();
                        String namespace = qname.getNamespaceURI();
                        String localName = qname.getLocalPart();
                        attrs.addAttribute(namespace, localName, context.qName2String(qname), "CDATA", propString);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            return attrs;
        }
        return attrs;
    }
}

