/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.encoding.ser.SimpleDeserializer;
import org.apache.axis.utils.JavaUtils;

public class DateDeserializer
extends SimpleDeserializer {
    private static SimpleDateFormat zulu = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static Calendar calendar = new GregorianCalendar();

    static {
        zulu.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public DateDeserializer(Class javaType, QName xmlType) {
        super(javaType, xmlType);
    }

    public Object makeValue(String source) {
        Date result;
        boolean bc = false;
        if (source != null) {
            if (source.charAt(0) == '+') {
                source = source.substring(1);
            }
            if (source.charAt(0) == '-') {
                source = source.substring(1);
                bc = true;
            }
            if (source.length() < 19) {
                throw new NumberFormatException(JavaUtils.getMessage("badDateTime00"));
            }
            if (source.charAt(4) != '-' || source.charAt(7) != '-' || source.charAt(10) != 'T') {
                throw new NumberFormatException(JavaUtils.getMessage("badDate00"));
            }
            if (source.charAt(13) != ':' || source.charAt(16) != ':') {
                throw new NumberFormatException(JavaUtils.getMessage("badTime00"));
            }
        }
        try {
            result = zulu.parse(source == null ? null : String.valueOf(source.substring(0, 19)) + ".000Z");
        }
        catch (Exception e) {
            throw new NumberFormatException(e.toString());
        }
        int pos = 19;
        if (source != null) {
            if (pos < source.length() && source.charAt(pos) == '.') {
                int milliseconds = 0;
                int start = ++pos;
                while (pos < source.length() && Character.isDigit(source.charAt(pos))) {
                    ++pos;
                }
                String decimal = source.substring(start, pos);
                if (decimal.length() == 3) {
                    milliseconds = Integer.parseInt(decimal);
                } else if (decimal.length() < 3) {
                    milliseconds = Integer.parseInt((String.valueOf(decimal) + "000").substring(0, 3));
                } else {
                    milliseconds = Integer.parseInt(decimal.substring(0, 3));
                    if (decimal.charAt(3) >= '5') {
                        ++milliseconds;
                    }
                }
                result.setTime(result.getTime() + (long)milliseconds);
            }
            if (pos + 5 < source.length() && (source.charAt(pos) == '+' || source.charAt(pos) == '-')) {
                if (!(Character.isDigit(source.charAt(pos + 1)) && Character.isDigit(source.charAt(pos + 2)) && source.charAt(pos + 3) == ':' && Character.isDigit(source.charAt(pos + 4)) && Character.isDigit(source.charAt(pos + 5)))) {
                    throw new NumberFormatException(JavaUtils.getMessage("badTimezone00"));
                }
                int hours = (source.charAt(pos + 1) - 48) * 10 + source.charAt(pos + 2) - 48;
                int mins = (source.charAt(pos + 4) - 48) * 10 + source.charAt(pos + 5) - 48;
                int milliseconds = (hours * 60 + mins) * 60 * 1000;
                if (source.charAt(pos) == '+') {
                    milliseconds = -milliseconds;
                }
                result.setTime(result.getTime() + (long)milliseconds);
                pos += 6;
            }
            if (pos < source.length() && source.charAt(pos) == 'Z') {
                ++pos;
            }
            if (pos < source.length()) {
                throw new NumberFormatException(JavaUtils.getMessage("badChars00"));
            }
        }
        if (bc) {
            Calendar calendar = DateDeserializer.calendar;
            synchronized (calendar) {
                DateDeserializer.calendar.setTime(result);
                DateDeserializer.calendar.set(0, 0);
                result = DateDeserializer.calendar.getTime();
            }
        }
        return result;
    }
}

