/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.rpc.namespace.QName;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.wsdl.fromJava.Types;
import org.xml.sax.Attributes;

public class DateSerializer
implements Serializer {
    private static SimpleDateFormat zulu = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static Calendar calendar = new GregorianCalendar();

    static {
        zulu.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context) throws IOException {
        String fdate;
        context.startElement(name, attributes);
        Calendar calendar = DateSerializer.calendar;
        synchronized (calendar) {
            DateSerializer.calendar.setTime((Date)value);
            if (DateSerializer.calendar.get(0) == 0) {
                context.writeString("-");
                DateSerializer.calendar.setTime((Date)value);
                DateSerializer.calendar.set(0, 1);
                value = DateSerializer.calendar.getTime();
            }
            fdate = zulu.format((Date)value);
        }
        context.writeString(fdate);
        context.endElement();
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    public boolean writeSchema(Types types) throws Exception {
        return false;
    }
}

